/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.communication.api;

import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.communication.api.ClientListener;
import de.proveo.idm.remote.server.communication.api.ClientWatchdog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class ConnectionReader
extends Thread {
    private static final Logger log = Logger.getLogger(ConnectionReader.class.getName());
    private final List<ClientListener> clientListeners = new ArrayList<ClientListener>();
    private final Object clientListenersLock = new Object();
    private volatile boolean compression = true;
    private volatile boolean running = true;
    private EFMServer server;
    private ObjectInputStream objectInputStream;
    private ClientWatchdog clientWatchdog;

    public ConnectionReader(EFMServer server, ObjectInputStream ois, ClientWatchdog clientWatchdog) {
        super("ConnectionReader");
        this.server = server;
        this.objectInputStream = ois;
        this.clientWatchdog = clientWatchdog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientListener(ClientListener clientListener) {
        Object object = this.clientListenersLock;
        synchronized (object) {
            this.clientListeners.add(clientListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientListener(ClientListener clientListener) {
        Object object = this.clientListenersLock;
        synchronized (object) {
            this.clientListeners.remove(clientListener);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void disconnect() {
        this.running = false;
        this.clientListeners.clear();
        log.info("ConnectionReader disconnected, will be deleted by garbage collector!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block8: {
            String method = "run(): ";
            try {
                while (this.running) {
                    try {
                        Object event = this.objectInputStream.readObject();
                        if (this.compression) {
                            event = this.uncompressEvent(event);
                        }
                        if (event == null || !this.running) continue;
                        this.forwardEvent(event);
                    }
                    catch (IOException ioe) {
                        if (!this.running) {
                            log.log(Level.INFO, "{0}Connection closed", method);
                            continue;
                        }
                        log.log(Level.INFO, "{0}Error while reading from ObjectInputStream", method);
                        if (this.clientWatchdog == null) continue;
                        this.clientWatchdog.onConnectionError(ioe);
                    }
                    catch (ClassNotFoundException cnfe) {
                        log.log(Level.SEVERE, method + "runs into ClassNotFoundException:", cnfe);
                    }
                }
            }
            catch (Throwable ex) {
                log.log(Level.SEVERE, "Unexpected exception while reading from HTTP stream", ex);
                if (!this.running || this.clientWatchdog == null) break block8;
                this.clientWatchdog.onConnectionError(ex);
            }
        }
        this.running = false;
    }

    protected void finalize() throws Throwable {
        log.log(Level.INFO, "{0} deleted by garbage collector!", this.toString());
        super.finalize();
    }

    private Object uncompressEvent(Object event) {
        Object uncompressedEvent;
        try {
            ByteArrayInputStream arrayInputStream = new ByteArrayInputStream((byte[])event);
            GZIPInputStream gZIPinputStream = new GZIPInputStream(arrayInputStream);
            ObjectInputStream ois = new ObjectInputStream(gZIPinputStream);
            uncompressedEvent = ois.readObject();
            gZIPinputStream.close();
            ois.close();
        }
        catch (Throwable e) {
            log.log(Level.INFO, "The received event seems to be uncompressed, deactivating compression and returning the original Object", e);
            this.compression = false;
            return event;
        }
        return uncompressedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardEvent(Object event) {
        block11: {
            String method = "forwardEvent(): ";
            try {
                long currentTime = System.currentTimeMillis();
                if (this.clientWatchdog != null) {
                    this.clientWatchdog.onEventReceived(currentTime);
                }
                if (event instanceof String) {
                    if (((String)event).equals("p")) {
                        log.log(Level.FINE, "{0}client received ping signal", method);
                        this.clientWatchdog.onPingReceived(currentTime);
                    } else {
                        log.log(Level.SEVERE, "{0}client received unknown string object ''{1}''", new Object[]{method, event});
                    }
                    break block11;
                }
                if (!(event instanceof Long)) break block11;
                long serverTime = (Long)event;
                if (serverTime > 0L) {
                    log.log(Level.FINE, "{0}client received server timestamp for time sync", method);
                    Object object = this.clientListenersLock;
                    synchronized (object) {
                        for (ClientListener cl : this.clientListeners) {
                            cl.onServerTime(serverTime);
                        }
                        break block11;
                    }
                }
                log.log(Level.SEVERE, "{0}client received Ping with server time ''{1}''", new Object[]{method, serverTime});
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, method + "Error while trying to handle and forward event!", e);
                if (!this.running || this.clientWatchdog == null) break block11;
                this.clientWatchdog.onConnectionError(e);
            }
        }
    }
}

