/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api.impl;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.idm.core.gui.navigation.NavigationTopComponent;
import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteDevice;
import de.proveo.idm.core.gui.navigation.api.Server;
import de.proveo.idm.core.gui.navigation.api.ServerNavigationItem;
import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationLoadingException;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationNotPresentException;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationSavingException;
import de.proveo.idm.core.gui.navigation.api.exceptions.InvalidDeviceConfigurationException;
import de.proveo.idm.core.gui.navigation.api.exceptions.NotConnectedException;
import de.proveo.idm.core.gui.navigation.api.exceptions.PositionNotPresentException;
import de.proveo.idm.core.gui.navigation.api.exceptions.VersionNotPresentException;
import de.proveo.idm.core.gui.navigation.api.impl.AbstractNavigationItem;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.Configuration;
import de.proveo.idm.core.util.VersionsCompareUtil;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.EFMServerUnitAdministration;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.UnitTreeElement;
import de.proveo.idm.remote.server.api.ZeroConfUnit;
import de.proveo.idm.remote.server.gui.UnitSelectionPanel;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.services.ShaSumGenerator;
import de.proveo.idm.remote.server.util.RemoteUpdateHandler;
import de.proveo.idm.remote.server.util.TreeUtil;
import de.proveo.util.geo.GPSPosition;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ZeroConfUnitImpl
extends AbstractNavigationItem
implements ZeroConfUnit {
    private static final String ICON_BASE_PREFIX = "de/proveo/idm/remote/server/resources/units/zeroconf_";
    private static final String ICON_BASE_ASSIGNED_SUFFIX = "_assigned";
    private static final String ICON_BASE_SUFFIX = ".png";
    private static final String DEFAULT_ICON_BASE = "de/proveo/idm/remote/server/resources/units/zeroconf_Unknown.png";
    private static final String DEFAULT_ASSIGNED_ICON_BASE = "de/proveo/idm/remote/server/resources/units/zeroconf_Unknown_assigned.png";
    private Device.DeviceType type;
    private EFMServer server;
    private RemoteDeviceId id;
    private SortedMap<String, Object> attributes;
    private final String iconBase;
    private int zeroconfId;

    public ZeroConfUnitImpl(EFMServer server, RemoteDeviceId id, SortedMap<String, Object> attributes) {
        super(id.getSerialNumber(), null);
        this.server = server;
        this.id = id;
        this.attributes = attributes;
        String devType = (String)this.attributes.get("deviceType");
        this.type = Device.DeviceType.nameOf((String)devType);
        if (this.type == null) {
            this.type = devType == null || devType.trim().length() == 0 ? Device.DeviceType.INFOMAN : Device.DeviceType.UNKNOWN;
        }
        this.iconBase = this.findIcon();
        this.zeroconfId = (Integer)this.attributes.get("zeroconfId");
    }

    private String findIcon() {
        String iconStr;
        String suffix = ICON_BASE_SUFFIX;
        String defaultIconBase = DEFAULT_ICON_BASE;
        if (this.getUnitId() != -1L) {
            defaultIconBase = DEFAULT_ASSIGNED_ICON_BASE;
            suffix = "_assigned.png";
        }
        if (ImageUtilities.loadImage((String)(iconStr = ICON_BASE_PREFIX + this.getDeviceType().toString() + suffix)) == null) {
            iconStr = defaultIconBase;
        }
        return iconStr;
    }

    public Configuration openConfiguration(SoftwareBundle bundle) throws NotConnectedException, ConfigurationLoadingException, ConfigurationNotPresentException, InvalidDeviceConfigurationException {
        return new Configuration(String.format("%s (%s)", this.getDeviceType().toString(), this.getSerialNumber()), new Properties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveConfiguration(File configuration) throws NotConnectedException, InvalidDeviceConfigurationException, ConfigurationSavingException {
        if (configuration != null) {
            try {
                if (!Device.DeviceType.INFOMAN.equals((Object)this.getDeviceType())) {
                    throw new ConfigurationSavingException("Saving configuration to other device than Infoman not supported yet!");
                }
                DatasyncTaskValue task = RemoteUpdateHandler.createDatasyncTask(this.getEFMServer().getCapabilities().contains(Capability.RESOURCE_OVERVIEW), false, false, this.getUnitId(), this.getSerialNumber(), "1.12.0", this.getDeviceType(), "Software", this.server.getRemoteUpdateAdapter(), this.server.getTimeZoneID(), null);
                if (task == null) return false;
                List<DatasyncResourceValue> resources = this.createConfigurationUpdateResources(this.fileToByteArray(configuration), "1.12.0", configuration.getName());
                task.setClientSerialNumber(this.getDeviceType().toString() + ":" + this.getSerialNumber());
                task.setResources(resources);
                task = this.server.getRemoteUpdateAdapter().createTask(this.getDeviceType(), task);
                if (task != null) {
                    DialogUtil.showInfoDialog((Object)NbBundle.getMessage(ZeroConfUnitImpl.class, (String)"ZeroConfUnitImpl.Tasks.scheduledtask", (Object)new Date(task.getValidFrom())));
                    return false;
                }
                DialogUtil.showErrorDialog((Object)NbBundle.getMessage(ZeroConfUnitImpl.class, (String)"ZeroConfUnitImpl.Tasks.scheduleTaskFailed"));
                return false;
            }
            catch (Exception ex) {
                throw new ConfigurationSavingException("Failed to assign zero conf unit.", (Throwable)ex);
            }
        }
        try {
            Device.DeviceType deviceType = this.getDeviceType();
            UnitTreeElement tree = this.server.getUnits();
            if (deviceType == null || deviceType == Device.DeviceType.UNKNOWN) {
                deviceType = Device.DeviceType.ANY;
            }
            NavigationItem nav = TreeUtil.createNavigationTree(tree, deviceType);
            UnitSelectionPanel panel = new UnitSelectionPanel(deviceType);
            panel.setUnits(nav);
            Object n = DialogUtil.showOkCancelQuestionDialog((Object)panel, (String)NbBundle.getMessage(ZeroConfUnitImpl.class, (String)"ZeroConfUnitImpl.UnitSelectionPanel.title"));
            while (DialogUtil.OK_OPTION.equals(n)) {
                NavigationItem item = panel.getSelectedUnit();
                if (item != null && item instanceof RemoteDevice) {
                    RemoteDevice infoman = (RemoteDevice)item;
                    String hardwareNumber = this.getSerialNumber();
                    EFMServerUnitAdministration unitAdministration = this.server.getUnitAdministration();
                    if (Device.DeviceType.INFOMAN.equals((Object)deviceType)) {
                        String version = infoman.getSoftwareVersion();
                        Configuration config = infoman.openConfiguration(null);
                        Properties properties = config.getProperties();
                        properties.setProperty("wwt.unitData.infomanSN", hardwareNumber);
                        List<DatasyncResourceValue> resources = this.createConfigurationUpdateResources(this.propertiesToByteArray(properties), version, config.getFilename());
                        DatasyncTaskValue task = new DatasyncTaskValue();
                        task.setValidFrom(System.currentTimeMillis());
                        task.setClientSerialNumber(this.getDeviceType().toString() + ":" + this.getSerialNumber());
                        task.setResources(resources);
                        task.setIdentifier("REMOTE_UPDATE");
                        task = this.server.getRemoteUpdateAdapter().createTask(this.getDeviceType(), task);
                        if (task == null) {
                            DialogUtil.showErrorDialog((Object)NbBundle.getMessage(ZeroConfUnitImpl.class, (String)"ZeroConfUnitImpl.Tasks.scheduleTaskFailed"));
                            return false;
                        }
                        DialogUtil.showInfoDialog((Object)NbBundle.getMessage(ZeroConfUnitImpl.class, (String)"ZeroConfUnitImpl.Tasks.scheduledtask", (Object)new Date(task.getValidFrom())));
                    } else if (Device.DeviceType.INFOMAN_EFM.equals((Object)deviceType)) {
                        unitAdministration.setIMEI(infoman.getUnitId(), hardwareNumber);
                        unitAdministration.setSerialNumber(infoman.getUnitId(), hardwareNumber);
                    } else {
                        unitAdministration.setSerialNumber(infoman.getUnitId(), hardwareNumber);
                    }
                    unitAdministration.assignToUnit(this.getDeviceType(), hardwareNumber, infoman.getUnitId());
                    ServerNavigationItem serverItem = NavigationTopComponent.findInstance().findServerNavigationItemByServer((Server)this.server);
                    if (!(serverItem instanceof EFMServerNavigationItem)) return true;
                    TreeUtil.refreshTreeForServerItem((EFMServerNavigationItem)serverItem);
                    return true;
                }
                DialogUtil.showErrorDialog((Object)NbBundle.getMessage(ZeroConfUnitImpl.class, (String)"ZeroConfUnitImpl.wrongSelection.title"), (String)NbBundle.getMessage(ZeroConfUnitImpl.class, (String)"ZeroConfUnitImpl.wrongSelection.msg"));
                n = DialogUtil.showOkCancelQuestionDialog((Object)panel, (String)NbBundle.getMessage(ZeroConfUnitImpl.class, (String)"ZeroConfUnitImpl.UnitSelectionPanel.title"));
            }
            return false;
        }
        catch (Exception ex) {
            throw new ConfigurationSavingException("Failed to assign zero conf unit.", (Throwable)ex);
        }
    }

    private List<DatasyncResourceValue> createConfigurationUpdateResources(byte[] config, String version, String cfgName) throws Exception {
        String checksum = ShaSumGenerator.createSHA1Sum(config);
        DatasyncResourceValue zeroConfResource = new DatasyncResourceValue();
        ArrayList<DatasyncMetainfoValue> metaInfos = new ArrayList<DatasyncMetainfoValue>();
        DatasyncMetainfoValue info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
        info.setValue("SHA1");
        metaInfos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CHECKSUM.toString());
        info.setValue(checksum);
        metaInfos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.FILE_NAME.toString());
        info.setValue(cfgName);
        metaInfos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.TYPE.toString());
        info.setValue("INFOMAN_CONFIG");
        metaInfos.add(info);
        if (VersionsCompareUtil.isVersionGreaterOrEqual((String)version, (String)"1.12.0")) {
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
            info.setValue("text/plain");
            metaInfos.add(info);
        } else {
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
            info.setValue("CONFIG");
            metaInfos.add(info);
        }
        zeroConfResource.setMetainfos(metaInfos);
        zeroConfResource.setChecksum(checksum);
        zeroConfResource.setResource(config);
        zeroConfResource.setValidFrom(System.currentTimeMillis());
        zeroConfResource.setResourceName(cfgName);
        ArrayList<DatasyncResourceValue> zeroConfResources = new ArrayList<DatasyncResourceValue>();
        zeroConfResources.add(zeroConfResource);
        return zeroConfResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] propertiesToByteArray(Properties properties) {
        ByteArrayOutputStream bOut = null;
        try {
            bOut = new ByteArrayOutputStream();
            properties.store(bOut, null);
            bOut.flush();
            byte[] byArray = bOut.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bOut);
        }
    }

    protected byte[] fileToByteArray(File configuration) {
        try {
            return FileUtils.readFileToByteArray((File)configuration);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Device.DeviceType getDeviceType() {
        return this.type;
    }

    public String getName() {
        String ret;
        try {
            ret = (String)this.getEnv().get("productSerialNumber");
        }
        catch (Exception ex) {
            return this.getSerialNumber();
        }
        if (ret == null) {
            ret = this.getSerialNumber();
        }
        return ret;
    }

    public String getIconBaseWithExtension() {
        return this.iconBase;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ZeroConfUnitImpl) {
            ZeroConfUnitImpl other = (ZeroConfUnitImpl)obj;
            if (this.hashCode() == other.hashCode()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getSerialNumber());
        builder.append((Object)this.type);
        return builder.toHashCode();
    }

    @Override
    public EFMServer getEFMServer() {
        return this.server;
    }

    @Override
    public RemoteDeviceId getId() {
        return this.id;
    }

    public long getUnitId() {
        return this.id.getUnitId();
    }

    public String getSerialNumber() {
        return this.id.getSerialNumber();
    }

    public String getSoftwareVersion() throws NotConnectedException, VersionNotPresentException {
        throw new VersionNotPresentException("No supported for ZeroConfUnits");
    }

    public GPSPosition getPosition() throws PositionNotPresentException {
        try {
            return this.server.getZeroConfPositionById(this.zeroconfId);
        }
        catch (Exception ex) {
            throw new PositionNotPresentException("Failed to load position from server", (Throwable)ex);
        }
    }

    public boolean isVisibleOnMap() {
        try {
            if (this.server.getCapabilities().contains(Capability.MAPPING)) {
                return this.getPosition() != null;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public SortedMap<String, Object> getEnv() throws Exception {
        return this.attributes != null ? this.attributes : new TreeMap<String, Object>();
    }
}

