/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api.impl;

import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.remote.server.api.LoginDataProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class LoginDataProviderImpl
implements LoginDataProvider {
    private static final Logger log = Logger.getLogger(LoginDataProviderImpl.class.getName());
    private static final Icon EFM_LOGIN_IMAGE = new ImageIcon(LoginDataProviderImpl.class.getResource("/de/proveo/idm/remote/server/resources/login_efm_left.png"));

    @Override
    public Credentials getLoginData(String name, String host) {
        String msg = NbBundle.getMessage(LoginDataProviderImpl.class, (String)"LoginDataProvider.msg", (Object)name);
        String title = NbBundle.getMessage(LoginDataProviderImpl.class, (String)"LoginDataProvider.title");
        String propKey = "efm.server." + host;
        Preferences prefs = NbPreferences.forModule(LoginDataProvider.class);
        String username = prefs.get(propKey + ".username", "");
        Credentials cred = DialogUtil.showLoginDialog((String)msg, (String)title, (String)(propKey + ".%s"), (String)username, (Icon)EFM_LOGIN_IMAGE, (Icon)DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT);
        if (cred != null) {
            prefs.put(propKey + ".username", cred.getUsername());
            try {
                prefs.flush();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Could not save username for host " + host, ex);
            }
        }
        return cred;
    }
}

