/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api.impl;

import de.proveo.util.connection.ssl.EasySSLProtocolSocketFactory;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.openide.util.NetworkSettings;

@Deprecated
public class HttpClientFactory {
    private static final Logger log = Logger.getLogger(HttpClientFactory.class.getName());

    public static void configureHttpClient(HttpClient httpClient, String protocol, String host, int lPort, int rPort, String path, int connectTimeout, int soTimeout) throws Exception {
        HttpClientParams params = httpClient.getParams();
        params.setConnectionManagerTimeout((long)connectTimeout);
        params.setSoTimeout(soTimeout);
        params.setContentCharset("UTF-8");
        params.setCredentialCharset("UTF-8");
        params.setHttpElementCharset("UTF-8");
        URI uri = new URI(protocol + "://" + host + ":" + lPort + (path == null || path.trim().length() == 0 ? "" : (path.startsWith("/") ? path : "/" + path)));
        HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
        hostConfiguration.setHost(host, lPort, protocol);
        String proxyHost = NetworkSettings.getProxyHost((URI)uri);
        if (proxyHost != null) {
            String proxyPort = NetworkSettings.getProxyPort((URI)uri);
            String proxyUser = NetworkSettings.getAuthenticationUsername((URI)uri);
            String proxyPass = NetworkSettings.getKeyForAuthenticationPassword((URI)uri);
            boolean proxyAuthEnabled = NetworkSettings.isAuthenticationDialogSuppressed();
            log.info("Setup proxy...");
            if (!proxyAuthEnabled && proxyUser != null && proxyUser.trim().length() != 0) {
                params.setParameter("http.authentication.credential-provider", (Object)new ProxyAuthenticationProvider(proxyUser, proxyPass, ""));
                params.setAuthenticationPreemptive(true);
                log.info("Proxy authentication configured.");
            } else {
                log.info("Proxy without authentication.");
            }
            hostConfiguration.setProxy(proxyHost, Integer.parseInt(proxyPort));
            log.info("Proxy configuration set.");
        }
        httpClient.setHostConfiguration(hostConfiguration);
        httpClient.setParams(params);
        HttpConnectionManager mgr = httpClient.getHttpConnectionManager();
        HttpConnectionManagerParams connectionManagerParams = mgr.getParams();
        connectionManagerParams.setConnectionTimeout(connectTimeout);
        connectionManagerParams.setSoTimeout(soTimeout);
        connectionManagerParams.setStaleCheckingEnabled(true);
        mgr.setParams(connectionManagerParams);
        if (protocol.startsWith("https")) {
            EasySSLProtocolSocketFactory psf = new EasySSLProtocolSocketFactory();
            Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)psf, rPort);
            Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        }
    }

    private static class ProxyAuthenticationProvider
    implements CredentialsProvider {
        String domain;
        String password;
        String user;

        public ProxyAuthenticationProvider(String user, String password, String domain) {
            this.user = user;
            this.password = password;
            this.domain = domain;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            if (authscheme == null) {
                return null;
            }
            try {
                if (authscheme instanceof NTLMScheme) {
                    log.log(Level.INFO, "{0}:{1} requires Windows authentication, return NTLM credentials", new Object[]{host, port});
                    return new NTCredentials(this.user, this.password, host, this.domain);
                }
                if (authscheme instanceof RFC2617Scheme) {
                    log.log(Level.INFO, "{0}:{1} requires authentication with the realm ''{2}'', return USER/PASS credentials", new Object[]{host, port, authscheme.getRealm()});
                    return new UsernamePasswordCredentials(this.user, this.password);
                }
                log.log(Level.SEVERE, "Unsupported authentication scheme: {0}", new Object[]{authscheme.getSchemeName()});
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

