/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api.impl;

import de.proveo.idm.core.gui.navigation.api.Credentials;
import java.net.URI;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.openide.util.NetworkSettings;

public class HttpClient4Factory {
    private static final Logger log = Logger.getLogger(HttpClient4Factory.class.getName());
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    public static final String HTTPS_PROTOCOL = "https";
    public static final String HTTP_PROTOCOL = "http";

    public static HttpClient createHttpsClient(URL url, Credentials credentials) {
        int port = url.getPort();
        if (port <= 0) {
            port = 443;
        }
        PoolingClientConnectionManager ccm = new PoolingClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)ccm);
        try {
            HttpClient4Factory.configureHttpClient(httpClient, HTTPS_PROTOCOL, url.getHost(), port, port, url.getFile(), 60000, 60000);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not configure HttpClient!", ex);
            try {
                HttpClient4Factory.registerSSLScheme((HttpClient)httpClient, port);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not register SSLSocketFactory HttpClient!", ex);
            }
        }
        UsernamePasswordCredentials login = new UsernamePasswordCredentials(credentials.getUsername(), new String(credentials.getPassword()));
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(url.getHost(), port), (org.apache.http.auth.Credentials)login);
        return httpClient;
    }

    private static void registerSSLScheme(HttpClient httpClient, int port) throws Exception {
        TrustStrategy ts = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        };
        SSLSocketFactory sf = new SSLSocketFactory(ts, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Scheme sslScheme = new Scheme(HTTPS_PROTOCOL, port, (SchemeSocketFactory)sf);
        log.log(Level.INFO, "Register SSL scheme for port {0} ...", port);
        SchemeRegistry sr = httpClient.getConnectionManager().getSchemeRegistry();
        sr.register(sslScheme);
        log.log(Level.INFO, "SSL scheme for port {0} registered", port);
    }

    public static void configureHttpClient(DefaultHttpClient httpClient, String protocol, String host, int lPort, int rPort, String path, int connectTimeout, int soTimeout) throws Exception {
        HttpParams params = httpClient.getParams();
        params.setIntParameter("http.connection.timeout", connectTimeout);
        params.setIntParameter("http.socket.timeout", soTimeout);
        params.setBooleanParameter("http.socket.keepalive", Boolean.TRUE.booleanValue());
        URI uri = new URI(protocol + "://" + host + ":" + lPort + (path == null || path.trim().length() == 0 ? "" : (path.startsWith("/") ? path : "/" + path)));
        String proxyHost = NetworkSettings.getProxyHost((URI)uri);
        if (proxyHost != null) {
            String proxyPort = NetworkSettings.getProxyPort((URI)uri);
            String proxyUser = NetworkSettings.getAuthenticationUsername((URI)uri);
            String proxyPass = NetworkSettings.getKeyForAuthenticationPassword((URI)uri);
            boolean proxyAuthEnabled = NetworkSettings.isAuthenticationDialogSuppressed();
            log.info("Setup proxy...");
            if (!proxyAuthEnabled && proxyUser != null && proxyUser.trim().length() != 0) {
                UsernamePasswordCredentials login = new UsernamePasswordCredentials(proxyUser, proxyPass);
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, Integer.parseInt(proxyPort)), (org.apache.http.auth.Credentials)login);
                log.info("Proxy authentication configured.");
            } else {
                log.info("Proxy without authentication.");
            }
            HttpHost proxy = new HttpHost(proxyHost, Integer.parseInt(proxyPort), HTTP_PROTOCOL);
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            log.info("Proxy configuration set.");
        }
        if (protocol.startsWith(HTTPS_PROTOCOL)) {
            HttpClient4Factory.registerSSLScheme((HttpClient)httpClient, rPort);
        }
    }
}

