/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api.impl;

import de.proveo.client.configuration.api.ConfigurationProvider;
import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.EFMServerData;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.IDMLoginResponse;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.push.api.DataStorage;
import de.proveo.idm.remote.server.push.impl.DataStorageImpl;
import de.proveo.idm.ssh.service.SSHConnection;
import de.proveo.util.geo.GPSPosition;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public abstract class AbstractEFMServer
implements EFMServer {
    private static final Logger log = Logger.getLogger(AbstractEFMServer.class.getName());
    protected static final int CONNECT_TIMEOUT = 60000;
    public static final String HTTPS_PROTOCOL = "https";
    public static final String HTTP_PROTOCOL = "http";
    public static final String LOCALHOST = "localhost";
    public static final int DEFAULT_HTTP_CONNECTION_PORT = 8080;
    public static final int DEFAULT_HTTPS_CONNNECTION_PORT = 443;
    protected String name = null;
    protected URL serverURL = null;
    protected Collection<String> tunnel = null;
    protected Collection<String> infomanTunnel = null;
    protected volatile IDMLoginResponse loginResponse = null;
    protected Credentials loginCredentials = null;
    protected Collection<RemoteInfoman> units = null;
    protected SSHConnection connection = null;
    protected List<Capability> capabilities = null;
    protected DataStorage dataStorage = null;
    protected EFMServerData serverData;

    public AbstractEFMServer(EFMServerData serverData) {
        this.serverData = serverData;
        this.setName(this.serverData.getServername());
        this.setURL(this.serverData.getUrl());
        this.setTunnel(this.serverData.getTunnel());
        this.setInfomanTunnel(this.serverData.getInfomanTunnel());
        this.units = new ArrayList<RemoteInfoman>();
        this.capabilities = new ArrayList<Capability>();
    }

    public Collection<String> getInfomanTunnel() {
        return this.infomanTunnel;
    }

    public void setInfomanTunnel(Collection<String> tunnel) {
        this.infomanTunnel = tunnel;
    }

    public Collection<String> getTunnel() {
        if (this.tunnel == null) {
            return Collections.emptyList();
        }
        return this.tunnel;
    }

    public void setTunnel(Collection<String> tunnel) {
        this.tunnel = tunnel;
    }

    @Override
    public synchronized void logoff() {
        this.loginResponse = null;
        this.loginCredentials = null;
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        log.log(Level.INFO, "EFM server ''{0}'' was logged off.", this.getName());
    }

    public void setURL(String url) {
        try {
            this.serverURL = new URL(url);
            int port = this.serverURL.getPort();
            if (port == -1) {
                String protocol = this.serverURL.getProtocol();
                this.serverURL = protocol.equals(HTTP_PROTOCOL) ? new URL(protocol, this.serverURL.getHost(), 8080, this.serverURL.getFile()) : new URL(protocol, this.serverURL.getHost(), 443, this.serverURL.getFile());
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.serverURL.toString();
    }

    public Credentials getIDMCredentials() {
        return this.loginCredentials;
    }

    @Override
    public Collection<RemoteInfoman> getServerUnits() {
        return this.units;
    }

    @Override
    public EFMServerData getServerData() {
        return this.serverData;
    }

    @Override
    public IDMLoginResponse getLoginResponse() {
        return this.loginResponse;
    }

    public Collection<Capability> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public ConfigurationProvider getConfigurationProvider() {
        return this.serverData.getConfigurationProvider();
    }

    @Override
    public DataStorage getDataStorage() {
        if (this.dataStorage == null) {
            this.dataStorage = new DataStorageImpl(this);
        }
        return this.dataStorage;
    }

    public String getExtraProperty(String key) {
        return this.getExtraProperty(key, null);
    }

    public String getExtraProperty(String key, String defaultValue) {
        return this.serverData.getExtraProperty(key, defaultValue);
    }

    @Override
    public boolean isUnitVisibleOnMap(long unitId) throws Exception {
        return false;
    }

    @Override
    public String getUnitPosition(long unitId) throws Exception {
        return null;
    }

    @Override
    public void updateServerTime(long st) {
    }

    @Override
    public void resetServerTime() {
    }

    @Override
    public GPSPosition getZeroConfPositionById(int id) throws Exception {
        return null;
    }
}

