/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api;

import de.proveo.idm.core.gui.navigation.api.Device;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class UnitTreeElement {
    private static final String DEFAULT_UNIT_ICON = "Infoman.png";
    private static final String ICON_BASE_PREFIX = "de/proveo/idm/remote/server/resources/units/";
    private static final String ICON_BASE_SUFFIX = ".png";
    private static final Logger log = Logger.getLogger(UnitTreeElement.class.getName());
    private List<UnitTreeElement> children;
    private Object containedObject;
    private String iconBase;

    public UnitTreeElement(Object containedObject) {
        this.containedObject = containedObject;
    }

    public UnitTreeElement(Object containedObject, String iconBase) {
        this(containedObject);
        this.iconBase = iconBase;
    }

    public List<UnitTreeElement> getChildren() {
        return this.children;
    }

    public void setChildren(List<UnitTreeElement> children) {
        this.children = children;
    }

    public Object getContainedObject() {
        return this.containedObject;
    }

    public String getIconBase() {
        return this.iconBase;
    }

    public void setIconBase(String iconBase) {
        this.iconBase = iconBase;
    }

    public static String lookupIconBase(Class clazz, String name, Device.DeviceType deviceType) {
        if (name == null) {
            return UnitTreeElement.findIconForDeviceType(deviceType);
        }
        try {
            int index = name.lastIndexOf(".");
            String iconType = name.substring(index + 1, name.length());
            return NbBundle.getMessage((Class)clazz, (String)iconType);
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "No icon with name " + name + " found in Infoman Remote module with Bundle class " + clazz + ". Will return default icon", ex);
            }
            return UnitTreeElement.findIconForDeviceType(deviceType);
        }
    }

    private static String findIconForDeviceType(Device.DeviceType deviceType) {
        String iconStr = deviceType.toString() + ICON_BASE_SUFFIX;
        if (ImageUtilities.loadImage((String)(ICON_BASE_PREFIX + iconStr)) == null) {
            iconStr = DEFAULT_UNIT_ICON;
        }
        return iconStr;
    }
}

