/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api;

import de.proveo.idm.remote.server.api.EFMServerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Lookup;

public class EFMServerManager {
    public static final String AUTO_VERSION = "Auto";

    public Map<String, EFMServerFactory> getAvailableServerAdapters() {
        HashMap<String, EFMServerFactory> serverFactories = new HashMap<String, EFMServerFactory>();
        Collection factories = Lookup.getDefault().lookupAll(EFMServerFactory.class);
        if (factories != null) {
            for (EFMServerFactory factory : factories) {
                serverFactories.put(factory.getName(), factory);
            }
        }
        return serverFactories;
    }

    public List<String> getSupportedVersions(boolean includeAuto) {
        Map<String, EFMServerFactory> serverFactories = this.getAvailableServerAdapters();
        ArrayList<String> versions = new ArrayList<String>();
        if (includeAuto && !serverFactories.isEmpty()) {
            versions.add(AUTO_VERSION);
        }
        versions.addAll(serverFactories.keySet());
        return versions;
    }

    public List<String> getSupportedVersions() {
        return this.getSupportedVersions(true);
    }
}

