/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.actions.server;

import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.AbstractNavigationItem;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.IDMLoginResponse;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.util.TreeUtil;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RefreshTreeAction
extends AbstractAction
implements ContextAwareAction {
    private static final Logger log = Logger.getLogger(RefreshTreeAction.class.getName());
    private Lookup lookup;
    private EFMServerNavigationItem item;

    public RefreshTreeAction() {
        super(NbBundle.getMessage(RefreshTreeAction.class, (String)"RefreshTreeAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.item == null && this.lookup != null) {
            this.item = this.getServerNavigationItem(this.lookup);
        }
        TreeUtil.refreshTreeForServerItem(this.item);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        RefreshTreeAction ret = new RefreshTreeAction();
        ret.lookup = actionContext;
        EFMServerNavigationItem serverItem = this.getServerNavigationItem(actionContext);
        if (serverItem != null) {
            EFMServer server = serverItem.getServerInstance();
            IDMLoginResponse response = null;
            if (server != null) {
                response = server.getLoginResponse();
            }
            ret.item = serverItem;
            ret.setEnabled(!serverItem.isConnecting() && response != null && response.isAccessPermitted());
        } else {
            ret.setEnabled(false);
        }
        return ret;
    }

    private EFMServerNavigationItem getServerNavigationItem(Lookup lookup) {
        EFMServerNavigationItem serverItem = (EFMServerNavigationItem)lookup.lookup(EFMServerNavigationItem.class);
        if (serverItem == null) {
            NavigationItem parent;
            for (parent = (NavigationItem)lookup.lookup(AbstractNavigationItem.class); parent != null && !(parent instanceof EFMServerNavigationItem); parent = parent.getParent()) {
            }
            if (parent != null && parent instanceof EFMServerNavigationItem) {
                serverItem = (EFMServerNavigationItem)parent;
            }
            if (serverItem == null) {
                for (parent = (NavigationItem)lookup.lookup(NavigationItem.class); parent != null && !(parent instanceof EFMServerNavigationItem); parent = parent.getParent()) {
                }
                if (parent != null && parent instanceof EFMServerNavigationItem) {
                    serverItem = (EFMServerNavigationItem)parent;
                }
            }
        }
        return serverItem;
    }
}

