/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.actions.infoman;

import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.AbstractNavigationItem;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.ThreadPool;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SetCallbackFlagAction
extends AbstractAction
implements ContextAwareAction {
    private static final Logger log = Logger.getLogger(SetCallbackFlagAction.class.getName());
    private Lookup lookup;
    private EFMServer server;

    public SetCallbackFlagAction() {
        super(NbBundle.getMessage(SetCallbackFlagAction.class, (String)"SetCallbackFlagAction.name"));
    }

    public void setServer(EFMServer server) {
        this.server = server;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final RemoteInfoman infoman = (RemoteInfoman)this.lookup.lookup(RemoteInfoman.class);
        final EFMServer efmServer = this.server;
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String displayName = NbBundle.getMessage(SetCallbackFlagAction.class, (String)"SetCallbackFlagAction.progress.title", (Object)infoman.getName());
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)displayName);
                handle.start();
                handle.switchToIndeterminate();
                try {
                    efmServer.getUnitAdministration().setCallbackFlag(infoman.getUnitId());
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Set callback flag runs into", ex);
                    String msg = NbBundle.getMessage(SetCallbackFlagAction.class, (String)"SetCallbackFlagAction.error", (Object)infoman.getName());
                    DialogUtil.showErrorDialog((Object)msg);
                }
                finally {
                    handle.finish();
                }
            }
        };
        ThreadPool.getInstance().execute(runner);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        NavigationItem item;
        SetCallbackFlagAction ret = new SetCallbackFlagAction();
        ret.lookup = actionContext;
        for (item = (NavigationItem)ret.lookup.lookup(AbstractNavigationItem.class); item != null && !(item instanceof EFMServerNavigationItem); item = item.getParent()) {
        }
        if (item != null) {
            EFMServer efmServer = ((EFMServerNavigationItem)item).getServerInstance();
            ret.setEnabled(efmServer.getCapabilities().contains(Capability.MANAGE_INFOMAN_CALLBACK));
            ret.setServer(efmServer);
        }
        return ret;
    }
}

