/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.actions;

import de.proveo.idm.core.gui.navigation.api.EFMServerData;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationManager;
import de.proveo.idm.core.gui.navigation.api.ServerRoot;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.remote.server.api.EFMServerManager;
import de.proveo.idm.remote.server.gui.AddServerPanel;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddServerAction
extends AbstractAction
implements ContextAwareAction {
    private static final Logger log = Logger.getLogger(AddServerAction.class.getName());
    private Lookup lookup;

    public AddServerAction() {
        super(NbBundle.getMessage(AddServerAction.class, (String)"AddServerAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String title;
        ServerRoot root = (ServerRoot)this.lookup.lookup(ServerRoot.class);
        EFMServerManager sMgr = (EFMServerManager)Lookup.getDefault().lookup(EFMServerManager.class);
        AddServerPanel panel = new AddServerPanel(sMgr.getSupportedVersions());
        Object option = DialogUtil.showMessageDialog((Object)panel, (String)(title = NbBundle.getMessage(AddServerAction.class, (String)"AddServerAction.name")), (boolean)true, (int)-1, (int)2);
        if (DialogUtil.OK_OPTION.equals(option)) {
            String serverName = panel.getServerName();
            String serverURL = panel.getServerURL();
            String version = panel.getVersion();
            if (serverName.trim().isEmpty()) {
                serverName = serverURL;
            }
            EFMServerData data = new EFMServerData(serverName, serverURL);
            data.setVersion(version);
            EFMServerNavigationItem item = new EFMServerNavigationItem(data);
            item.setParent((NavigationItem)root);
            RemoteNavigationManager navigationItemManager = (RemoteNavigationManager)Lookup.getDefault().lookup(RemoteNavigationManager.class);
            navigationItemManager.store();
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        AddServerAction ret = new AddServerAction();
        ret.lookup = actionContext;
        return ret;
    }
}

