/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.ManageGroupsPanel;
import org.netbeans.modules.project.ui.groups.NewGroupPanel;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class GroupsMenu
extends AbstractAction {
    private static final RequestProcessor RP = new RequestProcessor(GroupsMenu.class.getName());
    private static final String HELPCTX = "org.netbeans.modules.project.ui.groups.GroupsMenu";

    public GroupsMenu() {
        super(Bundle.GroupsMenu_label());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GroupsMenu.manageGroups();
    }

    private static void newGroup() {
        final NewGroupPanel panel = new NewGroupPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.GroupsMenu_new_title());
        panel.setNotificationLineSupport(dd.createNotificationLineSupport());
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(HELPCTX));
        final JButton create = new JButton(Bundle.GroupsMenu_new_create());
        create.setDefaultCapable(true);
        create.setEnabled(panel.isReady());
        panel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ready".equals(evt.getPropertyName())) {
                    create.setEnabled(panel.isReady());
                }
            }
        });
        JButton cancel = new JButton(Bundle.GroupsMenu_new_cancel());
        dd.setOptions(new Object[]{create, cancel});
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(create)) {
            assert (panel.isReady());
            final NewGroupPanel.Type type = panel.getSelectedType();
            final boolean autoSync = panel.isAutoSyncField();
            final boolean useOpen = panel.isUseOpenedField();
            final String name = panel.getNameField();
            final String masterProject = panel.getMasterProjectField();
            final String directory = panel.getDirectoryField();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Group g = NewGroupPanel.create(type, name, autoSync, useOpen, masterProject, directory);
                    Group.setActiveGroup(g, true);
                }
            });
        }
    }

    private static void manageGroups() {
        final ManageGroupsPanel panel = new ManageGroupsPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.GroupsMenu_manage_title());
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(HELPCTX));
        final JButton select = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)select, (String)Bundle.GroupsMenu_manage_select_group());
        select.setDefaultCapable(true);
        panel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selection")) {
                    select.setEnabled(panel.isExactlyOneGroupSelected());
                }
            }
        });
        select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        Group.setActiveGroup(panel.getSelectedGroups()[0], false);
                    }
                });
            }
        });
        JButton newGroup = new JButton();
        newGroup.setDefaultCapable(false);
        Mnemonics.setLocalizedText((AbstractButton)newGroup, (String)Bundle.GroupsMenu_manage_new_group());
        newGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupsMenu.newGroup();
            }
        });
        JButton cancel = new JButton(Bundle.GroupsMenu_new_cancel());
        cancel.setDefaultCapable(false);
        dd.setOptions(new Object[]{select, newGroup, cancel});
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
    }

    static void openProperties(Group g) {
        Lookup context = Lookups.fixed((Object[])new Object[]{g, Utilities.ACCESSOR.createGroup(g.getName(), g.prefs())});
        Dialog dialog = ProjectCustomizer.createCustomizerDialog((String)"Projects/Groups/Customizer", (Lookup)context, (String)null, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        }, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        }, (HelpCtx)new HelpCtx(HELPCTX));
        dialog.setTitle(Bundle.GroupsMenu_properties_title());
        dialog.setModal(true);
        dialog.setVisible(true);
    }
}

