/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.io.PrintStream;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.spi.sendopts.Arg;
import org.netbeans.spi.sendopts.ArgsProcessor;
import org.netbeans.spi.sendopts.Description;
import org.netbeans.spi.sendopts.Env;

public class GroupOptionProcessor
implements ArgsProcessor {
    @Arg(longName="open-group")
    @Description(displayName="#GroupOptionProcessor.open.name", shortDescription="#GroupOptionProcessor.open.desc")
    public String openOption;
    @Arg(longName="close-group")
    @Description(shortDescription="#GroupOptionProcessor.close.desc")
    public boolean closeOption;
    @Arg(longName="list-groups")
    @Description(shortDescription="#GroupOptionProcessor.list.desc")
    public boolean listOption;

    public void process(Env env) throws CommandException {
        if (this.openOption != null) {
            for (Group g : Group.allGroups()) {
                if (!g.id.equals(this.openOption) && !g.getName().equals(this.openOption)) continue;
                this.supressWinsysLazyLoading();
                Group.setActiveGroup(g, false);
                return;
            }
            throw new CommandException(2, Bundle.GroupOptionProcessor_no_such_group(this.openOption));
        }
        if (this.closeOption) {
            Group.setActiveGroup(null, false);
        } else if (this.listOption) {
            int max_size = Bundle.GroupOptionProcessor_column_id().length();
            for (Group g : Group.allGroups()) {
                max_size = Math.max(max_size, g.id.length());
            }
            PrintStream ps = env.getOutputStream();
            ps.printf("%-" + max_size + "s  %s\n", Bundle.GroupOptionProcessor_column_id(), Bundle.GroupOptionProcessor_column_name());
            for (Group g : Group.allGroups()) {
                ps.printf("%-" + max_size + "s  %s\n", g.id, g.getName());
            }
        }
    }

    private void supressWinsysLazyLoading() {
        String oldValue = System.getProperty("nb.core.windows.no.lazy.loading");
        if (oldValue != null) {
            System.setProperty("group.supresses.lazy.loading", oldValue);
        }
        System.setProperty("nb.core.windows.no.lazy.loading", "true");
    }
}

