/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.modules.project.ui.actions.VerticalGridLayout;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SetMainProject
extends ProjectAction
implements PropertyChangeListener {
    private static final String PROJECT_KEY = "org.netbeans.modules.project.ui.MainProjectItem";
    private static final String CONTEXT_MENU_ITEM_ENABLED = "setMainProjectContextEnabled";
    private static RequestProcessor RP = new RequestProcessor(SetMainProject.class);
    protected JMenu subMenu;
    private boolean empty;

    private static Preferences prefs() {
        return NbPreferences.forModule(SetMainProject.class);
    }

    public SetMainProject() {
        this((Lookup)null);
    }

    public SetMainProject(Lookup context) {
        super(SetMainProject.class.getName(), Bundle.LBL_SetAsMainProjectAction_Name(), null, context);
        if (context == null) {
            OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        }
        this.putValue("hideWhenDisabled", true);
        this.refresh(this.getLookup(), true);
    }

    @Override
    protected void actionPerformed(Lookup context) {
        final Pair<List<Project>, List<FileObject>> data = ActionsUtil.mineFromLookup(context);
        RP.post(new Runnable(){

            @Override
            public void run() {
                Project[] projects = ActionsUtil.getProjects((Pair<List<Project>, List<FileObject>>)data);
                if (projects.length == 1) {
                    if (projects[0] == OpenProjectList.getDefault().getMainProject()) {
                        OpenProjectList.getDefault().setMainProject(null);
                    } else {
                        OpenProjectList.getDefault().setMainProject(projects[0]);
                    }
                }
            }
        });
    }

    @Override
    public final void refresh(Lookup context, boolean immediate) {
        super.refresh(context, immediate);
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length != 1) {
            this.setEnabled(false);
        } else {
            Project main = OpenProjectList.getDefault().getMainProject();
            this.setEnabled(SetMainProject.prefs().getBoolean(CONTEXT_MENU_ITEM_ENABLED, main != null));
            if (projects[0] == main) {
                this.putValue("popupText", Bundle.LBL_UnSetAsMainProjectAction_Name());
            } else {
                this.putValue("popupText", null);
            }
        }
        this.empty = projects.length == 0;
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new SetMainProject(actionContext);
    }

    @Override
    public JMenuItem getMenuPresenter() {
        this.createSubMenu(OpenProjectList.getDefault().getOpenProjects());
        return this.subMenu;
    }

    @Override
    public JMenuItem getPopupPresenter() {
        if (this.empty) {
            this.subMenu = null;
            return this.getMenuPresenter();
        }
        return super.getPopupPresenter();
    }

    private void createSubMenu(Project[] projects) {
        Arrays.sort(projects, OpenProjectList.projectByDisplayName());
        if (projects.length == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        if (this.subMenu == null) {
            this.subMenu = new JMenu(Bundle.LBL_SetMainProjectAction_Name());
            this.subMenu.getPopupMenu().setLayout(new VerticalGridLayout());
            this.subMenu.setMnemonic(Bundle.MNE_SetMainProjectAction_Name().charAt(0));
            this.subMenu.putClientProperty(SetMainProject.class, this);
        }
        this.subMenu.removeAll();
        MenuItemActionListener jmiActionListener = new MenuItemActionListener();
        JRadioButtonMenuItem jmiNone = new JRadioButtonMenuItem((Icon)null, false);
        Mnemonics.setLocalizedText((AbstractButton)jmiNone, (String)Bundle.LBL_NoneMainProject_Name());
        jmiNone.addActionListener(jmiActionListener);
        this.subMenu.add(jmiNone);
        this.subMenu.add(new JPopupMenu.Separator());
        for (int i = 0; i < projects.length; ++i) {
            ProjectInformation pi = ProjectUtils.getInformation((Project)projects[i]);
            JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(pi.getDisplayName(), pi.getIcon(), false);
            this.subMenu.add(jmi);
            jmi.putClientProperty(PROJECT_KEY, projects[i]);
            jmi.addActionListener(jmiActionListener);
        }
        this.selectMainProject();
        this.subMenu.setEnabled(projects.length > 0);
    }

    private void selectMainProject() {
        boolean prjSelected = false;
        AbstractButton noneItem = null;
        for (int i = 0; i < this.subMenu.getItemCount(); ++i) {
            JMenuItem jmi = this.subMenu.getItem(i);
            if (jmi == null) continue;
            Project project = (Project)jmi.getClientProperty(PROJECT_KEY);
            if (project == null) {
                noneItem = (JRadioButtonMenuItem)jmi;
            }
            if (!(jmi instanceof JRadioButtonMenuItem)) continue;
            if (OpenProjectList.getDefault().isMainProject(project)) {
                ((JRadioButtonMenuItem)jmi).setSelected(true);
                prjSelected = true;
                continue;
            }
            ((JRadioButtonMenuItem)jmi).setSelected(false);
        }
        if (!prjSelected && noneItem != null) {
            noneItem.setSelected(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("OpenProjects".equals(e.getPropertyName())) {
            final Project[] projects = OpenProjectList.getDefault().getOpenProjects();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SetMainProject.this.createSubMenu(projects);
                }
            });
        } else if ("MainProject".equals(e.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SetMainProject.this.subMenu != null) {
                        SetMainProject.this.selectMainProject();
                    }
                }
            });
        }
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)e.getSource();
                final Project project = (Project)jmi.getClientProperty(SetMainProject.PROJECT_KEY);
                SetMainProject.prefs().putBoolean(SetMainProject.CONTEXT_MENU_ITEM_ENABLED, project != null);
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        OpenProjectList.getDefault().setMainProject(project);
                    }
                });
            }
        }
    }
}

