/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.netbeans.modules.project.ui.actions.VerticalGridLayout;
import org.netbeans.spi.project.ProjectContainerProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;

public class OpenSubprojects
extends NodeAction
implements Presenter.Popup {
    private static final String ICON = "org/netbeans/modules/project/ui/resources/openProject.png";

    public String getName() {
        return Bundle.LBL_OpenSubprojectsAction_Name();
    }

    public String iconResource() {
        return ICON;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return true;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        boolean someSubprojects = false;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Project p = (Project)activatedNodes[i].getLookup().lookup(Project.class);
            if (p == null) {
                return false;
            }
            SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
            if (spp == null) continue;
            someSubprojects = true;
        }
        return someSubprojects;
    }

    protected void performAction(Node[] activatedNodes) {
        this.openAllRequiredProjects(activatedNodes);
    }

    public JMenuItem getPopupPresenter() {
        JMenu menu = new JMenu(Bundle.LBL_OpenSubprojectsAction_Name());
        Node[] activatedNodes = this.getActivatedNodes();
        Set subProjects = null;
        if (activatedNodes != null) {
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project p = (Project)activatedNodes[i].getLookup().lookup(Project.class);
                if (p == null) continue;
                ProjectContainerProvider pcp = (ProjectContainerProvider)p.getLookup().lookup(ProjectContainerProvider.class);
                if (pcp != null) {
                    subProjects = pcp.getContainedProjects().getProjects();
                    continue;
                }
                SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
                if (spp == null) continue;
                subProjects = spp.getSubprojects();
            }
        }
        if (subProjects != null && !subProjects.isEmpty()) {
            menu.getPopupMenu().setLayout(new VerticalGridLayout());
            JMenuItem openAllProjectsItem = new JMenuItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenSubprojects.this.openAllRequiredProjects(OpenSubprojects.this.getActivatedNodes());
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)openAllProjectsItem, (String)Bundle.OpenProjectMenu_Open_All_Projects());
            menu.add(openAllProjectsItem);
            menu.addSeparator();
        } else {
            JMenuItem nothingItem = new JMenuItem(Bundle.OpenProjectMenu_Nothing());
            nothingItem.setEnabled(false);
            menu.add(nothingItem);
        }
        if (subProjects != null && !subProjects.isEmpty()) {
            for (final Project prjIter : subProjects) {
                JMenuItem selectPrjAction = new JMenuItem(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OpenProjectList.getDefault().open(new Project[]{prjIter}, true, true);
                    }
                });
                selectPrjAction.setText(ProjectUtils.getInformation((Project)prjIter).getDisplayName());
                menu.add(selectPrjAction);
            }
        }
        return menu;
    }

    private void openAllRequiredProjects(Node[] activatedNodes) {
        if (activatedNodes != null) {
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project p = (Project)activatedNodes[i].getLookup().lookup(Project.class);
                if (p == null) continue;
                OpenProjectList.getDefault().open(new Project[]{p}, true, true);
            }
        }
    }
}

