/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.spi.embedding.JsEmbeddingProviderPlugin;
import org.netbeans.modules.html.knockout.KODataBindContext;
import org.netbeans.modules.html.knockout.KODataBindDescriptor;
import org.netbeans.modules.html.knockout.KODataBindTokenId;
import org.netbeans.modules.html.knockout.KOTemplateContext;
import org.netbeans.modules.html.knockout.model.KOModel;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.Pair;

public class KOJsEmbeddingProviderPlugin
extends JsEmbeddingProviderPlugin {
    private static final Logger LOGGER = Logger.getLogger(KOJsEmbeddingProviderPlugin.class.getName());
    private static final String WITH_BIND = "with";
    private static final String FOREACH_BIND = "foreach";
    private static final String TEMPLATE_BIND = "template";
    private TokenSequence<HTMLTokenId> tokenSequence;
    private Snapshot snapshot;
    private List<Embedding> embeddings;
    private final Language JS_LANGUAGE;
    private final LinkedList<StackItem> stack;
    private String lastTagOpen = null;
    private final Map<String, KOTemplateContext.TemplateUsage> templateUsages = new HashMap<String, KOTemplateContext.TemplateUsage>();
    private final List<TemplateBoundary> templateBoundaries = new LinkedList<TemplateBoundary>();
    private final KODataBindContext dataBindContext = new KODataBindContext();
    private final KOTemplateContext templateContext = new KOTemplateContext();
    private KODataBindContext currentTemplateContext;

    public KOJsEmbeddingProviderPlugin() {
        this.JS_LANGUAGE = Language.find((String)"text/javascript");
        this.stack = new LinkedList();
    }

    public boolean startProcessing(HtmlParserResult parserResult, Snapshot snapshot, TokenSequence<HTMLTokenId> tokenSequence, List<Embedding> embeddings) {
        this.snapshot = snapshot;
        this.tokenSequence = tokenSequence;
        this.embeddings = embeddings;
        return KOModel.getModel(parserResult).containsKnockout();
    }

    public void endProcessing() {
        int offset = 0;
        if (!this.embeddings.isEmpty()) {
            for (TemplateBoundary boundary : this.templateBoundaries) {
                if (boundary.isStart()) {
                    KOTemplateContext.TemplateUsage usage = this.templateUsages.get(boundary.getName());
                    if (usage != null) {
                        KODataBindContext context = usage.getContext();
                        String name = null;
                        LinkedHashSet<KOTemplateContext.TemplateUsage> hierarchy = new LinkedHashSet<KOTemplateContext.TemplateUsage>();
                        hierarchy.add(usage);
                        while (usage != null && (name = usage.getParentTemplateName()) != null && !hierarchy.contains(usage = this.templateUsages.get(name))) {
                            hierarchy.add(usage);
                            if (usage == null) continue;
                            context = KODataBindContext.combine(usage.getContext(), context);
                        }
                        this.startKnockoutSnippet(context, boundary.getPosition() + offset);
                        ++offset;
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "No usage for template {0}", boundary.getName());
                    continue;
                }
                this.endKnockoutSnippet(boundary.getPosition() + offset);
                ++offset;
            }
        }
        this.templateUsages.clear();
        this.templateBoundaries.clear();
        this.dataBindContext.clear();
        this.templateContext.clear();
        this.stack.clear();
        this.lastTagOpen = null;
    }

    public boolean processToken() {
        boolean processed = false;
        Pair<Boolean, String> templateCheck = this.templateContext.process((Token<HTMLTokenId>)this.tokenSequence.token());
        if (templateCheck != null) {
            this.currentTemplateContext = (Boolean)templateCheck.first() != false ? new KODataBindContext() : null;
        }
        String tokenText = this.tokenSequence.token().text().toString();
        switch ((HTMLTokenId)this.tokenSequence.token().id()) {
            case TAG_OPEN: {
                this.lastTagOpen = tokenText;
                StackItem top = this.stack.peek();
                if (top == null || !top.tag.equals(this.lastTagOpen)) break;
                ++top.balance;
                break;
            }
            case TAG_CLOSE: {
                StackItem top = this.stack.peek();
                if (top == null || !top.tag.equals(tokenText)) break;
                --top.balance;
                if (top.balance != 0) break;
                processed = true;
                this.stack.pop();
                String templateId = this.templateContext.getCurrentScriptId();
                if (templateId != null) {
                    this.currentTemplateContext.pop();
                    break;
                }
                this.dataBindContext.pop();
                break;
            }
            case VALUE: {
                TokenSequence embedded = this.tokenSequence.embedded(KODataBindTokenId.language());
                boolean setData = false;
                boolean setTemplate = false;
                if (embedded == null) break;
                String templateId = this.templateContext.getCurrentScriptId();
                if (templateId != null) {
                    this.templateBoundaries.add(new TemplateBoundary(templateId, this.embeddings.size(), true));
                }
                embedded.moveStart();
                Token dataValue = null;
                boolean foreach = false;
                while (embedded.moveNext()) {
                    String embeddedText;
                    boolean putParenthesis;
                    if (embedded.token().id() == KODataBindTokenId.KEY) {
                        if (WITH_BIND.equals(embedded.token().text().toString()) || FOREACH_BIND.equals(embedded.token().text().toString())) {
                            this.stack.push(new StackItem(this.lastTagOpen));
                            setData = true;
                            foreach = FOREACH_BIND.equals(embedded.token().text().toString());
                        } else if (TEMPLATE_BIND.equals(embedded.token().text().toString())) {
                            setTemplate = true;
                        }
                    }
                    if (setData && embedded.token().id() == KODataBindTokenId.VALUE && dataValue == null) {
                        dataValue = embedded.token();
                    }
                    if (setTemplate && embedded.token().id() == KODataBindTokenId.VALUE && dataValue == null) {
                        KODataBindContext context = this.currentTemplateContext != null ? this.currentTemplateContext : this.dataBindContext;
                        KODataBindContext templateBindContext = new KODataBindContext(context);
                        KODataBindDescriptor desc = KODataBindDescriptor.getDataBindDescriptor(this.snapshot, (TokenSequence<? extends JsTokenId>)embedded.embedded(JsTokenId.javascriptLanguage()), false);
                        if (desc != null) {
                            templateBindContext.push(desc.getData(), desc.isIsForEach(), desc.getAlias());
                            String templateName = desc.getName();
                            KOTemplateContext.TemplateUsage usage = this.templateUsages.get(templateName);
                            if (usage == null) {
                                usage = new KOTemplateContext.TemplateUsage(templateBindContext);
                                if (templateId != null) {
                                    usage.addParentTemplateName(templateId);
                                }
                                this.templateUsages.put(templateName, usage);
                            } else {
                                KODataBindContext current = usage.getContext();
                                if (Objects.equals(current.getOriginal(), context)) {
                                    current.setData(current.getData() + " || " + templateBindContext.getData());
                                } else {
                                    LOGGER.log(Level.INFO, "Multiple incompatible template usage; storing the last one");
                                    usage = new KOTemplateContext.TemplateUsage(templateBindContext);
                                    if (templateId != null) {
                                        usage.addParentTemplateName(templateId);
                                    }
                                    this.templateUsages.put(templateName, usage);
                                }
                            }
                        } else {
                            LOGGER.log(Level.INFO, "Cannot get the template name at design time; ignoring");
                        }
                    }
                    if (embedded.embedded(this.JS_LANGUAGE) == null) continue;
                    processed = true;
                    if (templateId == null) {
                        this.startKnockoutSnippet(this.dataBindContext);
                    }
                    boolean bl = putParenthesis = !(embeddedText = embedded.token().text().toString()).trim().isEmpty() && !embeddedText.trim().endsWith(";");
                    if (putParenthesis) {
                        this.embeddings.add(this.snapshot.create((CharSequence)"(", "text/javascript"));
                    }
                    CharSequence seq = embedded.token().text();
                    int emptyLength = 0;
                    for (int i = 0; i < seq.length() && Character.isWhitespace(seq.charAt(i)); ++i) {
                        ++emptyLength;
                    }
                    if (emptyLength < seq.length()) {
                        this.embeddings.add(this.snapshot.create(embedded.offset() + emptyLength, embedded.token().length() - emptyLength, "text/javascript"));
                    } else {
                        this.embeddings.add(this.snapshot.create(embedded.offset(), embedded.token().length(), "text/javascript"));
                    }
                    if (putParenthesis) {
                        this.embeddings.add(this.snapshot.create((CharSequence)")", "text/javascript"));
                    }
                    if (putParenthesis || !embeddedText.trim().endsWith(";")) {
                        this.embeddings.add(this.snapshot.create((CharSequence)";", "text/javascript"));
                    }
                    if (templateId != null) continue;
                    this.endKnockoutSnippet();
                }
                if (setData) {
                    if (dataValue != null) {
                        if (templateId != null) {
                            this.currentTemplateContext.push(dataValue.text().toString().trim(), foreach, null);
                        } else {
                            KODataBindDescriptor desc = KODataBindDescriptor.getDataBindDescriptor(this.snapshot, (TokenSequence<? extends JsTokenId>)embedded.embedded(JsTokenId.javascriptLanguage()), true);
                            if (desc != null) {
                                this.dataBindContext.push(desc.getData().trim(), foreach, desc.getAlias());
                            } else {
                                this.dataBindContext.push(dataValue.text().toString().trim(), foreach, null);
                            }
                        }
                    } else {
                        this.stack.pop();
                    }
                }
                if (templateId == null) break;
                this.templateBoundaries.add(new TemplateBoundary(templateId, this.embeddings.size(), false));
                break;
            }
        }
        return processed;
    }

    private void startKnockoutSnippet(KODataBindContext context) {
        this.startKnockoutSnippet(context, null);
    }

    private void startKnockoutSnippet(KODataBindContext context, Integer position) {
        String currentData;
        StringBuilder sb = new StringBuilder();
        sb.append("(function(){\n");
        sb.append("var $element;\n");
        sb.append("var $root = ko.$bindings;\n");
        if (context.isInForEach()) {
            sb.append("var $index = 0;\n");
        }
        if ((currentData = context.getData()) == null) {
            currentData = "$root";
        }
        sb.append("var $parentContext = ");
        KOJsEmbeddingProviderPlugin.generateContext(sb, context.getParents());
        sb.append(";\n");
        sb.append("var $context = ");
        ArrayList<KODataBindContext.ParentContext> current = new ArrayList<KODataBindContext.ParentContext>(context.getParents());
        current.add(new KODataBindContext.ParentContext(currentData, context.isInForEach(), context.getAlias()));
        KOJsEmbeddingProviderPlugin.generateContext(sb, current);
        sb.append(";\n");
        KOJsEmbeddingProviderPlugin.generateParentAndContextData("$context.", sb, context.getParents());
        KOJsEmbeddingProviderPlugin.generateParents(sb, context.getParents());
        KOJsEmbeddingProviderPlugin.generateWithHierarchyStart(sb, context.getParents());
        String dataValue = currentData;
        if ("$root".equals(currentData)) {
            dataValue = "ko.$bindings";
        }
        if (dataValue.trim().isEmpty()) {
            dataValue = "undefined";
        }
        sb.append("var $data = ").append(dataValue).append(";\n");
        if (context.getAlias() != null) {
            sb.append("var ").append(context.getAlias()).append(" = ").append(dataValue).append(";\n");
        }
        KOJsEmbeddingProviderPlugin.generateWithHierarchyEnd(sb, context.getParents());
        sb.append("with ($data) {\n");
        if (position == null) {
            this.embeddings.add(this.snapshot.create((CharSequence)sb.toString(), "text/javascript"));
        } else {
            this.embeddings.add(position, this.snapshot.create((CharSequence)sb.toString(), "text/javascript"));
        }
    }

    private void endKnockoutSnippet() {
        this.endKnockoutSnippet(null);
    }

    private void endKnockoutSnippet(Integer position) {
        StringBuilder sb = new StringBuilder();
        sb.append("}\n");
        sb.append("});\n");
        if (position == null) {
            this.embeddings.add(this.snapshot.create((CharSequence)sb.toString(), "text/javascript"));
        } else {
            this.embeddings.add(position, this.snapshot.create((CharSequence)sb.toString(), "text/javascript"));
        }
    }

    private static void generateContext(StringBuilder sb, List<KODataBindContext.ParentContext> parents) {
        if (parents.isEmpty()) {
            sb.append("undefined");
        } else {
            sb.append("{\n");
            sb.append("$parentContext :");
            KOJsEmbeddingProviderPlugin.generateContext(sb, parents.subList(0, parents.size() - 1));
            KODataBindContext.ParentContext parent = parents.get(parents.size() - 1);
            sb.append(",\n");
            sb.append("$root : ko.$bindings,\n");
            if (parent.isInForEach()) {
                sb.append("$index : 0,\n");
            }
            sb.append("}");
        }
    }

    private static void generateParentAndContextData(String additionalPrefix, StringBuilder sb, List<KODataBindContext.ParentContext> parents) {
        int i;
        if (parents.isEmpty()) {
            if (additionalPrefix != null) {
                sb.append(additionalPrefix).append("$parentContext.$data = undefined;\n");
            }
            sb.append("$parentContext.$data = undefined;\n");
            sb.append("var $parent = undefined;\n");
            return;
        }
        StringBuilder prefix = new StringBuilder("$parentContext.");
        for (i = 0; i < parents.size() - 1; ++i) {
            sb.append("with (").append(parents.get(i).getValue()).append(") {\n");
        }
        sb.append("var $parent = ").append(parents.get(parents.size() - 1).getValue()).append(";\n");
        for (i = parents.size() - 2; i >= 0; --i) {
            if (additionalPrefix != null) {
                sb.append(additionalPrefix).append((CharSequence)prefix).append("$data = ").append(parents.get(i + 1).getValue()).append(";\n");
            }
            sb.append((CharSequence)prefix).append("$data = ").append(parents.get(i + 1).getValue()).append(";\n");
            prefix.append("$parentContext.");
            sb.append("}\n");
        }
        if (additionalPrefix != null) {
            sb.append(additionalPrefix).append((CharSequence)prefix).append("$data = ko.$bindings;\n");
        }
        sb.append((CharSequence)prefix).append("$data = ko.$bindings;\n");
    }

    private static void generateParents(StringBuilder sb, List<KODataBindContext.ParentContext> parents) {
        sb.append("var $parents = [");
        int pos = sb.length();
        StringBuilder prefix = new StringBuilder("$parentContext.");
        for (int i = 0; i < parents.size(); ++i) {
            sb.insert(pos, ",");
            sb.insert(pos, "$data");
            sb.insert(pos, prefix);
            prefix.append("$parentContext.");
        }
        if (!parents.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("];\n");
    }

    private static void generateWithHierarchyStart(StringBuilder sb, List<KODataBindContext.ParentContext> parents) {
        for (KODataBindContext.ParentContext context : parents) {
            if (context.getAlias() != null) {
                sb.append("var ").append(context.getAlias()).append(" = ").append(context.getValue()).append(";\n");
            }
            sb.append("with (").append(context.getValue()).append(") {\n");
        }
    }

    private static void generateWithHierarchyEnd(StringBuilder sb, List<KODataBindContext.ParentContext> parents) {
        for (int i = 0; i < parents.size(); ++i) {
            sb.append("}\n");
        }
    }

    private static class StackItem {
        final String tag;
        int balance;

        public StackItem(String tag) {
            this.tag = tag;
            this.balance = 1;
        }
    }

    private static class TemplateBoundary {
        private final String name;
        private final int position;
        private final boolean start;

        public TemplateBoundary(String name, int position, boolean start) {
            this.name = name;
            this.position = position;
            this.start = start;
        }

        public String getName() {
            return this.name;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isStart() {
            return this.start;
        }
    }
}

