/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.html.editor.api.gsf.CustomAttribute;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.knockout.HelpItemImpl;
import org.netbeans.modules.html.knockout.KOAttributeCompletionItem;
import org.netbeans.modules.html.knockout.KOBindingCompletionItem;
import org.netbeans.modules.html.knockout.KODataBindTokenId;
import org.netbeans.modules.html.knockout.KOHelpItem;
import org.netbeans.modules.html.knockout.KOUtils;
import org.netbeans.modules.html.knockout.model.Binding;
import org.netbeans.modules.html.knockout.model.KOModel;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.spi.editor.completion.CompletionItem;

public class KOHtmlExtension
extends HtmlExtension {
    private static final String DOC_URL = "http://knockoutjs.com/documentation/binding-syntax.html";
    static final KOHelpItem KO_DATA_BIND_HELP_ITEM = new KOHelpItem(){

        @Override
        public String getName() {
            return "data-bind";
        }

        @Override
        public String getExternalDocumentationURL() {
            return KOHtmlExtension.DOC_URL;
        }
    };
    private static final CustomAttribute KO_DATA_BIND_CUSTOM_ATTRIBUTE = new CustomAttribute(){

        public String getName() {
            return "data-bind";
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isValueRequired() {
            return true;
        }

        public HelpItem getHelp() {
            return new HelpItemImpl(KO_DATA_BIND_HELP_ITEM);
        }
    };

    public boolean isApplicationPiece(HtmlParserResult result) {
        return KOModel.getModel(result).containsKnockout();
    }

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights(HtmlParserResult result, SchedulerEvent event) {
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        KOModel model = KOModel.getModel(result);
        for (Attribute ngAttr : model.getBindings()) {
            OffsetRange dor = KOUtils.getValidDocumentOffsetRange(ngAttr.from(), ngAttr.from() + ngAttr.name().length(), result.getSnapshot());
            if (dor == null) continue;
            highlights.put(dor, ColoringAttributes.CONSTRUCTOR_SET);
        }
        return highlights;
    }

    public List<CompletionItem> completeAttributes(HtmlExtension.CompletionContext context) {
        KOModel model = KOModel.getModel(context.getResult());
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        Element element = context.getCurrentNode();
        if (element != null) {
            switch (element.type()) {
                case OPEN_TAG: {
                    OpenTag ot = (OpenTag)element;
                    String name = ot.unqualifiedName().toString();
                    Collection<CustomAttribute> customAttributes = this.getCustomAttributes(name);
                    for (CustomAttribute ca : customAttributes) {
                        items.add((CompletionItem)new KOAttributeCompletionItem(ca, context.getCCItemStartOffset(), model.containsKnockout()));
                    }
                    break;
                }
            }
        }
        if (context.getPrefix().length() > 0) {
            Iterator itr = items.iterator();
            while (itr.hasNext()) {
                CharSequence insertPrefix = ((CompletionItem)itr.next()).getInsertPrefix();
                if (insertPrefix == null || LexerUtils.startsWith((CharSequence)insertPrefix, (CharSequence)context.getPrefix(), (boolean)true, (boolean)false)) continue;
                itr.remove();
            }
        }
        return items;
    }

    public List<CompletionItem> completeAttributeValue(HtmlExtension.CompletionContext context) {
        TokenSequence embedded;
        Token token;
        int diff;
        Document document = context.getResult().getSnapshot().getSource().getDocument(true);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence ts = LexerUtils.getTokenSequence((TokenHierarchy)tokenHierarchy, (int)context.getOriginalOffset(), (Language)HTMLTokenId.language(), (boolean)false);
        if (ts != null && ((diff = ts.move(context.getOriginalOffset())) == 0 && ts.movePrevious() || ts.moveNext()) && (token = ts.token()).id() == HTMLTokenId.VALUE && (embedded = ts.embedded(KODataBindTokenId.language())) != null) {
            if (embedded.isEmpty()) {
                return this.getBindingItems("", context.getOriginalOffset());
            }
            int ediff = embedded.move(context.getOriginalOffset());
            if (ediff == 0 && embedded.movePrevious() || embedded.moveNext()) {
                Token etoken = embedded.token();
                switch ((KODataBindTokenId)etoken.id()) {
                    case KEY: {
                        CharSequence prefix = ediff == 0 ? etoken.text() : etoken.text().subSequence(0, ediff);
                        return this.getBindingItems(prefix, embedded.offset());
                    }
                    case COMMA: {
                        return this.getBindingItems("", context.getOriginalOffset());
                    }
                    case WS: {
                        if (embedded.movePrevious()) {
                            switch ((KODataBindTokenId)embedded.token().id()) {
                                case COMMA: {
                                    return this.getBindingItems("", context.getOriginalOffset());
                                }
                            }
                            break;
                        }
                        return this.getBindingItems("", context.getOriginalOffset());
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    private List<CompletionItem> getBindingItems(CharSequence prefix, int offset) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        for (Binding b : Binding.values()) {
            String bindingName = b.getName();
            if (!LexerUtils.startsWith((CharSequence)bindingName, (CharSequence)prefix, (boolean)true, (boolean)false)) continue;
            items.add((CompletionItem)new KOBindingCompletionItem(b, offset));
        }
        return items;
    }

    public boolean isCustomAttribute(Attribute attribute, HtmlSource source) {
        return KOModel.isKODataBindingAttribute(attribute);
    }

    public Collection<CustomAttribute> getCustomAttributes(String elementName) {
        return Collections.singleton(KO_DATA_BIND_CUSTOM_ATTRIBUTE);
    }
}

