/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.html.knockout.Bundle;
import org.netbeans.modules.html.knockout.KOHelpItem;
import org.netbeans.modules.html.knockout.KOHtmlExtension;
import org.netbeans.modules.html.knockout.KOUtils;
import org.netbeans.modules.html.knockout.model.Binding;
import org.openide.modules.Places;
import org.openide.util.RequestProcessor;

public class KODoc {
    private static final Logger LOG = Logger.getLogger(KODoc.class.getSimpleName());
    private static RequestProcessor RP = new RequestProcessor(KODoc.class);
    private static KODoc INSTANCE;
    private boolean loadingStarted;
    private static final String CACHE_FOLDER_NAME = "knockout-doc";
    private KOHelpItem binding;
    private Iterator<KOHelpItem> bindings;
    private ProgressHandle progress;
    private int loaded = 0;

    public static synchronized KODoc getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new KODoc();
        }
        return INSTANCE;
    }

    public String getDirectiveDocumentation(KOHelpItem binding) {
        return this.getDoc(binding);
    }

    private void startLoading() {
        LOG.fine("start loading doc");
        ArrayList<KOHelpItem> items = new ArrayList<KOHelpItem>();
        items.add(KOHtmlExtension.KO_DATA_BIND_HELP_ITEM);
        items.addAll(Arrays.asList(Binding.values()));
        this.bindings = items.iterator();
        this.progress = ProgressHandleFactory.createHandle((String)Bundle.doc_building());
        this.progress.start(items.size());
        this.buildDoc();
    }

    private File getCacheFile(KOHelpItem binding) {
        return Places.getCacheSubfile((String)(CACHE_FOLDER_NAME + '/' + binding.getName()));
    }

    private String getDoc(KOHelpItem binding) {
        try {
            File cacheFile = this.getCacheFile(binding);
            if (!cacheFile.exists()) {
                this.loadDoc(binding, cacheFile);
                if (!this.loadingStarted) {
                    this.loadingStarted = true;
                    this.startLoading();
                }
            }
            return KOUtils.getFileContent(cacheFile);
        }
        catch (IOException | URISyntaxException ex) {
            LOG.log(Level.INFO, "Cannot load knockout documentation from \"{0}\".", new Object[]{binding.getExternalDocumentationURL()});
            return Bundle.doc_cannotGet(binding.getExternalDocumentationURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDoc(KOHelpItem binding, File cacheFile) throws URISyntaxException, MalformedURLException, IOException {
        LOG.fine("start loading doc");
        String docURL = binding.getExternalDocumentationURL();
        URL url = new URI(docURL).toURL();
        File file = cacheFile;
        synchronized (file) {
            StringWriter sw = new StringWriter();
            KOUtils.loadURL(url, sw, null);
            String knockoutDocumentationContent = KOUtils.getKnockoutDocumentationContent(sw.getBuffer().toString());
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), "UTF-8");){
                ((Writer)writer).append("<!doctype html><html><head><title>Knockout documentation</title></head><body>");
                ((Writer)writer).append(knockoutDocumentationContent);
                ((Writer)writer).append("</body></html>");
            }
        }
    }

    private void buildDoc() {
        if (this.bindings.hasNext()) {
            this.binding = this.bindings.next();
            this.getDoc(this.binding);
            this.progress.progress(++this.loaded);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    KODoc.this.buildDoc();
                }
            });
        } else {
            this.progress.finish();
            this.progress = null;
            LOG.log(Level.FINE, "Loading doc finished.");
        }
    }
}

