/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class KODataBindContext {
    private final KODataBindContext original;
    private final List<ParentContext> parents;
    private String data;
    private boolean inForEach;
    private String alias;

    public KODataBindContext() {
        this.original = null;
        this.parents = new ArrayList<ParentContext>();
    }

    public KODataBindContext(KODataBindContext context) {
        this.original = context;
        this.parents = new ArrayList<ParentContext>(context.parents);
        this.data = context.data;
        this.inForEach = context.inForEach;
        this.alias = context.alias;
    }

    public static KODataBindContext combine(KODataBindContext parent, KODataBindContext child) {
        KODataBindContext result = new KODataBindContext(parent);
        for (int i = 1; i < child.parents.size(); ++i) {
            ParentContext c = child.parents.get(i);
            result.push(c.getValue(), c.isInForEach(), c.getAlias(), true);
        }
        result.push(child.getData(), child.isInForEach(), child.getAlias(), true);
        return result;
    }

    public void push(String newData, boolean foreach, String alias) {
        this.push(newData, foreach, alias, false);
    }

    private void push(String newData, boolean foreach, String alias, boolean noExpansion) {
        assert (!foreach || newData != null);
        assert (alias == null || foreach);
        String replacement = this.data == null || this.data.equals("$root") ? "ko.$bindings" : this.data;
        String toAdd = newData.replaceAll("$data", replacement);
        if (!noExpansion && foreach) {
            toAdd = "(" + toAdd + ")[0]";
        }
        if (this.data == null || "$root".equals(this.data)) {
            this.parents.add(new ParentContext("ko.$bindings", false, null));
        } else {
            this.parents.add(new ParentContext(this.data, this.inForEach, this.alias));
        }
        this.data = toAdd;
        this.inForEach = foreach;
        this.alias = alias;
    }

    public void pop() {
        if (this.parents.isEmpty()) {
            throw new IllegalStateException();
        }
        ParentContext context = this.parents.remove(this.parents.size() - 1);
        this.data = context.getValue();
        this.inForEach = context.isInForEach();
        this.alias = context.getAlias();
    }

    public KODataBindContext getOriginal() {
        return this.original;
    }

    public void clear() {
        this.inForEach = false;
        this.data = null;
        this.alias = null;
        this.parents.clear();
    }

    public List<ParentContext> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean isInForEach() {
        return this.inForEach;
    }

    public String getAlias() {
        return this.alias;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.original);
        hash = 53 * hash + Objects.hashCode(this.parents);
        hash = 53 * hash + Objects.hashCode(this.data);
        hash = 53 * hash + (this.inForEach ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KODataBindContext other = (KODataBindContext)obj;
        if (!Objects.equals(this.original, other.original)) {
            return false;
        }
        if (!Objects.equals(this.parents, other.parents)) {
            return false;
        }
        if (!Objects.equals(this.data, other.data)) {
            return false;
        }
        if (this.inForEach != other.inForEach) {
            return false;
        }
        return Objects.deepEquals(this.parents.toArray(), other.parents.toArray());
    }

    public static class ParentContext {
        private final String value;
        private final boolean inForEach;
        private final String alias;

        public ParentContext(String value, boolean inForEach, String alias) {
            this.value = value;
            this.inForEach = inForEach;
            this.alias = alias;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isInForEach() {
            return this.inForEach;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

