/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.tasklist.filter.FilterEditor;
import org.netbeans.modules.tasklist.filter.FilterRepository;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.MenuToggleButton;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class FiltersMenuButton
extends MenuToggleButton
implements PropertyChangeListener {
    private TaskManagerImpl taskManager = TaskManagerImpl.getInstance();

    public FiltersMenuButton(TaskFilter currentFilter) {
        super(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/tasklist/ui/resources/filter.png", (boolean)false), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/tasklist/ui/resources/filter_rollover.png", (boolean)false), 4);
        this.updateState(currentFilter);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!FiltersMenuButton.this.isSelected()) {
                    FiltersMenuButton.this.taskManager.observe(FiltersMenuButton.this.taskManager.getScope(), TaskFilter.EMPTY);
                } else {
                    FiltersMenuButton.openFilterEditor();
                    FiltersMenuButton.this.updateState(FiltersMenuButton.this.taskManager.getFilter());
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.taskManager.addPropertyChangeListener("filter", this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.taskManager.removePropertyChangeListener("filter", this);
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        FiltersMenuButton.fillMenu(popup, null);
        return popup;
    }

    static void fillMenu(JPopupMenu popup, JMenu menu) {
        assert (null != popup || null != menu);
        FilterRepository filterRep = FilterRepository.getDefault();
        TaskManagerImpl tm = TaskManagerImpl.getInstance();
        TaskFilter activeFilter = tm.getFilter();
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(new CancelFilterAction());
        item.setSelected(TaskFilter.EMPTY.equals(activeFilter));
        if (null == popup) {
            menu.add(item);
        } else {
            popup.add(item);
        }
        if (null == popup) {
            menu.addSeparator();
        } else {
            popup.addSeparator();
        }
        List<TaskFilter> allFilters = filterRep.getAllFilters();
        for (TaskFilter tf : allFilters) {
            item = new JRadioButtonMenuItem(new SetFilterAction(tf));
            item.setSelected(activeFilter.equals(tf));
            if (null == popup) {
                menu.add(item);
                continue;
            }
            popup.add(item);
        }
        if (allFilters.size() > 0) {
            if (null == popup) {
                menu.addSeparator();
            } else {
                popup.addSeparator();
            }
        }
        if (null == popup) {
            menu.add(new ManageFiltersAction());
        } else {
            popup.add(new ManageFiltersAction());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.updateState(this.taskManager.getFilter());
    }

    private void updateState(TaskFilter filter) {
        if (null == filter || TaskFilter.EMPTY.equals(filter)) {
            this.setSelected(false);
            this.setToolTipText(NbBundle.getMessage(FiltersMenuButton.class, (String)"HINT_SelectFilter"));
            FilterRepository.getDefault().setActive(null);
        } else {
            this.setSelected(true);
            this.setToolTipText(filter.getName());
            FilterRepository.getDefault().setActive(filter);
        }
    }

    private static void openFilterEditor() {
        FilterRepository filterRep = FilterRepository.getDefault();
        FilterRepository clone = (FilterRepository)filterRep.clone();
        FilterEditor fe = new FilterEditor(clone);
        if (fe.showWindow()) {
            filterRep.assign(clone);
            TaskManagerImpl tm = TaskManagerImpl.getInstance();
            tm.observe(tm.getScope(), filterRep.getActive());
            try {
                filterRep.save();
            }
            catch (IOException ioE) {
                Logger.getLogger(FiltersMenuButton.class.getName()).log(Level.INFO, ioE.getMessage(), ioE);
            }
        }
    }

    private static class CancelFilterAction
    extends AbstractAction {
        public CancelFilterAction() {
            super(NbBundle.getMessage(FiltersMenuButton.class, (String)"LBL_CancelFilter"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterRepository.getDefault().setActive(null);
            try {
                FilterRepository.getDefault().save();
            }
            catch (IOException ioE) {
                Logger.getLogger(FiltersMenuButton.class.getName()).log(Level.INFO, ioE.getMessage(), ioE);
            }
            TaskManagerImpl tm = TaskManagerImpl.getInstance();
            tm.observe(tm.getScope(), TaskFilter.EMPTY);
        }
    }

    private static class ManageFiltersAction
    extends AbstractAction {
        public ManageFiltersAction() {
            super(NbBundle.getMessage(FiltersMenuButton.class, (String)"LBL_EditFilters"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FiltersMenuButton.openFilterEditor();
        }
    }

    private static class SetFilterAction
    extends AbstractAction {
        private TaskFilter filter;

        public SetFilterAction(TaskFilter filter) {
            super(filter.getName());
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterRepository.getDefault().setActive(this.filter);
            try {
                FilterRepository.getDefault().save();
            }
            catch (IOException ioE) {
                Logger.getLogger(FiltersMenuButton.class.getName()).log(Level.INFO, ioE.getMessage(), ioE);
            }
            TaskManagerImpl tm = TaskManagerImpl.getInstance();
            tm.observe(tm.getScope(), this.filter);
        }
    }
}

