/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm3.impl;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.idm.core.gui.navigation.api.CallbackHandler;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.exceptions.NotConnectedException;
import de.proveo.idm.core.gui.navigation.api.exceptions.VersionNotPresentException;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.remote.server.api.AbstractRemoteInfoman;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.impl.RemoteDeviceIdImpl;
import de.proveo.idm.remote.server.efm3.impl.EFMServer3;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupValue;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class RemoteInfomanImpl
extends AbstractRemoteInfoman
implements CallbackHandler {
    private EFMServer3 server;

    public RemoteInfomanImpl(EFMServer3 server, long unitId, String name) {
        super(name);
        this.server = server;
        this.id = new RemoteDeviceIdImpl(unitId);
        this.deviceType = Device.DeviceType.INFOMAN;
    }

    public AbstractRemoteInfoman clone() throws CloneNotSupportedException {
        RemoteInfomanImpl clone = new RemoteInfomanImpl(this.server, this.getUnitId(), this.name);
        clone.actionPath = this.actionPath;
        clone.description = this.description;
        clone.iconBase = this.iconBase;
        return clone;
    }

    public synchronized SortedMap<String, Object> getEnv() throws Exception {
        CurrentInfomanSetupValue currentSetup = this.getSetup();
        return this.getEnvironmentFromSetup(currentSetup);
    }

    public DatasyncResourceValue getConfiguration() throws Exception {
        CurrentInfomanSetupValue currentSetup = this.getSetup();
        if (currentSetup != null) {
            DatasyncResourceValue resource = new DatasyncResourceValue();
            resource.setResource(currentSetup.getConfiguration());
            resource.setResourceName(currentSetup.getConfigurationName());
            resource.setMetainfos(this.getConfigurationMetaInfo(currentSetup));
            return resource;
        }
        return null;
    }

    public String getSoftwareVersion() throws NotConnectedException, VersionNotPresentException {
        try {
            return this.getSetup().getSoftwareVersion();
        }
        catch (Exception ex) {
            throw new VersionNotPresentException("Could not fetch version of Infoman", (Throwable)ex);
        }
    }

    public void forceACLUpdate() throws Exception {
    }

    private CurrentInfomanSetupValue getSetup() throws Exception {
        return this.server.getSetupForInfoman(this.getUnitId());
    }

    public EFMServer getServer() {
        return this.server;
    }

    private SortedMap<String, Object> getEnvironmentFromSetup(CurrentInfomanSetupValue setup) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (setup != null) {
            map.put(MetaInfoKey.FILE_NAME.toString(), setup.getConfigurationName());
            map.put(MetaInfoKey.HARDWARE_SERIAL.toString(), setup.getHardwareSN());
            map.put(MetaInfoKey.INFOMAN_SERIAL.toString(), setup.getInfomanSN());
            map.put(MetaInfoKey.JAVA_VM_VERSION.toString(), setup.getJavaVMVersion());
            map.put(MetaInfoKey.KERNEL_VERSION.toString(), setup.getKernelVersion());
            map.put(MetaInfoKey.PM_VERSION.toString(), setup.getPowerManagementVersion());
            map.put(MetaInfoKey.ROOTFS_VERSION.toString(), setup.getRootfsVersion());
            map.put(MetaInfoKey.SOFTWARE_VERSION.toString(), setup.getSoftwareVersion());
            map.put(MetaInfoKey.ID.toString(), String.valueOf(setup.getUnitId()));
        }
        return map;
    }

    private ArrayList<DatasyncMetainfoValue> getConfigurationMetaInfo(CurrentInfomanSetupValue setup) {
        ArrayList<DatasyncMetainfoValue> metaInfo = new ArrayList<DatasyncMetainfoValue>();
        if (setup != null) {
            DatasyncMetainfoValue info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
            info.setValue(setup.getConfigurationContentType());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
            info.setValue(setup.getConfigurationChecksumType());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.HARDWARE.toString());
            info.setValue(setup.getHardware());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.HARDWARE_SERIAL.toString());
            info.setValue(setup.getHardwareSN());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.INFOMAN_SERIAL.toString());
            info.setValue(setup.getInfomanSN());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.JAVA_VM_VERSION.toString());
            info.setValue(setup.getJavaVMVersion());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.KERNEL_VERSION.toString());
            info.setValue(setup.getKernelVersion());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.PM_VERSION.toString());
            info.setValue(setup.getPowerManagementVersion());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.REQUEST_CONFIG_TIME.toString());
            info.setValue(String.valueOf(setup.getRequestConfigTime()));
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.ROOTFS_VERSION.toString());
            info.setValue(setup.getRootfsVersion());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.SOFTWARE_VERSION.toString());
            info.setValue(setup.getSoftwareVersion());
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.SYNC_TIME.toString());
            info.setValue(String.valueOf(setup.getSyncTime()));
            metaInfo.add(info);
            info = new DatasyncMetainfoValue();
            info.setKey(MetaInfoKey.UP_TO_DATE.toString());
            info.setValue(String.valueOf(setup.getConfigurationUpToDate()));
            metaInfo.add(info);
        }
        return metaInfo;
    }

    public String getCallbackAddress() {
        String title;
        String text = NbBundle.getMessage(RemoteInfomanImpl.class, (String)"RemoteInfomanImpl.callback.text");
        DialogUtil.InputLine input = new DialogUtil.InputLine(text, title = NbBundle.getMessage(RemoteInfomanImpl.class, (String)"RemoteInfomanImpl.callback.title", (Object)this.name));
        Object option = DialogUtil.showDialogDescriptor((DialogDescriptor)input);
        if (DialogUtil.OK_OPTION.equals(option)) {
            return input.getInputText();
        }
        return "";
    }
}

