/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.utils;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.VersionsCache;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.ui.blame.AnnotateAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.ignore.IgnoreAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.git.utils.Bundle;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.FileSelector;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.QuickSearch;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public final class GitUtils {
    public static final String DOT_GIT = ".git";
    public static final String INDEX_LOCK = "index.lock";
    private static final Pattern METADATA_PATTERN = Pattern.compile(".*\\" + File.separatorChar + "(\\.)git(\\" + File.separatorChar + ".*|$)");
    private static final String FILENAME_GITIGNORE = ".gitignore";
    public static final String HEAD = "HEAD";
    public static final String INDEX = "INDEX";
    public static final String CURRENT = "CURRENT";
    public static final String PREFIX_R_HEADS = "refs/heads/";
    public static final String PREFIX_R_REMOTES = "refs/remotes/";
    public static final ProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    public static final String MASTER = "master";
    private static final Set<File> loggedRepositories = new HashSet<File>();
    public static final String REMOTE_ORIGIN = "origin";
    private static final Map<File, Set<String>> notSharable = Collections.synchronizedMap(new HashMap(5));
    private static final String REF_SPEC_PATTERN = "+refs/heads/{0}:refs/remotes/{1}/{0}";
    private static final String REF_SPEC_GLOBAL_PATTERN = "+refs/heads/*:refs/remotes/{0}/*";
    public static final String REF_SPEC_DEL_PREFIX = ":refs/remotes/";
    private static final String REF_PUSHSPEC_PATTERN = "refs/heads/{0}:refs/heads/{1}";
    public static final String REF_PUSHSPEC_DEL_PREFIX = ":refs/heads/";
    private static final String REF_TAG_PUSHSPEC_PATTERN = "refs/tags/{0}:refs/tags/{0}";
    static ThreadLocal<Set<File>> indexingFiles = new ThreadLocal();

    public static boolean isPartOfGitMetadata(File file) {
        return METADATA_PATTERN.matcher(file.getAbsolutePath()).matches();
    }

    public static boolean isAdministrative(File file) {
        String name = file.getName();
        return GitUtils.isAdministrative(name) && file.isDirectory();
    }

    public static boolean isAdministrative(String fileName) {
        return fileName.equals(DOT_GIT);
    }

    public static boolean repositoryExistsFor(File file) {
        return new File(file, DOT_GIT).exists();
    }

    public static File getGitFolderForRoot(File repositoryRoot) {
        return FileUtil.normalizeFile((File)new File(repositoryRoot, DOT_GIT));
    }

    public static boolean prepareRootFiles(File repository, Collection<File> filesUnderRoot, File file) {
        boolean added = false;
        HashSet<File> filesToRemove = new HashSet<File>();
        for (File fileUnderRoot : filesUnderRoot) {
            if (file.equals(fileUnderRoot) || fileUnderRoot.equals(repository)) {
                added = true;
                break;
            }
            if (file.equals(repository)) {
                filesUnderRoot.clear();
                break;
            }
            if (file.getAbsolutePath().length() < fileUnderRoot.getAbsolutePath().length()) {
                if (!Utils.isAncestorOrEqual((File)file, (File)fileUnderRoot)) continue;
                filesToRemove.add(fileUnderRoot);
                continue;
            }
            if (!Utils.isAncestorOrEqual((File)fileUnderRoot, (File)file)) continue;
            added = true;
            break;
        }
        filesUnderRoot.removeAll(filesToRemove);
        if (!added) {
            filesUnderRoot.add(file);
        }
        return added;
    }

    public static boolean isIgnored(File file, boolean checkSharability) {
        int sharability;
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        File topFile = Git.getInstance().getRepositoryRoot(file);
        if (topFile == null || topFile.equals(file)) {
            return false;
        }
        if (GitUtils.isNotSharable(path, topFile)) {
            return true;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.equals(topFile) && GitUtils.isIgnored(parentFile, false)) {
            return true;
        }
        if (FILENAME_GITIGNORE.equals(file.getName())) {
            return false;
        }
        if (checkSharability && (sharability = SharabilityQuery.getSharability((File)FileUtil.normalizeFile((File)file))) == 2) {
            if (GitModuleConfig.getDefault().getAutoIgnoreFiles()) {
                GitUtils.ignoreNotSharableAncestor(topFile, file);
            } else {
                GitUtils.addNotSharable(topFile, path);
            }
            return true;
        }
        return false;
    }

    public static GitBranch getTrackedBranch(RepositoryInfo info, String errorLabel) {
        GitBranch activeBranch = info.getActiveBranch();
        if (activeBranch == null) {
            return null;
        }
        GitBranch trackedBranch = activeBranch.getTrackedBranch();
        if (trackedBranch == null) {
            GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noTrackedBranch(activeBranch.getName()));
            return null;
        }
        if (!trackedBranch.isRemote()) {
            GitUtils.notifyError(errorLabel, Bundle.MSG_Err_trackedBranchLocal(trackedBranch.getName()));
            return null;
        }
        return trackedBranch;
    }

    public static void notifyError(String errorLabel, String errorMessage) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)errorMessage, errorLabel, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }

    public static boolean isFromRepository(File repository, File file) {
        Git git = Git.getInstance();
        File fileRepository = git.getRepositoryRoot(file);
        if (repository.equals(fileRepository)) {
            return true;
        }
        return file.equals(fileRepository) && repository.equals(git.getRepositoryRoot(file.getParentFile()));
    }

    public static String parseRemoteHeadFromFetch(String fetchRefSpec) {
        int pos;
        if (fetchRefSpec.startsWith("+")) {
            fetchRefSpec = fetchRefSpec.substring(1);
        }
        if ((pos = fetchRefSpec.indexOf(58)) > 0) {
            return fetchRefSpec.substring(0, pos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNotSharable(File topFile, String ignoredPath) {
        Map<File, Set<String>> map = notSharable;
        synchronized (map) {
            Set<String> ignores = notSharable.get(topFile);
            if (ignores == null) {
                ignores = new HashSet<String>();
            }
            String patternCandidate = ignoredPath;
            Iterator<String> it = ignores.iterator();
            while (it.hasNext()) {
                String storedPattern = it.next();
                if (storedPattern.equals(ignoredPath) || ignoredPath.startsWith(storedPattern + '/')) {
                    patternCandidate = null;
                    break;
                }
                if (!storedPattern.startsWith(ignoredPath + '/')) continue;
                it.remove();
            }
            if (patternCandidate != null) {
                ignores.add(patternCandidate);
            }
            notSharable.put(topFile, ignores);
        }
    }

    private static boolean isNotSharable(String path, File topFile) {
        boolean retval = false;
        Set<String> notSharablePaths = notSharable.get(topFile);
        if (notSharablePaths == null) {
            notSharablePaths = Collections.emptySet();
        }
        retval = notSharablePaths.contains(path);
        return retval;
    }

    private static void ignoreNotSharableAncestor(File topFile, File notSharableFile) {
        File parent;
        if (topFile.equals(notSharableFile)) {
            throw new IllegalStateException("Trying to ignore " + notSharableFile + " in " + topFile);
        }
        while (!topFile.equals(parent = notSharableFile.getParentFile()) && SharabilityQuery.getSharability((File)FileUtil.normalizeFile((File)parent)) == 2) {
            notSharableFile = parent;
        }
        GitUtils.addNotSharable(topFile, notSharableFile.getAbsolutePath());
        if (notSharableFile.isDirectory()) {
            for (File f : Git.getInstance().getCreatedFolders()) {
                if (!Utils.isAncestorOrEqual((File)f, (File)notSharableFile)) continue;
                ((IgnoreAction)SystemAction.get(IgnoreAction.class)).ignoreFolders(topFile, new File[]{notSharableFile});
            }
        }
    }

    public static boolean isFromGitRepository(VCSContext context) {
        return GitUtils.getRootFile(context) != null;
    }

    public static File getRootFile(VCSContext context) {
        if (context == null) {
            return null;
        }
        Git git = Git.getInstance();
        File[] files = context.getRootFiles().toArray(new File[context.getRootFiles().size()]);
        if (files == null || files.length == 0) {
            return null;
        }
        File root = git.getRepositoryRoot(files[0]);
        return root;
    }

    public static Set<File> getRepositoryRoots(VCSContext context) {
        Set rootsSet = context.getRootFiles();
        return GitUtils.getRepositoryRoots(rootsSet);
    }

    public static Set<File> getRepositoryRoots(Set<File> roots) {
        HashSet<File> ret = new HashSet<File>();
        for (File file : roots) {
            File repoRoot;
            if (!Git.getInstance().isManaged(file) || (repoRoot = Git.getInstance().getRepositoryRoot(file)) == null) continue;
            ret.add(repoRoot);
        }
        return ret;
    }

    public static AbstractMap.SimpleImmutableEntry<File, File[]> getActionRoots(VCSContext ctx) {
        List l;
        Set rootsSet = ctx.getRootFiles();
        HashMap<File, LinkedList<File>> map = new HashMap<File, LinkedList<File>>();
        for (File file : rootsSet) {
            File repoRoot;
            if (!Git.getInstance().isManaged(file) || (repoRoot = Git.getInstance().getRepositoryRoot(file)) == null) continue;
            l = (LinkedList<File>)map.get(repoRoot);
            if (l == null) {
                l = new LinkedList<File>();
                map.put(repoRoot, (LinkedList<File>)l);
            }
            l.add(file);
        }
        Set repoRoots = map.keySet();
        if (map.size() > 1) {
            FileSelector fs = new FileSelector(NbBundle.getMessage(GitUtils.class, (String)"LBL_FileSelector_Title"), NbBundle.getMessage(GitUtils.class, (String)"FileSelector.jLabel1.text"), new HelpCtx("org.netbeans.modules.git.FileSelector"), GitModuleConfig.getDefault().getPreferences());
            if (fs.show(repoRoots.toArray(new File[repoRoots.size()]))) {
                File selection = fs.getSelectedFile();
                l = (List)map.get(selection);
                return new AbstractMap.SimpleImmutableEntry<File, File[]>(selection, l.toArray(new File[l.size()]));
            }
            return null;
        }
        if (map.isEmpty()) {
            return null;
        }
        File root = (File)map.keySet().iterator().next();
        List l2 = (List)map.get(root);
        return new AbstractMap.SimpleImmutableEntry<File, File[]>(root, l2.toArray(new File[l2.size()]));
    }

    public static File[] filterForRepository(VCSContext ctx, File repository) {
        File[] files = null;
        if (ctx != null) {
            Set s = ctx.getRootFiles();
            files = s.toArray(new File[s.size()]);
        }
        if (files != null) {
            LinkedList<File> l = new LinkedList<File>();
            for (File file : files) {
                File r = Git.getInstance().getRepositoryRoot(file);
                if (r == null || !r.equals(repository)) continue;
                l.add(file);
            }
            files = l.toArray(new File[l.size()]);
        }
        return files;
    }

    public static File[] flatten(File[] files, Set<FileInformation.Status> statuses) {
        LinkedList<File> ret = new LinkedList<File>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (int i = 0; i < files.length; ++i) {
            File dir = files[i];
            FileInformation info = cache.getStatus(dir);
            if (info.containsStatus(statuses)) {
                ret.add(dir);
            }
            File[] entries = cache.listFiles(dir);
            for (int e = 0; e < entries.length; ++e) {
                File entry = entries[e];
                info = cache.getStatus(entry);
                if (!info.containsStatus(statuses)) continue;
                ret.add(entry);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    public static File[] listFiles(File[] roots, EnumSet<FileInformation.Status> includedStatuses) {
        File[][] split = Utils.splitFlatOthers((File[])roots);
        ArrayList<File> fileList = new ArrayList<File>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (int c = 0; c < split.length; ++c) {
            File[] splitRoots = split[c];
            if (c == 1) {
                fileList.addAll(Arrays.asList(cache.listFiles(splitRoots, includedStatuses)));
                continue;
            }
            fileList.addAll(Arrays.asList(GitUtils.flatten(splitRoots, includedStatuses)));
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static VCSContext getCurrentContext(Node[] nodes) {
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        return VCSContext.forNodes((Node[])nodes);
    }

    public static String getMimeType(File file) {
        String foMime;
        FileObject fo = FileUtil.toFileObject((File)file);
        boolean hasMime = false;
        if (fo == null) {
            foMime = "content/unknown";
        } else {
            foMime = fo.getMIMEType();
            if ("content/unknown".equals(foMime)) {
                foMime = "text/plain";
            } else {
                hasMime = true;
            }
        }
        if (!hasMime) {
            return GitUtils.isFileContentBinary(file) ? "application/octet-stream" : foMime;
        }
        return foMime;
    }

    public static boolean isFileContentBinary(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return false;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            return dao.getCookie(EditorCookie.class) == null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static boolean isFromInternalView(VCSContext context) {
        return context.getElements().lookup(GitStatusNode.class) != null;
    }

    public static List<String> getRelativePaths(File workDir, File[] roots) {
        ArrayList<String> paths = new ArrayList<String>(roots.length);
        for (File root : roots) {
            if (workDir.equals(root)) {
                paths.clear();
                break;
            }
            paths.add(GitUtils.getRelativePath(workDir, root));
        }
        return paths;
    }

    public static String getRelativePath(File repo, File file) {
        StringBuilder relativePath = new StringBuilder("");
        File parent = file;
        if (!parent.equals(repo)) {
            while (parent != null && !parent.equals(repo)) {
                relativePath.insert(0, "/").insert(0, parent.getName());
                parent = parent.getParentFile();
            }
            if (parent == null) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not under " + repo.getAbsolutePath());
            }
            relativePath.deleteCharAt(relativePath.length() - 1);
        }
        return relativePath.toString();
    }

    public static void openInVersioningView(Collection<File> files, File repository, ProgressMonitor pm) {
        LinkedList<AbstractNode> nodes = new LinkedList<AbstractNode>();
        for (File file : files) {
            AbstractNode node = new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{file}));
            nodes.add(node);
        }
        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, files), pm);
        if (!pm.isCanceled()) {
            final VCSContext context = VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()]));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((StatusAction)SystemAction.get(StatusAction.class)).performContextAction(context);
                }
            });
        }
    }

    public static void printInfo(StringBuilder sb, GitRevisionInfo info) {
        GitUtils.printInfo(sb, info, true);
    }

    public static void printInfo(StringBuilder sb, GitRevisionInfo info, boolean endWithNewLine) {
        String lbrevision = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.revision");
        String lbauthor = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.author");
        String lbcommitter = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.committer");
        String lbdate = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.date");
        String lbsummary = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.summary");
        String author = info.getAuthor().toString();
        String committer = info.getCommitter().toString();
        sb.append(NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.title")).append("\n");
        sb.append(lbrevision);
        sb.append(info.getRevision());
        sb.append('\n');
        sb.append(lbauthor);
        sb.append(author);
        sb.append('\n');
        if (!author.equals(committer)) {
            sb.append(lbcommitter);
            sb.append(committer);
            sb.append('\n');
        }
        sb.append(lbdate);
        sb.append(DateFormat.getDateTimeInstance().format(new Date(info.getCommitTime())));
        sb.append('\n');
        sb.append(lbsummary);
        int prefixLen = lbsummary.length();
        sb.append(GitUtils.formatMultiLine(prefixLen, info.getFullMessage()));
        if (endWithNewLine) {
            sb.append('\n');
        }
    }

    private static String formatMultiLine(int prefixLen, String message) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prefixLen; ++i) {
            sb.append(" ");
        }
        String prefix = sb.toString();
        String[] lines = message.split("\n");
        sb = new StringBuilder(lines.length > 0 ? lines[0] : "");
        for (int i = 1; i < lines.length; ++i) {
            sb.append("\n").append(prefix).append(lines[i]);
        }
        return sb.toString();
    }

    public static void headChanged(File ... repositories) {
        Set openFiles = Utils.getOpenFiles();
        HashSet<File> repositorySet = new HashSet<File>(Arrays.asList(repositories));
        Iterator it = openFiles.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (repositorySet.contains(Git.getInstance().getRepositoryRoot(file))) continue;
            it.remove();
        }
        if (!openFiles.isEmpty()) {
            Git.getInstance().headChanged(openFiles);
            Git.getInstance().getHistoryProvider().fireHistoryChange(openFiles.toArray(new File[openFiles.size()]));
        }
    }

    public static boolean isRepositoryLocked(File repository) {
        return new File(GitUtils.getGitFolderForRoot(repository), INDEX_LOCK).exists();
    }

    public static void openInRevision(File originalFile, String revision1, int lineNumber, String revisionToOpen, boolean showAnnotations, ProgressMonitor pm) throws IOException {
        File file1 = VersionsCache.getInstance().getFileRevision(originalFile, revision1, pm);
        if (file1 == null) {
            file1 = File.createTempFile("tmp", "-" + originalFile.getName(), Utils.getTempFolder());
            file1.deleteOnExit();
        }
        if (pm.isCanceled()) {
            return;
        }
        File file = VersionsCache.getInstance().getFileRevision(originalFile, revisionToOpen, pm);
        if (file == null) {
            file = File.createTempFile("tmp", "-" + originalFile.getName(), Utils.getTempFolder());
            file.deleteOnExit();
        }
        if (pm.isCanceled()) {
            return;
        }
        int matchingLine = DiffUtils.getMatchingLine((File)file1, (File)file, (int)lineNumber);
        GitUtils.openInRevision(file, originalFile, matchingLine, revisionToOpen, showAnnotations, pm);
    }

    public static void openInRevision(File originalFile, int lineNumber, String revision, boolean showAnnotations, ProgressMonitor pm) throws IOException {
        File file = VersionsCache.getInstance().getFileRevision(originalFile, revision, pm);
        if (pm.isCanceled()) {
            return;
        }
        if (file == null) {
            file = File.createTempFile("tmp", "-" + originalFile.getName(), Utils.getTempFolder());
            file.deleteOnExit();
        }
        GitUtils.openInRevision(file, originalFile, lineNumber, revision, showAnnotations, pm);
    }

    private static void openInRevision(File fileToOpen, final File originalFile, final int lineNumber, final String revision, boolean showAnnotations, ProgressMonitor pm) throws IOException {
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)fileToOpen));
        EditorCookie ec = null;
        OpenCookie oc = null;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        }
        catch (DataObjectNotFoundException ex) {
            Logger.getLogger(GitUtils.class.getName()).log(Level.FINE, null, ex);
        }
        if (ec == null && oc != null) {
            oc.open();
        } else {
            CloneableEditorSupport ces = Utils.openFile((FileObject)fo, (String)revision.substring(0, 7));
            if (showAnnotations && ces != null && !pm.isCanceled()) {
                final CloneableEditorSupport support = ces;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane[] panes = support.getOpenedPanes();
                        if (panes != null) {
                            if (lineNumber >= 0 && lineNumber < support.getLineSet().getLines().size()) {
                                support.getLineSet().getCurrent(lineNumber).show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.FRONT);
                            }
                            ((AnnotateAction)SystemAction.get(AnnotateAction.class)).showAnnotations(panes[0], originalFile, revision);
                        }
                    }
                });
            }
        }
    }

    public static Map<File, Set<File>> sortByRepository(Collection<File> files) {
        HashMap<File, Set<File>> sorted = new HashMap<File, Set<File>>(5);
        for (File f : files) {
            File repository = Git.getInstance().getRepositoryRoot(f);
            if (repository == null) continue;
            HashSet<File> repoFiles = (HashSet<File>)sorted.get(repository);
            if (repoFiles == null) {
                repoFiles = new HashSet<File>();
                sorted.put(repository, repoFiles);
            }
            repoFiles.add(f);
        }
        return sorted;
    }

    public static boolean contains(Collection<File> roots, File file) {
        for (File root : roots) {
            if (!Utils.isAncestorOrEqual((File)root, (File)file)) continue;
            return true;
        }
        return false;
    }

    public static String getGlobalRefSpec(String remoteName) {
        return MessageFormat.format(REF_SPEC_GLOBAL_PATTERN, remoteName);
    }

    public static String getRefSpec(GitBranch branch, String remoteName) {
        return MessageFormat.format(REF_SPEC_PATTERN, branch.getName(), remoteName);
    }

    public static String getDeletedRefSpec(GitBranch branch) {
        return REF_SPEC_DEL_PREFIX + branch.getName();
    }

    public static String getRefSpec(String branchName, String remoteName) {
        return MessageFormat.format(REF_SPEC_PATTERN, branchName, remoteName);
    }

    public static String getPushRefSpec(String branchName, String remoteRepositoryBranchName) {
        return MessageFormat.format(REF_PUSHSPEC_PATTERN, branchName, remoteRepositoryBranchName);
    }

    public static String getPushDeletedRefSpec(String remoteRepositoryBranchName) {
        return REF_PUSHSPEC_DEL_PREFIX + remoteRepositoryBranchName;
    }

    public static String getPushTagRefSpec(String tagName) {
        return MessageFormat.format(REF_TAG_PUSHSPEC_PATTERN, tagName);
    }

    public static <T> T runWithoutIndexing(Callable<T> callable, List<File> files) throws GitException {
        return GitUtils.runWithoutIndexing(callable, files.toArray(new File[files.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runWithoutIndexing(Callable<T> callable, File ... files) throws GitException {
        try {
            Set<File> recursiveRoots = indexingFiles.get();
            if (recursiveRoots != null) {
                if ($assertionsDisabled) return callable.call();
                if (GitUtils.indexingFilesSubtree(recursiveRoots, files)) return callable.call();
                throw new AssertionError((Object)("Recursive call does not permit different roots: " + recursiveRoots + " vs. " + Arrays.asList(files)));
            }
            try {
                if (Git.LOG.isLoggable(Level.FINER)) {
                    Git.LOG.log(Level.FINER, "Running block in indexing bridge: on {0}", Arrays.asList(files));
                }
                indexingFiles.set(new HashSet<File>(Arrays.asList(files)));
                Object object = IndexingBridge.getInstance().runWithoutIndexing(callable, files);
                return (T)object;
            }
            finally {
                indexingFiles.remove();
            }
        }
        catch (GitException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GitException("Cannot run without indexing due to: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static String getColorString(Color c) {
        return "#" + GitUtils.getHex(c.getRed()) + GitUtils.getHex(c.getGreen()) + GitUtils.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static boolean indexingFilesSubtree(Set<File> recursiveRoots, File[] files) {
        for (File f : files) {
            if (recursiveRoots.contains(f)) continue;
            boolean contained = false;
            for (File root : recursiveRoots) {
                if (!Utils.isAncestorOrEqual((File)root, (File)f)) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            return false;
        }
        return true;
    }

    public static GitRemoteConfig prepareConfig(GitRemoteConfig original, String remoteName, String remoteUri, List<String> fetchRefSpecs) {
        List<String> refSpecs;
        List<Object> remoteUris;
        if (original != null) {
            remoteUris = new LinkedList(original.getUris());
            if (!remoteUris.contains(remoteUri)) {
                remoteUris.add(remoteUri);
            }
        } else {
            remoteUris = Arrays.asList(remoteUri);
        }
        if (original != null) {
            refSpecs = new LinkedList<String>(original.getFetchRefSpecs());
            if (!refSpecs.contains(GitUtils.getRefSpec("*", remoteName))) {
                for (String refSpec : fetchRefSpecs) {
                    if (refSpecs.contains(refSpec)) continue;
                    refSpecs.add(refSpec);
                }
            }
        } else {
            refSpecs = fetchRefSpecs;
        }
        return new GitRemoteConfig(remoteName, remoteUris, original == null ? Collections.emptyList() : original.getPushUris(), refSpecs, original == null ? Collections.emptyList() : original.getPushRefSpecs());
    }

    public static void logRemoteRepositoryAccess(final File repositoryRoot) {
        if (loggedRepositories.add(repositoryRoot)) {
            Git.getInstance().getRequestProcessor(repositoryRoot).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashSet urls = new HashSet();
                    GitClient client = null;
                    try {
                        client = Git.getInstance().getClient(repositoryRoot);
                        Map<String, GitRemoteConfig> cfgs = client.getRemotes(NULL_PROGRESS_MONITOR);
                        for (Map.Entry<String, GitRemoteConfig> e : cfgs.entrySet()) {
                            GitRemoteConfig cfg = e.getValue();
                            for (List uris : Arrays.asList(cfg.getUris(), cfg.getPushUris())) {
                                if (uris.isEmpty()) continue;
                                urls.addAll(uris);
                            }
                        }
                    }
                    catch (GitException ex) {
                    }
                    finally {
                        if (client != null) {
                            client.release();
                        }
                    }
                    if (urls.isEmpty()) {
                        Utils.logVCSExternalRepository((String)"GIT", null);
                    }
                    for (String url : urls) {
                        if (url.trim().isEmpty()) continue;
                        Utils.logVCSExternalRepository((String)"GIT", (String)url);
                    }
                }
            });
        }
    }

    public static <T> void attachQuickSearch(List<T> items, JPanel panel, JList listComponent, DefaultListModel model, SearchCallback<T> searchCallback) {
        final QuickSearchCallback<T> callback = new QuickSearchCallback<T>(items, listComponent, model, searchCallback);
        final QuickSearch qs = QuickSearch.attach((JComponent)panel, (Object)"South", callback);
        qs.setAlwaysShown(true);
        listComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                qs.processKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10 && (e.getKeyCode() != 27 || callback.quickSearchActive)) {
                    qs.processKeyEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                qs.processKeyEvent(e);
            }
        });
    }

    private GitUtils() {
    }

    private static class NullProgressMonitor
    extends ProgressMonitor {
        private NullProgressMonitor() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void started(String command) {
        }

        public void finished() {
        }

        public void preparationsFailed(String message) {
        }

        public void notifyError(String message) {
        }

        public void notifyWarning(String message) {
        }
    }

    private static class QuickSearchCallback<T>
    implements QuickSearch.Callback {
        private boolean quickSearchActive;
        private int currentPosition = 0;
        private final List<T> results;
        private final List<T> items;
        private final JList component;
        private final DefaultListModel model;
        private final SearchCallback<T> callback;

        public QuickSearchCallback(List<T> items, JList component, DefaultListModel model, SearchCallback<T> callback) {
            this.items = new ArrayList<T>(items);
            this.results = new ArrayList<T>(items);
            this.component = component;
            this.model = model;
            this.callback = callback;
        }

        public void quickSearchUpdate(String searchText) {
            this.quickSearchActive = true;
            T selected = this.items.get(0);
            if (this.currentPosition > -1) {
                selected = this.results.get(this.currentPosition);
            }
            this.results.clear();
            this.results.addAll(this.items);
            if (!searchText.isEmpty()) {
                ListIterator<T> it = this.results.listIterator();
                while (it.hasNext()) {
                    T item = it.next();
                    if (this.callback.contains(item, searchText)) continue;
                    it.remove();
                }
            }
            this.currentPosition = this.results.indexOf(selected);
            if (this.currentPosition == -1 && !this.results.isEmpty()) {
                this.currentPosition = 0;
            }
            this.updateView();
        }

        public void showNextSelection(boolean forward) {
            if (this.currentPosition != -1) {
                this.currentPosition += forward ? 1 : -1;
                if (this.currentPosition < 0) {
                    this.currentPosition = this.results.size() - 1;
                } else if (this.currentPosition == this.results.size()) {
                    this.currentPosition = 0;
                }
                this.updateSelection();
            }
        }

        public String findMaxPrefix(String prefix) {
            return prefix;
        }

        public void quickSearchConfirmed() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QuickSearchCallback.this.component.requestFocusInWindow();
                }
            });
        }

        public void quickSearchCanceled() {
            this.quickSearchUpdate("");
            this.quickSearchActive = false;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QuickSearchCallback.this.component.requestFocusInWindow();
                }
            });
        }

        private void updateView() {
            this.model.removeAllElements();
            for (T r : this.results) {
                this.model.addElement(r);
            }
            this.updateSelection();
        }

        private void updateSelection() {
            if (this.currentPosition > -1 && this.currentPosition < this.results.size()) {
                T rev = this.results.get(this.currentPosition);
                this.component.setSelectedValue(rev, true);
            }
        }
    }

    public static interface SearchCallback<T> {
        public boolean contains(T var1, String var2);
    }
}

