/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.tag;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.ui.repository.RevisionInfoPanel;
import org.netbeans.modules.git.ui.repository.RevisionInfoPanelController;
import org.netbeans.modules.git.ui.tag.ManageTagsPanel;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.git.utils.WizardStepProgressSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class ManageTags
implements ListSelectionListener,
ActionListener {
    private final File repository;
    private final Map<String, GitTag> tags;
    private final RevisionInfoPanelController revisionInfoController;
    private final ManageTagsPanel panel;
    private final RevisionInfoPanel revisionInfoPanel;
    private Dialog dialog;

    public ManageTags(File repository, Map<String, GitTag> tags, String preselectedTag) {
        this.repository = repository;
        this.tags = tags;
        this.revisionInfoController = new RevisionInfoPanelController(repository);
        this.revisionInfoPanel = this.revisionInfoController.getPanel();
        this.panel = new ManageTagsPanel(this.revisionInfoPanel);
        this.attachListeners();
        this.initTagInfo();
        this.initTags(preselectedTag);
        this.panel.lstTags.setCellRenderer(new TagRenderer());
    }

    public void show() {
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ManageTags.class, (String)"LBL_ManageTags.title"), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, new HelpCtx(ManageTags.class), null);
        this.dialog = DialogDisplayer.getDefault().createDialog(dd);
        this.dialog.setVisible(true);
    }

    private void attachListeners() {
        this.panel.lstTags.addListSelectionListener(this);
        this.panel.btnDelete.addActionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.panel.lstTags && !e.getValueIsAdjusting()) {
            GitTag selectedTag = null;
            Object selectedObject = this.panel.lstTags.getSelectedValue();
            if (selectedObject instanceof GitTag) {
                selectedTag = (GitTag)this.panel.lstTags.getSelectedValue();
            }
            this.updateTagInfo(selectedTag);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GitTag tag;
        Object selectedTag = this.panel.lstTags.getSelectedValue();
        if (selectedTag instanceof GitTag && JOptionPane.showConfirmDialog(this.dialog, NbBundle.getMessage(ManageTags.class, (String)"MSG_ManageTags.deleteTag.confirmation", (Object)(tag = (GitTag)selectedTag).getTagName()), NbBundle.getMessage(ManageTags.class, (String)"LBL_ManageTags.deleteTag.confirmation"), 0, 3) == 0) {
            DeleteTagProgressSupport supp = new DeleteTagProgressSupport(this.panel.panelProgress, tag);
            supp.setEnabled(false);
            supp.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(ManageTags.class, (String)"MSG_ManageTags.deleteTag.progress"));
        }
    }

    private void updateTagInfo(GitTag selectedTag) {
        if (selectedTag != null) {
            this.panel.txtTagName.setText(selectedTag.getTagName());
            if (selectedTag.isLightWeight()) {
                this.displayObjectInfo(false);
            } else {
                this.displayObjectInfo(true);
                this.setText(this.panel.txtTagId, selectedTag.getTagId());
                this.setText(this.panel.txtTagMessage, selectedTag.getMessage());
                this.setText(this.panel.txtTagger, selectedTag.getTagger().toString());
            }
            if (selectedTag.getTaggedObjectType() == GitObjectType.COMMIT) {
                this.revisionInfoController.loadInfo(selectedTag.getTaggedObjectId());
                this.revisionInfoPanel.setVisible(true);
                this.panel.lblTaggedObject.setVisible(false);
                this.panel.txtTaggedObject.setVisible(false);
            } else {
                this.revisionInfoPanel.setVisible(false);
                this.panel.lblTaggedObject.setVisible(true);
                this.panel.txtTaggedObject.setVisible(true);
                this.setText(this.panel.txtTaggedObject, selectedTag.getTaggedObjectType().toString() + " - " + selectedTag.getTaggedObjectId());
            }
        }
    }

    private void initTagInfo() {
        this.revisionInfoController.loadInfo(null);
        this.displayObjectInfo(false);
        this.panel.lblTaggedObject.setVisible(false);
        this.panel.txtTaggedObject.setVisible(false);
        this.revisionInfoController.loadInfo(null);
        this.panel.txtTagName.setText(NbBundle.getMessage(ManageTags.class, (String)"MSG_ManageTags.noTagSelected"));
    }

    private void initTags(String preselectedTag) {
        DefaultListModel<GitTag> model = new DefaultListModel<GitTag>();
        GitTag selected = null;
        GitTag[] tagArray = this.tags.values().toArray(new GitTag[this.tags.values().size()]);
        Arrays.sort(tagArray, new Comparator<GitTag>(){

            @Override
            public int compare(GitTag o1, GitTag o2) {
                return o1.getTagName().compareTo(o2.getTagName());
            }
        });
        for (GitTag tag : tagArray) {
            if (tag.getTagName().equals(preselectedTag)) {
                selected = tag;
            }
            model.addElement(tag);
        }
        this.panel.lstTags.setModel(model);
        if (selected != null) {
            this.panel.lstTags.setSelectedValue(selected, true);
        }
        if (!model.isEmpty()) {
            GitUtils.attachQuickSearch(Arrays.asList(tagArray), this.panel.tagsPanel, this.panel.lstTags, model, new GitUtils.SearchCallback<GitTag>(){

                @Override
                public boolean contains(GitTag item, String needle) {
                    return item.getTagName().toLowerCase().contains(needle.toLowerCase());
                }
            });
        }
    }

    private void setText(JTextComponent comp, String text) {
        comp.setText(text);
        comp.setCaretPosition(comp.getText().length());
        comp.moveCaretPosition(0);
    }

    private void displayObjectInfo(boolean visible) {
        for (JComponent comp : new JComponent[]{this.panel.lblTagId, this.panel.lblTagger, this.panel.lblTagMessage, this.panel.txtTagId, this.panel.txtTagger, this.panel.jScrollPane2}) {
            comp.setVisible(visible);
        }
    }

    private class DeleteTagProgressSupport
    extends WizardStepProgressSupport {
        private final GitTag tag;

        public DeleteTagProgressSupport(JPanel panel, GitTag tag) {
            super(panel, false);
            this.tag = tag;
        }

        @Override
        public void perform() {
            try {
                this.getClient().deleteTag(this.tag.getTagName(), GitUtils.NULL_PROGRESS_MONITOR);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((DefaultListModel)((ManageTags)ManageTags.this).panel.lstTags.getModel()).removeElement(DeleteTagProgressSupport.this.tag);
                    }
                });
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), false);
            }
        }

        @Override
        public void setEnabled(boolean editable) {
            ((ManageTags)ManageTags.this).panel.btnDelete.setEnabled(editable);
        }
    }

    private static class TagRenderer
    extends DefaultListCellRenderer {
        private static final Icon TAG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/git/resources/icons/tag.png", (boolean)true);
        private static final JLabel renderer = new JLabel("", TAG_ICON, 10);

        private TagRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof GitTag) {
                GitTag tag = (GitTag)value;
                renderer.setText(tag.getTagName());
                renderer.setFont(list.getFont());
                renderer.setOpaque(true);
                renderer.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                renderer.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
                renderer.setEnabled(list.isEnabled());
                Border border = null;
                if (cellHasFocus) {
                    if (isSelected) {
                        border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                    }
                    if (border == null) {
                        border = UIManager.getBorder("List.focusCellHighlightBorder");
                    }
                } else {
                    border = new EmptyBorder(1, 1, 1, 1);
                }
                renderer.setBorder(border);
                return renderer;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

