/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.status;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitFileNode;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.status.GitStatusTable;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.git.ui.status.VersioningPanel;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTable;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

class VersioningPanelController
implements ActionListener,
PropertyChangeListener,
PreferenceChangeListener {
    private final VersioningPanel panel;
    private VCSContext context;
    private EnumSet<FileInformation.Status> displayStatuses;
    private final NoContentPanel noContentComponent = new NoContentPanel();
    private static final RequestProcessor RP = new RequestProcessor("GitVersioningWindow", 1, true);
    private RequestProcessor.Task refreshNodesTask = RP.create((Runnable)new RefreshNodesTask());
    private final ApplyChangesTask applyChangeTask = new ApplyChangesTask();
    private RequestProcessor.Task changeTask = RP.create((Runnable)this.applyChangeTask);
    static final Logger LOG = Logger.getLogger(VersioningPanelController.class.getName());
    private final VCSStatusTable<GitStatusNodeImpl> syncTable;
    private FileInformation.Mode mode;
    private GitProgressSupport refreshStatusSupport;
    private final ModeKeeper modeKeeper;
    private PreferenceChangeListener list;
    private final Map<File, FileStatusCache.ChangedEvent> changes = new HashMap<File, FileStatusCache.ChangedEvent>();

    VersioningPanelController() {
        this.panel = new VersioningPanel();
        this.modeKeeper = new ModeKeeper();
        this.initPanelMode();
        this.syncTable = new GitStatusTable((VCSStatusTableModel<GitStatusNodeImpl>)new VCSStatusTableModel((VCSStatusNode[])new GitStatusNodeImpl[0]), this.modeKeeper);
        this.setVersioningComponent(this.syncTable.getComponent());
        this.attachListeners();
    }

    void setActions(JComponent comp) {
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        this.panel.getActionMap().put("prevInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersioningPanelController.this.onNextInnerView();
            }
        });
        this.panel.getActionMap().put("nextInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersioningPanelController.this.onPrevInnerView();
            }
        });
    }

    void focus() {
        this.syncTable.focus();
    }

    JPanel getPanel() {
        return this.panel;
    }

    void setContext(VCSContext context) {
        if (context != this.context) {
            this.context = context;
            this.refreshNodes();
        }
    }

    void cancelRefresh() {
    }

    private void attachListeners() {
        this.panel.tgbHeadVsWorking.addActionListener(this);
        this.panel.tgbHeadVsIndex.addActionListener(this);
        this.panel.tgbIndexVsWorking.addActionListener(this);
        this.panel.btnCommit.addActionListener(this);
        this.panel.btnRevert.addActionListener(this);
        this.panel.btnDiff.addActionListener(this);
        this.panel.btnRefresh.addActionListener(this);
        Git.getInstance().getFileStatusCache().addPropertyChangeListener(this);
        this.list = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)GitModuleConfig.getDefault().getPreferences());
        GitModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this.list);
    }

    private void onPrevInnerView() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.panel.tgbHeadVsIndex.setSelected(true);
        } else if (this.panel.tgbHeadVsIndex.isSelected()) {
            this.panel.tgbIndexVsWorking.setSelected(true);
        } else {
            this.panel.tgbHeadVsWorking.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onNextInnerView() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.panel.tgbIndexVsWorking.setSelected(true);
        } else if (this.panel.tgbIndexVsWorking.isSelected()) {
            this.panel.tgbHeadVsIndex.setSelected(true);
        } else {
            this.panel.tgbHeadVsWorking.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onDisplayedStatusChanged() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.mode = FileInformation.Mode.HEAD_VS_WORKING_TREE;
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanelController.class, (String)"MSG_No_Changes_HeadWorking"));
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING);
            this.modeKeeper.setMode(this.mode);
        } else if (this.panel.tgbHeadVsIndex.isSelected()) {
            this.mode = FileInformation.Mode.HEAD_VS_INDEX;
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanelController.class, (String)"MSG_No_Changes_HeadIndex"));
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX);
            this.modeKeeper.setMode(this.mode);
        } else {
            this.mode = FileInformation.Mode.INDEX_VS_WORKING_TREE;
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanelController.class, (String)"MSG_No_Changes_IndexWorking"));
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_INDEX_VS_WORKING);
            this.modeKeeper.setMode(this.mode);
        }
    }

    private void setDisplayStatuses(EnumSet<FileInformation.Status> displayStatuses) {
        this.displayStatuses = displayStatuses;
        this.refreshNodes();
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        if (e.getSource() == this.panel.tgbHeadVsIndex || e.getSource() == this.panel.tgbHeadVsWorking || e.getSource() == this.panel.tgbIndexVsWorking) {
            this.onDisplayedStatusChanged();
        } else if (e.getSource() == this.panel.btnDiff) {
            ((DiffAction)SystemAction.get(DiffAction.class)).diff(this.context);
        } else {
            Utils.postParallel((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (e.getSource() == ((VersioningPanelController)VersioningPanelController.this).panel.btnRevert) {
                        ((RevertChangesAction)SystemAction.get(RevertChangesAction.class)).performAction(VersioningPanelController.this.context);
                    } else if (e.getSource() == ((VersioningPanelController)VersioningPanelController.this).panel.btnCommit) {
                        ((CommitAction.GitViewCommitAction)SystemAction.get(CommitAction.GitViewCommitAction.class)).performAction(VersioningPanelController.this.context);
                    } else if (e.getSource() == ((VersioningPanelController)VersioningPanelController.this).panel.btnRefresh) {
                        VersioningPanelController.this.refreshStatusSupport = ((StatusAction)SystemAction.get(StatusAction.class)).scanStatus(VersioningPanelController.this.context);
                        if (VersioningPanelController.this.refreshStatusSupport != null) {
                            VersioningPanelController.this.refreshStatusSupport.getTask().waitFinished();
                            if (!VersioningPanelController.this.refreshStatusSupport.isCanceled()) {
                                VersioningPanelController.this.refreshNodes();
                            }
                        }
                    }
                }
            }, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChange(FileStatusCache.ChangedEvent event) {
        if (this.context != null) {
            Map<File, FileStatusCache.ChangedEvent> map = this.changes;
            synchronized (map) {
                this.changes.put(event.getFile(), event);
            }
            this.changeTask.schedule(1000);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("status.changed".equals(evt.getPropertyName())) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)evt.getNewValue();
            if (this.affectsView((FileStatusCache.ChangedEvent)evt.getNewValue())) {
                this.applyChange(changedEvent);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.panel.repaint();
        }
    }

    private boolean affectsView(FileStatusCache.ChangedEvent changedEvent) {
        File file = changedEvent.getFile();
        FileInformation oldInfo = changedEvent.getOldInfo();
        FileInformation newInfo = changedEvent.getNewInfo();
        if (oldInfo == null ? !newInfo.containsStatus(this.displayStatuses) : !oldInfo.containsStatus(this.displayStatuses) && !newInfo.containsStatus(this.displayStatuses)) {
            return false;
        }
        return this.context == null ? false : GitUtils.contains(this.context.getRootFiles(), file);
    }

    private void initPanelMode() {
        this.mode = GitModuleConfig.getDefault().getLastUsedModificationContext();
        this.panel.tgbHeadVsWorking.setSelected(true);
        switch (this.mode) {
            case HEAD_VS_WORKING_TREE: {
                this.panel.tgbHeadVsWorking.setSelected(true);
                break;
            }
            case HEAD_VS_INDEX: {
                this.panel.tgbHeadVsIndex.setSelected(true);
                break;
            }
            case INDEX_VS_WORKING_TREE: {
                this.panel.tgbIndexVsWorking.setSelected(true);
            }
        }
        this.onDisplayedStatusChanged();
    }

    private void setVersioningComponent(final JComponent component) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                Component[] children = VersioningPanelController.this.panel.getComponents();
                for (int i = 0; i < children.length; ++i) {
                    Component child = children[i];
                    if (child == ((VersioningPanelController)VersioningPanelController.this).panel.jPanel2) continue;
                    if (child == component) {
                        return;
                    }
                    VersioningPanelController.this.panel.remove(child);
                    break;
                }
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.gridwidth = 0;
                gbc.gridheight = 1;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                VersioningPanelController.this.panel.add((Component)component, gbc);
                VersioningPanelController.this.panel.revalidate();
                VersioningPanelController.this.panel.repaint();
            }
        });
    }

    private void refreshNodes() {
        if (this.context != null) {
            this.refreshNodesTask.cancel();
            this.refreshNodesTask.schedule(0);
        }
    }

    private class ApplyChangesTask
    implements Runnable {
        private ApplyChangesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet events;
            Map map = VersioningPanelController.this.changes;
            synchronized (map) {
                events = new HashSet(VersioningPanelController.this.changes.values());
                VersioningPanelController.this.changes.clear();
            }
            Iterator it = events.iterator();
            while (it.hasNext()) {
                FileStatusCache.ChangedEvent evt = (FileStatusCache.ChangedEvent)it.next();
                if (VersioningPanelController.this.affectsView(evt)) continue;
                it.remove();
            }
            Git git = Git.getInstance();
            Map nodes = (Map)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Map<File, GitStatusNodeImpl>>(){

                public Map<File, GitStatusNodeImpl> run() {
                    return VersioningPanelController.this.syncTable.getNodes();
                }
            });
            final LinkedList<GitStatusNodeImpl> toRemove = new LinkedList<GitStatusNodeImpl>();
            final LinkedList<GitStatusNodeImpl> toRefresh = new LinkedList<GitStatusNodeImpl>();
            final LinkedList<GitStatusNodeImpl> toAdd = new LinkedList<GitStatusNodeImpl>();
            for (FileStatusCache.ChangedEvent evt : events) {
                FileInformation newInfo = evt.getNewInfo();
                GitStatusNodeImpl node = (GitStatusNodeImpl)((Object)nodes.get(evt.getFile()));
                if (newInfo.containsStatus(VersioningPanelController.this.displayStatuses)) {
                    File parentRepository;
                    if (node != null) {
                        toRefresh.add(node);
                        continue;
                    }
                    File root = git.getRepositoryRoot(evt.getFile());
                    if (root == null) continue;
                    File parentFile = evt.getFile().getParentFile();
                    File file = parentRepository = parentFile == null ? null : git.getRepositoryRoot(parentFile);
                    if (parentRepository != null) {
                        root = parentRepository;
                    }
                    toAdd.add(new GitStatusNodeImpl(new GitFileNode.GitLocalFileNode(root, evt.getFile()), VersioningPanelController.this.mode));
                    continue;
                }
                if (node == null) continue;
                toRemove.add(node);
            }
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    VersioningPanelController.this.syncTable.updateNodes(toRemove, toRefresh, toAdd);
                    if (VersioningPanelController.this.syncTable.getNodes().isEmpty()) {
                        VersioningPanelController.this.setVersioningComponent((JComponent)VersioningPanelController.this.noContentComponent);
                    } else {
                        VersioningPanelController.this.setVersioningComponent(VersioningPanelController.this.syncTable.getComponent());
                    }
                }
            });
        }
    }

    static class GitStatusNodeImpl
    extends GitStatusNode<GitFileNode.GitLocalFileNode> {
        private final FileInformation.Mode mode;

        private GitStatusNodeImpl(GitFileNode.GitLocalFileNode gitLocalFileNode, FileInformation.Mode mode) {
            super(gitLocalFileNode);
            this.mode = mode;
        }

        public Action getPreferredAction() {
            if (((GitFileNode.GitLocalFileNode)this.node).getInformation().containsStatus(FileInformation.Status.IN_CONFLICT)) {
                return SystemAction.get(ResolveConflictsAction.class);
            }
            return SystemAction.get(DiffAction.class);
        }

        @Override
        public String getStatusText() {
            return ((GitFileNode.GitLocalFileNode)this.node).getInformation().getStatusText(this.mode);
        }
    }

    static class ModeKeeper {
        private FileInformation.Mode selectedMode;

        private ModeKeeper() {
        }

        void storeMode() {
            GitModuleConfig.getDefault().setLastUsedModificationContext(this.selectedMode);
        }

        private void setMode(FileInformation.Mode mode) {
            this.selectedMode = mode;
            this.storeMode();
        }
    }

    private class RefreshNodesTask
    implements Runnable {
        private RefreshNodesTask() {
        }

        @Override
        public void run() {
            File[] interestingFiles;
            final LinkedList<GitStatusNodeImpl> nodes = new LinkedList<GitStatusNodeImpl>();
            Git git = Git.getInstance();
            for (File f : interestingFiles = git.getFileStatusCache().listFiles(VersioningPanelController.this.context.getRootFiles(), (EnumSet<FileInformation.Status>)VersioningPanelController.this.displayStatuses)) {
                File root = git.getRepositoryRoot(f);
                if (root == null) continue;
                if (f.equals(root)) {
                    File parentRepository;
                    File parentFile = f.getParentFile();
                    File file = parentRepository = parentFile == null ? null : git.getRepositoryRoot(parentFile);
                    if (parentRepository != null) {
                        root = parentRepository;
                    }
                }
                nodes.add(new GitStatusNodeImpl(new GitFileNode.GitLocalFileNode(root, f), VersioningPanelController.this.mode));
            }
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    VersioningPanelController.this.syncTable.setNodes((VCSStatusNode[])nodes.toArray(new GitStatusNodeImpl[nodes.size()]));
                    if (nodes.isEmpty()) {
                        VersioningPanelController.this.setVersioningComponent((JComponent)VersioningPanelController.this.noContentComponent);
                    } else {
                        VersioningPanelController.this.setVersioningComponent(VersioningPanelController.this.syncTable.getComponent());
                    }
                }
            });
        }
    }
}

