/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.status;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitFileNode;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.ui.actions.AddAction;
import org.netbeans.modules.git.ui.checkout.CheckoutPathsAction;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.commit.DeleteLocalAction;
import org.netbeans.modules.git.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.git.ui.commit.IncludeInCommitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.ignore.IgnoreAction;
import org.netbeans.modules.git.ui.status.Bundle;
import org.netbeans.modules.git.ui.status.VersioningPanelController;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.OpenInEditorAction;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTable;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class GitStatusTable
extends VCSStatusTable<VersioningPanelController.GitStatusNodeImpl> {
    private final VersioningPanelController.ModeKeeper modeKeeper;
    private int popupViewIndex;

    public GitStatusTable(VCSStatusTableModel<VersioningPanelController.GitStatusNodeImpl> model, VersioningPanelController.ModeKeeper modeKeeper) {
        super(model);
        this.modeKeeper = modeKeeper;
        this.setDefaultRenderer(new SyncTableCellRenderer());
    }

    protected void setModelProperties() {
        Node.Property[] properties = new Node.Property[]{new VCSStatusTable.ColumnDescriptor("name", String.class, VCSStatusNode.NameProperty.DISPLAY_NAME, VCSStatusNode.NameProperty.DESCRIPTION), new VCSStatusTable.ColumnDescriptor("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new VCSStatusTable.ColumnDescriptor("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.tableModel.setProperties(properties);
        this.getTable().getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "DeleteAction");
        this.getTable().getActionMap().put("DeleteAction", (Action)SystemAction.get(DeleteLocalAction.class));
    }

    protected JPopupMenu getPopup() {
        final JPopupMenu menu = new JPopupMenu();
        final int popupIndex = ++this.popupViewIndex;
        JMenuItem item = menu.add((Action)new OpenInEditorAction(this.getSelectedFiles()));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        final VersioningPanelController.GitStatusNodeImpl[] selectedNodes = (VersioningPanelController.GitStatusNodeImpl[])this.getSelectedNodes();
        menu.addSeparator();
        final JMenuItem dummyItem = menu.add(Bundle.CTL_GitStatusTable_popup_initializing());
        dummyItem.setEnabled(false);
        Git.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                SystemActionBridge ia;
                Lookup lkp = Lookups.fixed((Object[])((Object[])selectedNodes));
                boolean displayAdd = false;
                boolean allLocallyNew = true;
                for (VersioningPanelController.GitStatusNodeImpl node : selectedNodes) {
                    FileInformation info = ((GitFileNode.GitLocalFileNode)node.getFileNode()).getInformation();
                    if (info.containsStatus(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.IN_CONFLICT, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) {
                        displayAdd = true;
                    }
                    if (info.containsStatus(EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.NEW_HEAD_WORKING_TREE))) continue;
                    allLocallyNew = false;
                }
                if (popupIndex != GitStatusTable.this.popupViewIndex) {
                    return;
                }
                final ArrayList<SystemActionBridge> actions = new ArrayList<SystemActionBridge>();
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction.popupName"), (Lookup)lkp));
                if (popupIndex != GitStatusTable.this.popupViewIndex) {
                    return;
                }
                actions.add(new SystemActionBridge(((DiffAction)SystemAction.get(DiffAction.class)).createContextAwareInstance(lkp), NbBundle.getMessage(DiffAction.class, (String)"LBL_DiffAction_PopupName")){

                    public void actionPerformed(ActionEvent e) {
                        GitStatusTable.this.modeKeeper.storeMode();
                        super.actionPerformed(e);
                    }
                });
                if (displayAdd) {
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(AddAction.class), (String)NbBundle.getMessage(AddAction.class, (String)"LBL_AddAction.popupName"), (Lookup)lkp));
                }
                if (allLocallyNew) {
                    SystemAction systemAction = SystemAction.get(DeleteLocalAction.class);
                    actions.add(SystemActionBridge.createAction((Action)systemAction, (String)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_PopupMenuItem_Delete"), (Lookup)lkp));
                }
                SystemActionBridge efca = SystemActionBridge.createAction((Action)SystemAction.get(ExcludeFromCommitAction.class), (String)NbBundle.getMessage(ExcludeFromCommitAction.class, (String)"LBL_ExcludeFromCommitAction_PopupName"), (Lookup)lkp);
                SystemActionBridge iica = SystemActionBridge.createAction((Action)SystemAction.get(IncludeInCommitAction.class), (String)NbBundle.getMessage(IncludeInCommitAction.class, (String)"LBL_IncludeInCommitAction_PopupName"), (Lookup)lkp);
                if (efca.isEnabled() || iica.isEnabled()) {
                    if (efca.isEnabled()) {
                        actions.add(efca);
                    } else if (iica.isEnabled()) {
                        actions.add(iica);
                    }
                }
                if ((ia = SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)NbBundle.getMessage(IgnoreAction.class, (String)"LBL_IgnoreAction_PopupName"), (Lookup)lkp)).isEnabled()) {
                    actions.add(ia);
                }
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(RevertChangesAction.class), (String)NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_RevertChangesAction_PopupName"), (Lookup)lkp));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CheckoutPathsAction.class), (String)NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_CheckoutPathsAction_PopupName"), (Lookup)lkp));
                ResolveConflictsAction a = (ResolveConflictsAction)SystemAction.get(ResolveConflictsAction.class);
                if (a.isEnabled()) {
                    actions.add(null);
                    actions.add(SystemActionBridge.createAction((Action)((Object)a), (String)NbBundle.getMessage(ResolveConflictsAction.class, (String)"LBL_ResolveConflictsAction_PopupName"), (Lookup)lkp));
                }
                if (popupIndex == GitStatusTable.this.popupViewIndex) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (popupIndex == GitStatusTable.this.popupViewIndex && menu.isShowing()) {
                                menu.setVisible(false);
                                menu.remove(dummyItem);
                                for (Action a : actions) {
                                    if (a == null) {
                                        menu.addSeparator();
                                        continue;
                                    }
                                    JMenuItem item = menu.add(a);
                                    Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                                }
                                menu.pack();
                                menu.repaint();
                                menu.setVisible(true);
                            }
                        }
                    });
                }
            }
        });
        return menu;
    }

    protected void mouseClicked(VCSStatusNode node) {
        Action action = node.getPreferredAction();
        if (action != null && action.isEnabled()) {
            if (action instanceof DiffAction) {
                this.modeKeeper.storeMode();
            }
            action.actionPerformed(new ActionEvent((Object)this, 1001, node.getFile().getAbsolutePath()));
        }
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            GitStatusNode node = null;
            if (modelColumnIndex == 0) {
                node = (GitStatusNode)GitStatusTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                if (!isSelected) {
                    value = node.getHtmlDisplayName();
                }
                if (GitModuleConfig.getDefault().isExcludedFromCommit(node.getFile().getAbsolutePath())) {
                    value = "<s>" + value + "</s>";
                }
                value = "<html>" + value;
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                if (node == null) {
                    node = (GitStatusNode)GitStatusTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                }
                String path = node.getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }
    }
}

