/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.util.RequestProcessor;

public class RepositoryInfo {
    public static final String PROPERTY_ACTIVE_BRANCH = "prop.activeBranch";
    public static final String PROPERTY_HEAD = "prop.head";
    public static final String PROPERTY_STATE = "prop.state";
    public static final String PROPERTY_BRANCHES = "prop.branches";
    public static final String PROPERTY_TAGS = "prop.tags";
    public static final String PROPERTY_REMOTES = "prop.remotes";
    private final Reference<File> rootRef;
    private static final WeakHashMap<File, RepositoryInfo> cache = new WeakHashMap(5);
    private static final Logger LOG = Logger.getLogger(RepositoryInfo.class.getName());
    private static final RequestProcessor rp = new RequestProcessor("RepositoryInfo", 1, true);
    private static final RequestProcessor.Task refreshTask = rp.create((Runnable)new RepositoryRefreshTask());
    private static final Set<RepositoryInfo> repositoriesToRefresh = new HashSet<RepositoryInfo>(2);
    private final PropertyChangeSupport propertyChangeSupport;
    private final Map<String, GitBranch> branches;
    private final Map<String, GitTag> tags;
    private final Map<String, GitRemoteConfig> remotes;
    private GitBranch activeBranch;
    private GitRepositoryState repositoryState;
    private final String name;
    private static final Set<String> logged = Collections.synchronizedSet(new HashSet());

    private RepositoryInfo(File root) {
        this.rootRef = new WeakReference<File>(root);
        this.name = root.getName();
        this.branches = new LinkedHashMap<String, GitBranch>();
        this.tags = new HashMap<String, GitTag>();
        this.remotes = new HashMap<String, GitRemoteConfig>();
        this.activeBranch = GitBranch.NO_BRANCH_INSTANCE;
        this.repositoryState = GitRepositoryState.SAFE;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryInfo getInstance(File repositoryRoot) {
        RepositoryInfo info = null;
        File repositoryRootSingleInstance = Git.getInstance().getRepositoryRoot(repositoryRoot);
        if (repositoryRoot.equals(repositoryRootSingleInstance)) {
            boolean refresh = false;
            WeakHashMap<File, RepositoryInfo> weakHashMap = cache;
            synchronized (weakHashMap) {
                info = cache.get(repositoryRootSingleInstance);
                if (info == null) {
                    info = new RepositoryInfo(repositoryRootSingleInstance);
                    cache.put(repositoryRootSingleInstance, info);
                    refresh = true;
                }
            }
            if (refresh) {
                if (EventQueue.isDispatchThread()) {
                    LOG.log(Level.FINE, "getInstance (): had to schedule an async refresh for {0}", repositoryRoot);
                    RepositoryInfo.refreshAsync(repositoryRoot);
                } else {
                    info.refresh();
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        block10: {
            assert (!EventQueue.isDispatchThread());
            File root = this.rootRef.get();
            GitClient client = null;
            try {
                if (root == null) {
                    LOG.log(Level.WARNING, "refresh (): root is null, it has been collected in the meantime");
                    break block10;
                }
                LOG.log(Level.FINE, "refresh (): starting for {0}", root);
                client = Git.getInstance().getClient(root);
                Map<String, GitBranch> newBranches = client.getBranches(true, GitUtils.NULL_PROGRESS_MONITOR);
                this.setBranches(newBranches);
                Map<String, GitTag> newTags = client.getTags(GitUtils.NULL_PROGRESS_MONITOR, false);
                this.setTags(newTags);
                try {
                    this.refreshRemotes(client);
                }
                catch (GitException ex) {
                    LOG.log(logged.add(root.getAbsolutePath() + ex.getMessage()) ? Level.INFO : Level.FINE, null, ex);
                }
                GitRepositoryState newState = client.getRepositoryState(GitUtils.NULL_PROGRESS_MONITOR);
                this.setActiveBranch(newBranches);
                this.setRepositoryState(newState);
            }
            catch (GitException ex) {
                Level level = root.exists() ? Level.INFO : Level.FINE;
                LOG.log(level, null, ex);
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRemotes() throws GitException {
        assert (!EventQueue.isDispatchThread());
        GitClient client = null;
        try {
            File root = this.rootRef.get();
            if (root == null) {
                LOG.log(Level.WARNING, "refreshRemotes (): root is null, it has been collected in the meantime");
            } else {
                LOG.log(Level.FINE, "refreshRemotes (): starting for {0}", root);
                client = Git.getInstance().getClient(root);
                this.refreshRemotes(client);
            }
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private void setActiveBranch(Map<String, GitBranch> branches) throws GitException {
        for (Map.Entry<String, GitBranch> e : branches.entrySet()) {
            if (!e.getValue().isActive()) continue;
            GitBranch oldActiveBranch = this.activeBranch;
            this.activeBranch = e.getValue();
            if (oldActiveBranch == null || !oldActiveBranch.getName().equals(this.activeBranch.getName())) {
                LOG.log(Level.FINE, "active branch changed: {0} --- {1}", new Object[]{this.rootRef, this.activeBranch.getName()});
                this.propertyChangeSupport.firePropertyChange(PROPERTY_ACTIVE_BRANCH, oldActiveBranch, this.activeBranch);
            }
            if (oldActiveBranch != null && oldActiveBranch.getId().equals(this.activeBranch.getId())) continue;
            LOG.log(Level.FINE, "current HEAD changed: {0} --- {1}", new Object[]{this.rootRef, this.activeBranch.getId()});
            this.propertyChangeSupport.firePropertyChange(PROPERTY_HEAD, oldActiveBranch, this.activeBranch);
        }
    }

    private void setRepositoryState(GitRepositoryState repositoryState) {
        GitRepositoryState oldState = this.repositoryState;
        this.repositoryState = repositoryState;
        if (!repositoryState.equals((Object)oldState)) {
            LOG.log(Level.FINE, "repository state changed: {0} --- {1}", new Object[]{oldState, repositoryState});
            this.propertyChangeSupport.firePropertyChange(PROPERTY_STATE, oldState, repositoryState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBranches(Map<String, GitBranch> newBranches) {
        LinkedHashMap<String, GitBranch> oldBranches;
        boolean changed = false;
        Map<String, GitBranch> map = this.branches;
        synchronized (map) {
            oldBranches = new LinkedHashMap<String, GitBranch>(this.branches);
            this.branches.clear();
            this.branches.putAll(newBranches);
            changed = !RepositoryInfo.equalsBranches(oldBranches, newBranches);
        }
        if (changed) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_BRANCHES, Collections.unmodifiableMap(oldBranches), Collections.unmodifiableMap(new HashMap<String, GitBranch>(newBranches)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTags(Map<String, GitTag> newTags) {
        HashMap<String, GitTag> oldTags;
        boolean changed = false;
        Map<String, GitTag> map = this.tags;
        synchronized (map) {
            oldTags = new HashMap<String, GitTag>(this.tags);
            if (!RepositoryInfo.equalsTags(oldTags, newTags)) {
                this.tags.clear();
                this.tags.putAll(newTags);
                changed = true;
            }
        }
        if (changed) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_TAGS, Collections.unmodifiableMap(oldTags), Collections.unmodifiableMap(new HashMap<String, GitTag>(newTags)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRemotes(Map<String, GitRemoteConfig> newRemotes) {
        HashMap<String, GitRemoteConfig> oldRemotes;
        boolean changed = false;
        Map<String, GitRemoteConfig> map = this.remotes;
        synchronized (map) {
            oldRemotes = new HashMap<String, GitRemoteConfig>(this.remotes);
            if (!RepositoryInfo.equalsRemotes(oldRemotes, newRemotes)) {
                this.remotes.clear();
                this.remotes.putAll(newRemotes);
                changed = true;
            }
        }
        if (changed) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_REMOTES, Collections.unmodifiableMap(oldRemotes), Collections.unmodifiableMap(new HashMap<String, GitRemoteConfig>(newRemotes)));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public GitBranch getActiveBranch() {
        return this.activeBranch;
    }

    public GitRepositoryState getRepositoryState() {
        return this.repositoryState;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GitBranch> getBranches() {
        Map<String, GitBranch> map = this.branches;
        synchronized (map) {
            return new LinkedHashMap<String, GitBranch>(this.branches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GitTag> getTags() {
        Map<String, GitTag> map = this.tags;
        synchronized (map) {
            return new HashMap<String, GitTag>(this.tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GitRemoteConfig> getRemotes() {
        Map<String, GitRemoteConfig> map = this.remotes;
        synchronized (map) {
            return new HashMap<String, GitRemoteConfig>(this.remotes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAsync(File repositoryRoot) {
        RepositoryInfo info = null;
        WeakHashMap<File, RepositoryInfo> weakHashMap = cache;
        synchronized (weakHashMap) {
            info = cache.get(repositoryRoot);
        }
        if (info != null) {
            boolean start = false;
            Set<RepositoryInfo> set = repositoriesToRefresh;
            synchronized (set) {
                start = repositoriesToRefresh.add(info);
            }
            if (start) {
                LOG.log(Level.FINE, "Planning refresh for {0}", repositoryRoot);
                refreshTask.schedule(3000);
            }
        }
    }

    private static boolean equalsRemotes(Map<String, GitRemoteConfig> oldRemotes, Map<String, GitRemoteConfig> newRemotes) {
        boolean retval;
        boolean bl = retval = oldRemotes.size() == newRemotes.size() && oldRemotes.keySet().equals(newRemotes.keySet());
        if (retval) {
            for (Map.Entry<String, GitRemoteConfig> e : oldRemotes.entrySet()) {
                GitRemoteConfig oldRemote = e.getValue();
                GitRemoteConfig newRemote = newRemotes.get(e.getKey());
                if (oldRemote.getFetchRefSpecs().equals(newRemote.getFetchRefSpecs()) && oldRemote.getPushRefSpecs().equals(newRemote.getPushRefSpecs()) && oldRemote.getUris().equals(newRemote.getUris()) && oldRemote.getPushUris().equals(newRemote.getPushUris())) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    private static boolean equalsBranches(Map<String, GitBranch> oldBranches, Map<String, GitBranch> newBranches) {
        boolean retval;
        boolean bl = retval = oldBranches.size() == newBranches.size() && oldBranches.keySet().equals(newBranches.keySet());
        if (retval) {
            for (Map.Entry<String, GitBranch> e : oldBranches.entrySet()) {
                GitBranch oldBranch = e.getValue();
                GitBranch newBranch = newBranches.get(e.getKey());
                if (oldBranch.getId().equals(newBranch.getId()) && RepositoryInfo.equalTracking(newBranch, oldBranch)) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    private static boolean equalTracking(GitBranch newBranch, GitBranch oldBranch) {
        GitBranch tracked2;
        boolean equal;
        GitBranch tracked1 = newBranch.getTrackedBranch();
        boolean bl = equal = tracked1 == (tracked2 = oldBranch.getTrackedBranch());
        if (!equal) {
            equal = tracked1 != null && tracked2 != null && tracked1.getName().equals(tracked2.getName()) && tracked1.getId().equals(tracked2.getId());
        }
        return equal;
    }

    private static boolean equalsTags(Map<String, GitTag> oldTags, Map<String, GitTag> newTags) {
        boolean retval;
        boolean bl = retval = oldTags.size() == newTags.size() && oldTags.keySet().equals(newTags.keySet());
        if (retval) {
            for (Map.Entry<String, GitTag> e : oldTags.entrySet()) {
                GitTag oldTag = e.getValue();
                GitTag newTag = newTags.get(e.getKey());
                if (oldTag.getMessage().equals(newTag.getMessage()) && oldTag.getTagId().equals(newTag.getTagId()) && oldTag.getTagName().equals(newTag.getTagName()) && oldTag.getTaggedObjectId().equals(newTag.getTaggedObjectId()) && oldTag.getTaggedObjectType().equals((Object)newTag.getTaggedObjectType()) && oldTag.getTagger().toString().equals(newTag.getTagger().toString())) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    private void refreshRemotes(GitClient client) throws GitException {
        Map<String, GitRemoteConfig> newRemotes = client.getRemotes(GitUtils.NULL_PROGRESS_MONITOR);
        this.setRemotes(newRemotes);
    }

    private static class RepositoryRefreshTask
    implements Runnable {
        private RepositoryRefreshTask() {
        }

        @Override
        public void run() {
            RepositoryInfo info;
            while ((info = this.getNextRepositoryInfo()) != null) {
                info.refresh();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RepositoryInfo getNextRepositoryInfo() {
            RepositoryInfo info = null;
            Set set = repositoriesToRefresh;
            synchronized (set) {
                Iterator it = repositoriesToRefresh.iterator();
                if (it.hasNext()) {
                    info = (RepositoryInfo)it.next();
                    it.remove();
                }
            }
            return info;
        }
    }
}

