/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.merge;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.merge.MergeRevision;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.git.utils.LogUtils;
import org.netbeans.modules.git.utils.ResultProcessor;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class MergeRevisionAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(MergeRevisionAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.mergeRevision(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void mergeRevision(final File repository, String preselectedRevision) {
        final MergeRevision mergeRevision = new MergeRevision(repository, new File[0], preselectedRevision);
        if (mergeRevision.show()) {
            GitProgressSupport supp = new GitProgressSupport(){
                private String revision;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    try {
                        GitUtils.runWithoutIndexing(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                boolean cont;
                                GitClient client = this.getClient();
                                client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new File[]{repository}));
                                revision = mergeRevision.getRevision();
                                LOG.log(Level.FINE, "Merging revision {0} into HEAD", revision);
                                MergeResultProcessor mrp = new MergeResultProcessor(client, repository, revision, this.getLogger(), this.getProgressMonitor());
                                do {
                                    cont = false;
                                    try {
                                        GitMergeResult result = client.merge(revision, this.getProgressMonitor());
                                        mrp.processResult(result);
                                    }
                                    catch (GitException.CheckoutConflictException ex) {
                                        if (LOG.isLoggable(Level.FINE)) {
                                            LOG.log(Level.FINE, "Local modifications in WT during merge: {0} - {1}", new Object[]{repository, Arrays.asList(ex.getConflicts())});
                                        }
                                        cont = mrp.resolveLocalChanges(ex.getConflicts());
                                    }
                                } while (cont);
                                return null;
                            }
                        }, repository);
                    }
                    catch (GitException ex) {
                        try {
                            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                        }
                        catch (Throwable throwable) {
                            this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                            GitUtils.headChanged(repository);
                            throw throwable;
                        }
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                        GitUtils.headChanged(repository);
                    }
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(MergeRevisionAction.class, (String)"LBL_MergeRevisionAction.progressName"));
        }
    }

    public static class MergeResultProcessor
    extends ResultProcessor {
        private final OutputLogger logger;
        private final String revision;
        private final GitBranch current;

        public MergeResultProcessor(GitClient client, File repository, String revision, OutputLogger logger, ProgressMonitor pm) {
            super(client, repository, revision, pm);
            this.current = RepositoryInfo.getInstance(repository).getActiveBranch();
            this.revision = revision;
            this.logger = logger;
        }

        public void processResult(GitMergeResult result) {
            StringBuilder sb = new StringBuilder(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result", (Object)result.getMergeStatus().toString()));
            GitRevisionInfo info = null;
            if (result.getNewHead() != null) {
                try {
                    info = this.client.log(result.getNewHead(), GitUtils.NULL_PROGRESS_MONITOR);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
            boolean logActions = false;
            switch (result.getMergeStatus()) {
                case ALREADY_UP_TO_DATE: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.alreadyUpToDate", (Object)this.revision));
                    break;
                }
                case FAST_FORWARD: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.fastForward", (Object)this.revision));
                    GitUtils.printInfo(sb, info, false);
                    logActions = true;
                    break;
                }
                case MERGED: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.merged", (Object)this.revision));
                    GitUtils.printInfo(sb, info, false);
                    logActions = true;
                    break;
                }
                case CONFLICTING: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.conflict", (Object)this.revision));
                    this.printConflicts(sb, result.getConflicts());
                    this.resolveConflicts(result.getConflicts());
                    break;
                }
                case FAILED: {
                    final Action openAction = this.logger.getOpenOutputAction();
                    if (openAction != null) {
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    openAction.actionPerformed(new ActionEvent(MergeResultProcessor.this, 1001, null));
                                }
                            });
                        }
                        catch (InterruptedException ex) {
                        }
                        catch (InvocationTargetException ex) {
                            // empty catch block
                        }
                    }
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.failedFiles", (Object)this.revision));
                    this.printConflicts(sb, result.getFailures());
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.failed", (Object)this.revision), 0));
                    break;
                }
                case NOT_SUPPORTED: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.unsupported"));
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.unsupported"), 0));
                }
            }
            this.logger.outputLine(sb.toString());
            if (logActions) {
                LogUtils.logBranchUpdateReview(this.repository, this.current.getName(), this.current.getId(), result.getNewHead(), this.logger);
            }
        }
    }
}

