/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitUser;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.options.AnnotationColorProvider;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.history.Bundle;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class SummaryView
extends AbstractSummaryView {
    private final SearchHistoryPanel master;
    private static final DateFormat defaultFormat = DateFormat.getDateTimeInstance(3, 3);
    private static final Color HIGHLIGHT_BRANCH_FG = Color.BLACK;
    private static final Color HIGHLIGHT_TAG_FG = Color.BLACK;
    private static final Color HIGHLIGHT_BRANCH_BG = Color.decode("0xaaffaa");
    private static final Color HIGHLIGHT_TAG_BG = Color.decode("0xffffaa");

    public SummaryView(SearchHistoryPanel master, List<? extends AbstractSummaryView.LogEntry> results, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap) {
        super(SummaryView.createViewSummaryMaster(master), results, kenaiUserMap);
        this.master = master;
    }

    private static AbstractSummaryView.SummaryViewMaster createViewSummaryMaster(final SearchHistoryPanel master) {
        final HashMap<String, String> colors = new HashMap<String, String>();
        colors.put("A", GitUtils.getColorString(AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor()));
        colors.put("C", GitUtils.getColorString(AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor()));
        colors.put("R", GitUtils.getColorString(AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor()));
        colors.put("M", GitUtils.getColorString(AnnotationColorProvider.getInstance().MODIFIED_FILE.getActualColor()));
        colors.put("D", GitUtils.getColorString(AnnotationColorProvider.getInstance().REMOVED_FILE.getActualColor()));
        colors.put("?", GitUtils.getColorString(AnnotationColorProvider.getInstance().EXCLUDED_FILE.getActualColor()));
        return new AbstractSummaryView.SummaryViewMaster(){

            public JComponent getComponent() {
                return master;
            }

            public File[] getRoots() {
                return master.getRoots();
            }

            public Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> getSearchHighlights() {
                return master.getSearchHighlights();
            }

            public Map<String, String> getActionColors() {
                return colors;
            }

            public void getMoreResults(PropertyChangeListener callback, int count) {
                master.getMoreRevisions(callback, count);
            }

            public boolean hasMoreResults() {
                return master.hasMoreResults();
            }
        };
    }

    protected void onPopup(JComponent invoker, Point p, final Object[] selection) {
        RepositoryRevision.Event[] drev;
        RepositoryRevision container;
        JPopupMenu menu = new JPopupMenu();
        boolean revisionsSelected = false;
        boolean missingFile = false;
        boolean viewEnabled = false;
        boolean revertEnabled = false;
        final boolean singleSelection = selection.length == 1;
        for (Object o : selection) {
            revisionsSelected = true;
            if (o instanceof GitLogEntry) continue;
            revisionsSelected = false;
        }
        if (revisionsSelected) {
            container = ((GitLogEntry)selection[0]).revision;
            drev = new RepositoryRevision.Event[]{};
        } else {
            drev = new RepositoryRevision.Event[selection.length];
            revertEnabled = true;
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof GitLogEvent)) {
                    return;
                }
                drev[i] = ((GitLogEvent)((Object)selection[i])).getEvent();
                if (!missingFile && drev[i].getFile() == null) {
                    missingFile = true;
                }
                if (drev[i].getFile() != null && drev[i].getAction() != 'D') {
                    viewEnabled = true;
                } else {
                    revertEnabled = false;
                }
                if (i <= 0) continue;
                revertEnabled &= drev[i].getLogInfoHeader() == drev[i - 1].getLogInfoHeader();
            }
            container = drev[0].getLogInfoHeader();
        }
        boolean hasParents = singleSelection && container.getLog().getParents().length > 0;
        final boolean canView = viewEnabled;
        final boolean canAnnotate = viewEnabled;
        if (hasParents) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious")){
                {
                    super(x0);
                    this.setEnabled(singleSelection);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.diffPrevious(selection[0], SummaryView.this.master);
                }
            }));
        }
        if (revisionsSelected) {
            if (singleSelection) {
                for (Action a : container.getActions()) {
                    menu.add(new JMenuItem(a));
                }
            } else if (selection.length == 2) {
                menu.add(new JMenuItem(new AbstractAction(Bundle.LBL_SummaryView_action_diffRevisions()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File[] roots = SummaryView.this.master.getRoots();
                        ArrayList<1> nodes = new ArrayList<1>(roots.length);
                        for (final File root : roots) {
                            nodes.add(new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{root})){

                                public String getDisplayName() {
                                    return root.getName();
                                }
                            });
                        }
                        GitRevisionInfo info1 = ((GitLogEntry)selection[0]).getRepositoryRevision().getLog();
                        GitRevisionInfo info2 = ((GitLogEntry)selection[1]).getRepositoryRevision().getLog();
                        ((DiffAction)SystemAction.get(DiffAction.class)).diff(VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()])), new Revision(info2.getRevision(), info2.getRevision(), info2.getShortMessage(), info2.getFullMessage()), new Revision(info1.getRevision(), info1.getRevision(), info1.getShortMessage(), info1.getFullMessage()));
                    }
                }));
            }
        } else {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(x0);
                    this.setEnabled(canView);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    new GitProgressSupport(){

                        @Override
                        protected void perform() {
                            for (RepositoryRevision.Event evt : drev) {
                                if (evt.getFile() == null || evt.getAction() == 'D') continue;
                                evt.openFile(false, this.getProgressMonitor());
                                if (!this.getProgressMonitor().isCanceled()) continue;
                                return;
                            }
                        }
                    }.start(Git.getInstance().getRequestProcessor(), SummaryView.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){
                {
                    super(x0);
                    this.setEnabled(canAnnotate);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    new GitProgressSupport(){

                        @Override
                        protected void perform() {
                            for (RepositoryRevision.Event evt : drev) {
                                if (evt.getFile() == null || evt.getAction() == 'D') continue;
                                evt.openFile(true, this.getProgressMonitor());
                                if (!this.getProgressMonitor().isCanceled()) continue;
                                return;
                            }
                        }
                    }.start(Git.getInstance().getRequestProcessor(), SummaryView.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                }
            }));
            if (revertEnabled) {
                menu.add(new JMenuItem(drev[0].getRevertAction(null).createAction(this.master.getRepository(), drev)));
            }
            menu.add(new JMenuItem(new AbstractAction(Bundle.CTL_Action_ViewCurrent_name()){
                {
                    super(x0);
                    this.setEnabled(canAnnotate);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    new GitProgressSupport(){

                        @Override
                        protected void perform() {
                            for (RepositoryRevision.Event evt : drev) {
                                if (evt.getFile() == null || evt.getAction() == 'D') continue;
                                Utils.openFile((File)FileUtil.normalizeFile((File)evt.getFile()));
                            }
                        }
                    }.start(Git.getInstance().getRequestProcessor(), SummaryView.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                }
            }));
            if (drev.length == 2 && drev[0].getLogInfoHeader() != drev[1].getLogInfoHeader()) {
                menu.add(new JMenuItem(new AbstractAction(Bundle.LBL_SummaryView_action_diffFiles()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.this.master.showDiff(drev);
                    }
                }));
            }
        }
        menu.show(invoker, p.x, p.y);
    }

    private static void diffPrevious(Object o, SearchHistoryPanel master) {
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            master.showDiff(drev);
        } else if (o instanceof RepositoryRevision) {
            RepositoryRevision container = (RepositoryRevision)o;
            master.showDiff(container);
        } else if (o instanceof GitLogEvent) {
            master.showDiff(((GitLogEvent)((Object)o)).event);
        } else if (o instanceof GitLogEntry) {
            master.showDiff(((GitLogEntry)o).revision);
        }
    }

    static final class GitLogEntry
    extends AbstractSummaryView.LogEntry
    implements PropertyChangeListener {
        private final RepositoryRevision revision;
        private List<AbstractSummaryView.LogEntry.Event> events = new ArrayList<AbstractSummaryView.LogEntry.Event>(10);
        private List<AbstractSummaryView.LogEntry.Event> dummyEvents;
        private final SearchHistoryPanel master;
        private String complexRevision;
        private final PropertyChangeListener list;
        private Collection<AbstractSummaryView.LogEntry.RevisionHighlight> complexRevisionHighlights;

        public GitLogEntry(RepositoryRevision revision, SearchHistoryPanel master) {
            this.revision = revision;
            this.master = master;
            this.dummyEvents = Collections.emptyList();
            if (revision.isEventsInitialized()) {
                this.refreshEvents();
                this.list = null;
            } else {
                this.prepareDummyEvents();
                this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)revision);
                revision.addPropertyChangeListener("eventsChanged", this.list);
            }
        }

        public Collection<AbstractSummaryView.LogEntry.Event> getEvents() {
            return this.events;
        }

        public Collection<AbstractSummaryView.LogEntry.Event> getDummyEvents() {
            return this.dummyEvents;
        }

        public String getAuthor() {
            GitUser author = this.revision.getLog().getAuthor();
            return author == null ? "" : author.toString();
        }

        public String getDate() {
            Date date = new Date(this.revision.getLog().getCommitTime());
            return defaultFormat.format(date);
        }

        public String getRevision() {
            if (this.complexRevision == null) {
                this.complexRevisionHighlights = new ArrayList<AbstractSummaryView.LogEntry.RevisionHighlight>(this.revision.getBranches().length + this.revision.getTags().length + 1);
                StringBuilder sb = new StringBuilder();
                for (GitBranch gitBranch : this.revision.getBranches()) {
                    if (gitBranch.getName() != "(no branch)") {
                        this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(sb.length(), gitBranch.getName().length(), HIGHLIGHT_BRANCH_FG, HIGHLIGHT_BRANCH_BG));
                        sb.append(gitBranch.getName()).append(' ');
                    }
                    if (!gitBranch.isActive()) continue;
                    this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(sb.length(), "HEAD".length(), HIGHLIGHT_BRANCH_FG, HIGHLIGHT_BRANCH_BG));
                    sb.append("HEAD").append(' ');
                }
                for (GitBranch gitBranch : this.revision.getTags()) {
                    this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(sb.length(), gitBranch.getTagName().length(), HIGHLIGHT_TAG_FG, HIGHLIGHT_TAG_BG));
                    sb.append(gitBranch.getTagName()).append(' ');
                }
                String rev = this.revision.getLog().getRevision();
                sb.append(rev.length() > 7 ? rev.substring(0, 7) : rev);
                this.complexRevision = sb.toString();
            }
            return this.complexRevision;
        }

        protected Collection<AbstractSummaryView.LogEntry.RevisionHighlight> getRevisionHighlights() {
            this.getRevision();
            return this.complexRevisionHighlights;
        }

        public String getMessage() {
            return this.revision.getLog().getFullMessage();
        }

        public Action[] getActions() {
            boolean hasParents;
            ArrayList<Action> actions = new ArrayList<Action>();
            boolean bl = hasParents = this.revision.getLog().getParents().length > 0;
            if (hasParents) {
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious_Short")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.diffPrevious(GitLogEntry.this.revision, GitLogEntry.this.master);
                    }
                });
            }
            actions.addAll(Arrays.asList(this.revision.getActions()));
            return actions.toArray(new Action[actions.size()]);
        }

        public String toString() {
            return this.revision.toString();
        }

        protected void expand() {
            this.revision.expandEvents();
        }

        protected void cancelExpand() {
            this.revision.cancelExpand();
        }

        protected boolean isEventsInitialized() {
            return this.revision.isEventsInitialized();
        }

        public boolean isVisible() {
            return this.master.applyFilter(this.revision);
        }

        protected boolean isLessInteresting() {
            return this.getRepositoryRevision().getLog().getParents().length > 1;
        }

        RepositoryRevision getRepositoryRevision() {
            return this.revision;
        }

        void prepareDummyEvents() {
            ArrayList<AbstractSummaryView.LogEntry.Event> evts = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.revision.getDummyEvents().length);
            for (RepositoryRevision.Event event : this.revision.getDummyEvents()) {
                evts.add(new GitLogEvent(this.master, event));
            }
            this.dummyEvents = evts;
        }

        void refreshEvents() {
            ArrayList<AbstractSummaryView.LogEntry.Event> evts = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.revision.getEvents().length);
            for (RepositoryRevision.Event event : this.revision.getEvents()) {
                evts.add(new GitLogEvent(this.master, event));
            }
            ArrayList newEvents = new ArrayList(evts);
            this.events = evts;
            this.dummyEvents.clear();
            this.eventsChanged(null, newEvents);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("eventsChanged".equals(evt.getPropertyName()) && this.revision == evt.getSource()) {
                this.refreshEvents();
            }
        }
    }

    static class GitLogEvent
    extends AbstractSummaryView.LogEntry.Event {
        private final RepositoryRevision.Event event;
        private final SearchHistoryPanel master;

        GitLogEvent(SearchHistoryPanel master, RepositoryRevision.Event event) {
            this.master = master;
            this.event = event;
        }

        public String getPath() {
            return this.event.getPath();
        }

        public String getOriginalPath() {
            return this.event.getOriginalPath();
        }

        public String getAction() {
            return Character.toString(this.event.getAction());
        }

        public RepositoryRevision.Event getEvent() {
            return this.event;
        }

        public Action[] getUserActions() {
            boolean hasParents;
            ArrayList<Action> actions = new ArrayList<Action>();
            boolean bl = hasParents = this.event.getLogInfoHeader().getLog().getParents().length > 0;
            if (hasParents) {
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.diffPrevious(GitLogEvent.this.event, GitLogEvent.this.master);
                    }
                });
            }
            actions.addAll(Arrays.asList(this.event.getActions(false)));
            return actions.toArray(new Action[actions.size()]);
        }

        public boolean isVisibleByDefault() {
            return this.master.isShowInfo() || this.event.isUnderRoots();
        }

        public String toString() {
            return this.event.toString();
        }
    }
}

