/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.BorderLayout;
import java.io.File;
import java.util.List;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.history.DiffResultsView;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(persistenceType=2, preferredID="Git.SearchHistoryTopComponent")
public class SearchHistoryTopComponent
extends TopComponent {
    private SearchHistoryPanel shp;
    private SearchCriteriaPanel scp;
    private final File[] files;
    private final File repository;
    private final RepositoryInfo info;

    public SearchHistoryTopComponent(File repository, RepositoryInfo info, File[] files) {
        this.repository = repository;
        this.info = info;
        this.files = files;
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
        this.initComponents();
    }

    SearchHistoryTopComponent(File repository, RepositoryInfo info, File file, DiffResultsViewFactory fac) {
        this(repository, info, new File[]{file});
        this.shp.setDiffResultsViewFactory(fac);
    }

    public void search(boolean showCriteria) {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(showCriteria);
    }

    void setSearchCommitFrom(String commitId) {
        if (commitId != null) {
            this.scp.tfFrom.setText(commitId);
        }
    }

    void setSearchCommitTo(String commitId) {
        if (commitId != null) {
            this.scp.tfTo.setText(commitId);
        }
    }

    void setBranch(String branch) {
        if (branch != null) {
            this.shp.setBranch(branch);
            if (GitModuleConfig.getDefault().isSearchOnlyCurrentBranchEnabled()) {
                this.scp.setBranch(branch);
            }
        }
    }

    void activateDiffView(boolean selectFirstRevision) {
        this.shp.activateDiffView(selectFirstRevision);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel();
        this.shp = new SearchHistoryPanel(this.repository, this.info, this.files, this.scp);
        this.add(this.shp);
    }

    protected void componentClosed() {
        this.shp.releaseDiff();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    static class DiffResultsViewFactory {
        DiffResultsViewFactory() {
        }

        DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
            return new DiffResultsView(panel, results);
        }
    }
}

