/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRefUpdateResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.modules.git.ui.fetch.Bundle;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.git.utils.LogUtils;

final class FetchUtils {
    private static final Set<GitRefUpdateResult> UPDATED_STATUSES = new HashSet<GitRefUpdateResult>(Arrays.asList(GitRefUpdateResult.FAST_FORWARD, GitRefUpdateResult.FORCED, GitRefUpdateResult.NEW, GitRefUpdateResult.OK, GitRefUpdateResult.RENAMED));

    static void log(File repository, Map<String, GitTransportUpdate> updates, OutputLogger logger) {
        if (updates.isEmpty()) {
            logger.outputLine(Bundle.MSG_GetRemoteChangesAction_updates_noChange());
        } else {
            for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                GitTransportUpdate update = e.getValue();
                if (!UPDATED_STATUSES.contains(update.getResult())) continue;
                if (update.getType() == GitTransportUpdate.Type.BRANCH) {
                    logger.outputLine(Bundle.MSG_GetRemoteChangesAction_updates_updateBranch(update.getLocalName(), update.getOldObjectId(), update.getNewObjectId(), update.getResult()));
                    String oldId = update.getOldObjectId();
                    String newId = update.getNewObjectId();
                    String branchName = update.getLocalName();
                    LogUtils.logBranchUpdateReview(repository, branchName, oldId, newId, logger);
                    continue;
                }
                logger.outputLine(Bundle.MSG_GetRemoteChangesAction_updates_updateTag(update.getLocalName(), update.getResult()));
            }
        }
    }

    private static String parseRemote(String branchName) {
        int pos = branchName.indexOf(47);
        String remoteName = null;
        if (pos > 0) {
            remoteName = branchName.substring(0, pos);
        }
        return remoteName;
    }

    static GitRemoteConfig getRemoteConfigForActiveBranch(GitBranch trackedBranch, RepositoryInfo info, String errorLabel) {
        GitRemoteConfig cfg;
        Map<String, GitRemoteConfig> remotes = info.getRemotes();
        String remoteName = FetchUtils.parseRemote(trackedBranch.getName());
        GitRemoteConfig gitRemoteConfig = cfg = remoteName == null ? null : remotes.get(remoteName);
        if (cfg == null) {
            GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noRemote(trackedBranch.getName()));
            return null;
        }
        if (cfg.getUris().isEmpty()) {
            GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noUri(cfg.getRemoteName()));
            return null;
        }
        if (cfg.getFetchRefSpecs().isEmpty()) {
            GitUtils.notifyError(errorLabel, Bundle.MSG_Err_noSpecs(cfg.getRemoteName()));
            return null;
        }
        return cfg;
    }

    private FetchUtils() {
    }
}

