/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.fetch.Bundle;
import org.netbeans.modules.git.ui.fetch.FetchAction;
import org.netbeans.modules.git.ui.fetch.FetchUtils;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class FetchFromUpstreamAction
extends MultipleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/fetch.png";

    public FetchFromUpstreamAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        return this.fetch(repository);
    }

    private RequestProcessor.Task fetch(final File repository) {
        final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
        GitProgressSupport.NoOutputLogging supp = new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                RepositoryInfo info = RepositoryInfo.getInstance(repository);
                try {
                    info.refreshRemotes();
                }
                catch (GitException ex) {
                    Logger.getLogger(FetchFromUpstreamAction.class.getName()).log(Level.INFO, null, ex);
                }
                String errorLabel = Bundle.LBL_Fetch_fetchFromUpstreamFailed();
                GitBranch trackedBranch = GitUtils.getTrackedBranch(info, errorLabel);
                if (trackedBranch == null) {
                    return;
                }
                GitRemoteConfig cfg = FetchUtils.getRemoteConfigForActiveBranch(trackedBranch, info, errorLabel);
                if (cfg == null) {
                    return;
                }
                String uri = (String)cfg.getUris().get(0);
                Utils.logVCSExternalRepository((String)"GIT", (String)uri);
                if (!this.isCanceled()) {
                    t[0] = ((FetchAction)SystemAction.get(FetchAction.class)).fetch(repository, uri, cfg.getFetchRefSpecs(), null);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_FetchFromUpstreamAction_preparing()).waitFinished();
        return t[0];
    }
}

