/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.awt.EventQueue;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.fetch.Bundle;
import org.netbeans.modules.git.ui.fetch.FetchUtils;
import org.netbeans.modules.git.ui.fetch.FetchWizard;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.RequestProcessor;

public class FetchAction
extends SingleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/fetch-setting.png";

    public FetchAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.fetch(repository);
    }

    public void fetch(final File repository, GitRemoteConfig remote) {
        if (remote.getUris().size() != 1) {
            Utils.post((Runnable)new Runnable(){

                @Override
                public void run() {
                    FetchAction.this.fetch(repository);
                }
            });
        } else {
            this.fetch(repository, (String)remote.getUris().get(0), remote.getFetchRefSpecs(), null);
        }
    }

    private void fetch(final File repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        try {
            info.refreshRemotes();
        }
        catch (GitException ex) {
            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
        }
        final Map<String, GitRemoteConfig> remotes = info.getRemotes();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FetchWizard wiz = new FetchWizard(repository, remotes);
                if (wiz.show()) {
                    Utils.logVCSExternalRepository((String)"GIT", (String)wiz.getFetchUri());
                    FetchAction.this.fetch(repository, wiz.getFetchUri(), wiz.getFetchRefSpecs(), wiz.getRemoteToPersist());
                }
            }
        });
    }

    public RequestProcessor.Task fetch(final File repository, final String target, final List<String> fetchRefSpecs, final String remoteNameToUpdate) {
        final ArrayList<String> fetchRefSpecsList = new ArrayList<String>(fetchRefSpecs);
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    HashSet<String> toDelete = new HashSet<String>();
                    ListIterator it = fetchRefSpecsList.listIterator();
                    while (it.hasNext()) {
                        String refSpec = (String)it.next();
                        if (!refSpec.startsWith(":refs/remotes/")) continue;
                        it.remove();
                        toDelete.add(refSpec.substring(":refs/remotes/".length()));
                    }
                    GitClient client = this.getClient();
                    for (String branch : toDelete) {
                        client.deleteBranch(branch, true, this.getProgressMonitor());
                        this.getLogger().outputLine(Bundle.MSG_FetchAction_branchDeleted(branch));
                    }
                    if (!fetchRefSpecsList.isEmpty() && !this.isCanceled()) {
                        if (remoteNameToUpdate != null) {
                            GitRemoteConfig config = client.getRemote(remoteNameToUpdate, this.getProgressMonitor());
                            if (this.isCanceled()) {
                                return;
                            }
                            config = GitUtils.prepareConfig(config, remoteNameToUpdate, target, fetchRefSpecsList);
                            client.setRemote(config, this.getProgressMonitor());
                            if (this.isCanceled()) {
                                return;
                            }
                        }
                        Map<String, GitTransportUpdate> updates = FetchAction.fetchRepeatedly(client, this.getProgressMonitor(), target, fetchRefSpecs);
                        if (!this.isCanceled()) {
                            FetchUtils.log(repository, updates, this.getLogger());
                        }
                    }
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
        };
        return supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_FetchAction_progressName(repository.getName()));
    }

    static Map<String, GitTransportUpdate> fetchRepeatedly(GitClient client, ProgressMonitor monitor, String target, List<String> fetchRefSpecs) throws GitException {
        ArrayList<String> fetchRefSpecsList = new ArrayList<String>(fetchRefSpecs);
        Map<String, GitTransportUpdate> result = null;
        while (result == null && !fetchRefSpecsList.isEmpty() && !monitor.isCanceled()) {
            try {
                result = client.fetch(target, fetchRefSpecsList, monitor);
            }
            catch (GitException ex) {
                boolean found = false;
                if (fetchRefSpecsList.size() > 1) {
                    ListIterator it = fetchRefSpecsList.listIterator();
                    while (it.hasNext()) {
                        String refSpec = (String)it.next();
                        String remoteHead = GitUtils.parseRemoteHeadFromFetch(refSpec);
                        if (refSpec == null || !ex.getMessage().toLowerCase().matches(MessageFormat.format(".*remote does not have {0} available for fetch.*", remoteHead))) continue;
                        it.remove();
                        found = true;
                        Logger.getLogger(FetchAction.class.getName()).log(Level.INFO, "Remote does not have head according to spec {0}, trying fetching without the spec.", refSpec);
                        break;
                    }
                }
                if (found) continue;
                throw ex;
            }
        }
        return result;
    }
}

