/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.io.File;
import javax.swing.Action;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.GitFileNode;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.ui.diff.Setup;
import org.netbeans.modules.versioning.diff.DiffLookup;
import org.netbeans.modules.versioning.util.OpenInEditorAction;
import org.openide.cookies.EditorCookie;
import org.openide.util.Lookup;

public abstract class DiffNode<T extends GitFileNode>
extends GitStatusNode<T>
implements Cloneable {
    private final Setup setup;

    protected DiffNode(T node, Setup setup, EditorCookie eCookie) {
        super(node, DiffNode.getLookupFor(eCookie, node.getLookupObjects()));
        this.setup = setup;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public abstract DiffNode clone();

    private static Lookup getLookupFor(EditorCookie eCookie, Object[] lookupObjects) {
        Object[] allLookupObjects;
        if (eCookie == null) {
            allLookupObjects = new Object[lookupObjects.length];
        } else {
            allLookupObjects = new Object[lookupObjects.length + 1];
            allLookupObjects[allLookupObjects.length - 1] = eCookie;
        }
        System.arraycopy(lookupObjects, 0, allLookupObjects, 0, lookupObjects.length);
        DiffLookup lkp = new DiffLookup();
        lkp.setData(allLookupObjects);
        return lkp;
    }

    public static class DiffHistoryNode
    extends DiffNode<GitFileNode.GitHistoryFileNode> {
        DiffHistoryNode(GitFileNode.GitHistoryFileNode node, Setup setup) {
            super(node, setup, null);
        }

        public Action getPreferredAction() {
            return null;
        }

        @Override
        public String getStatusText() {
            return ((GitFileNode.GitHistoryFileNode)this.node).getInformation().getStatusText();
        }

        @Override
        public DiffNode clone() {
            return new DiffHistoryNode((GitFileNode.GitHistoryFileNode)this.getFileNode(), this.getSetup());
        }
    }

    public static class DiffLocalNode
    extends DiffNode<GitFileNode.GitLocalFileNode> {
        private final FileInformation.Mode mode;

        DiffLocalNode(GitFileNode.GitLocalFileNode node, Setup setup, EditorCookie eCookie, FileInformation.Mode mode) {
            super(node, setup, eCookie);
            this.mode = mode;
        }

        public Action getPreferredAction() {
            return new OpenInEditorAction(new File[]{this.getFile()});
        }

        @Override
        public String getStatusText() {
            return ((GitFileNode.GitLocalFileNode)this.node).getInformation().getStatusText(this.mode);
        }

        @Override
        public DiffNode clone() {
            return new DiffLocalNode((GitFileNode.GitLocalFileNode)this.getFileNode(), this.getSetup(), (EditorCookie)this.getLookup().lookup(EditorCookie.class), this.mode);
        }
    }
}

