/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.ui.diff.DiffNode;
import org.netbeans.modules.git.ui.diff.MultiDiffPanelController;
import org.netbeans.modules.versioning.util.common.FileTreeView;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

class DiffFileTreeImpl
extends FileTreeView<DiffNode> {
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String PATH_SEPARATOR_REGEXP = File.separator.replace("\\", "\\\\");
    private static Image FOLDER_ICON;
    private final MultiDiffPanelController master;
    boolean fff = false;

    public DiffFileTreeImpl(MultiDiffPanelController master) {
        this.master = master;
        this.setupColumns();
    }

    private void setupColumns() {
        Node.Property[] properties = new Node.Property[]{new ColumnDescriptor<String>("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new ColumnDescriptor<String>("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.view.setProperties(properties);
        this.view.getOutline().setRenderDataProvider(this.createRenderProvider());
    }

    public Object prepareModel(DiffNode[] nodes) {
        AbstractNode rootNode;
        HashMap<File, Collection<DiffNode>> sortedNodes = new HashMap<File, Collection<DiffNode>>();
        for (DiffNode n : nodes) {
            File repository = Git.getInstance().getRepositoryRoot(n.getFile());
            if (repository == null) continue;
            TreeSet<DiffNode> repositorySetups = (TreeSet<DiffNode>)sortedNodes.get(repository);
            if (repositorySetups == null) {
                repositorySetups = new TreeSet<DiffNode>(new PathComparator());
                sortedNodes.put(repository, repositorySetups);
            }
            repositorySetups.add(n);
        }
        if (sortedNodes.size() == 1) {
            Map.Entry e = sortedNodes.entrySet().iterator().next();
            rootNode = new RepositoryRootNode((File)e.getKey(), new ArrayList<DiffNode>((Collection)e.getValue()));
            ((DiffTreeViewChildren)rootNode.getChildren()).buildSubNodes();
        } else {
            rootNode = new RootNode(sortedNodes);
            ((DiffTreeViewChildren)rootNode.getChildren()).buildSubNodes();
        }
        return rootNode;
    }

    protected DiffNode convertToAcceptedNode(Node node) {
        return node instanceof DiffNode ? (DiffNode)node : null;
    }

    private RenderDataProvider createRenderProvider() {
        return new FileTreeView.AbstractRenderDataProvider(){

            protected String annotateName(DiffNode node, String originalLabel) {
                if (GitModuleConfig.getDefault().isExcludedFromCommit(node.getSetup().getBaseFile().getAbsolutePath())) {
                    originalLabel = "<s>" + (originalLabel == null ? node.getName() : originalLabel) + "</s>";
                }
                return originalLabel;
            }
        };
    }

    protected void nodeSelected(DiffNode node) {
        if (node == null) {
            this.master.filesSelected(new File[0]);
        } else {
            this.master.filesSelected(node.getFile());
        }
    }

    public void setSelectedNode(DiffNode toSelect) {
        super.setSelectedNode((Node)toSelect);
    }

    protected JPopupMenu getPopup() {
        List nodes = this.getSelectedNodes();
        List<File> files = this.toFiles(nodes);
        return this.master.getPopupFor(nodes.toArray(new Node[nodes.size()]), files.toArray(new File[files.size()]));
    }

    protected void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = DiffFileTreeImpl.this.view.getWidth();
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 40 / 100);
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 20 / 100);
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 40 / 100);
            }
        });
    }

    private List<File> toFiles(List<Node> nodes) {
        ArrayList<File> files = new ArrayList<File>(nodes.size());
        for (Node n : nodes) {
            File f = (File)n.getLookup().lookup(File.class);
            if (f == null) continue;
            files.add(f);
        }
        return files;
    }

    private static String getCommonPrefix(DiffNode[] nodes) {
        String prefix = "";
        if (nodes.length > 0) {
            prefix = nodes[0].getFileNode().getRelativePath();
            int index = prefix.lastIndexOf(File.separator);
            prefix = index == -1 ? "" : prefix.substring(0, index);
        }
        boolean slashNeeded = !prefix.isEmpty();
        for (DiffNode n : nodes) {
            String location = n.getFileNode().getRelativePath();
            while (!location.startsWith(prefix)) {
                slashNeeded = false;
                int index = prefix.lastIndexOf(File.separator);
                if (index == -1) {
                    prefix = "";
                    continue;
                }
                prefix = prefix.substring(0, index);
            }
        }
        return slashNeeded ? prefix + File.separator : prefix;
    }

    private static Image getFolderIcon() {
        if (FOLDER_ICON == null) {
            Image base;
            Icon baseIcon = UIManager.getIcon(ICON_KEY_UIMANAGER);
            if (baseIcon != null) {
                base = ImageUtilities.icon2Image((Icon)baseIcon);
            } else {
                base = (Image)UIManager.get(ICON_KEY_UIMANAGER_NB);
                if (base == null) {
                    base = ImageUtilities.loadImage((String)"org/openide/loaders/defaultFolder.gif");
                }
            }
            FOLDER_ICON = base;
        }
        return FOLDER_ICON;
    }

    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private static abstract class DiffTreeViewChildren
    extends Children.Array {
        private DiffTreeViewChildren() {
        }

        abstract void buildSubNodes();
    }

    private class NodeChildren
    extends DiffTreeViewChildren {
        private final DiffNode[] nestedNodes;
        private final String path;
        private final boolean top;
        private final File file;

        public NodeChildren(NodeData data, boolean top) {
            this.nestedNodes = data.nestedNodes;
            this.path = data.path;
            this.file = data.file;
            this.top = top;
        }

        @Override
        void buildSubNodes() {
            ArrayList<NodeData> data = new ArrayList<NodeData>(this.nestedNodes.length);
            String prefix = null;
            ArrayList<DiffNode> subNodes = new ArrayList<DiffNode>();
            for (DiffNode n : this.nestedNodes) {
                String location = n.getFileNode().getRelativePath();
                if (prefix == null) {
                    prefix = this.path + location.substring(this.path.length()).split(PATH_SEPARATOR_REGEXP, 0)[0];
                }
                if (location.equals(prefix)) {
                    if (!subNodes.isEmpty()) {
                        data.add(new NodeData(this.getFile(prefix), prefix, subNodes.toArray(new DiffNode[subNodes.size()])));
                        subNodes.clear();
                    }
                    data.add(new NodeData(this.getFile(prefix), prefix, new DiffNode[]{n}));
                    prefix = null;
                    continue;
                }
                if (location.startsWith(prefix)) {
                    subNodes.add(n);
                    continue;
                }
                data.add(new NodeData(this.getFile(prefix), prefix, subNodes.toArray(new DiffNode[subNodes.size()])));
                subNodes.clear();
                prefix = this.path + location.substring(this.path.length()).split(PATH_SEPARATOR_REGEXP, 0)[0];
                subNodes.add(n);
            }
            if (!subNodes.isEmpty()) {
                data.add(new NodeData(this.getFile(prefix), prefix, subNodes.toArray(new DiffNode[subNodes.size()])));
            }
            this.add(this.createNodes(data));
        }

        private Node[] createNodes(List<NodeData> keys) {
            ArrayList<Node> toCreate = new ArrayList<Node>(keys.size());
            for (NodeData key : keys) {
                Object node;
                if (key.nestedNodes.length == 0) continue;
                if (key.nestedNodes.length == 1 && key.path.equals(key.nestedNodes[0].getFileNode().getRelativePath())) {
                    node = DiffFileTreeImpl.this.createFilterNode((Node)key.nestedNodes[0]);
                } else {
                    String name;
                    if (this.top) {
                        name = key.path;
                    } else {
                        String[] segments = key.path.split(PATH_SEPARATOR_REGEXP);
                        name = segments[segments.length - 1];
                    }
                    final Image icon = this.getFolderIcon(key.file);
                    NodeChildren ch = new NodeChildren(new NodeData(key.file, key.path + File.separator, key.nestedNodes), false);
                    node = new AbstractNode((Children)ch, Lookups.fixed((Object[])new Object[]{key.file})){

                        public String getName() {
                            return name;
                        }

                        public Image getIcon(int type) {
                            return icon;
                        }
                    };
                    ch.buildSubNodes();
                }
                toCreate.add((Node)node);
            }
            return toCreate.toArray(new Node[toCreate.size()]);
        }

        private Image getFolderIcon(File file) {
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            Icon icon = null;
            if (fo != null) {
                try {
                    ProjectManager.Result res = ProjectManager.getDefault().isProject2(fo);
                    if (res != null) {
                        icon = res.getIcon();
                    }
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(DiffFileTreeImpl.class.getName()).log(Level.INFO, null, ex);
                }
            }
            return icon == null ? DiffFileTreeImpl.getFolderIcon() : ImageUtilities.icon2Image(icon);
        }

        private File getFile(String prefix) {
            String p = prefix;
            if (prefix.startsWith(this.path)) {
                p = prefix.substring(this.path.length());
            }
            return new File(this.file, p);
        }
    }

    private static class NodeData {
        private final File file;
        private final String path;
        private final DiffNode[] nestedNodes;

        public NodeData(File file, String path, DiffNode[] nested) {
            this.file = file;
            this.path = path;
            this.nestedNodes = nested;
        }
    }

    private static class PathComparator
    implements Comparator<DiffNode> {
        private PathComparator() {
        }

        @Override
        public int compare(DiffNode o1, DiffNode o2) {
            String[] segments1 = o1.getFileNode().getRelativePath().split(PATH_SEPARATOR_REGEXP);
            String[] segments2 = o2.getFileNode().getRelativePath().split(PATH_SEPARATOR_REGEXP);
            for (int i = 0; i < Math.min(segments1.length, segments2.length); ++i) {
                String segment1 = segments1[i];
                String segment2 = segments2[i];
                int comp = segment1.compareTo(segment2);
                if (comp == 0) continue;
                if (segment1.startsWith(segment2)) {
                    return segment2.length() - segment1.length();
                }
                if (segment2.startsWith(segment1)) {
                    return segment2.length() - segment1.length();
                }
                return comp;
            }
            return segments2.length - segments1.length;
        }
    }

    private class RepositoryRootNode
    extends AbstractNode {
        private final File repo;

        RepositoryRootNode(File repository, List<DiffNode> nestedNodes) {
            this(repository, nestedNodes.toArray(new DiffNode[nestedNodes.size()]));
        }

        private RepositoryRootNode(File repository, DiffNode[] nestedNodes) {
            super((Children)new NodeChildren(new NodeData(new File(repository, DiffFileTreeImpl.getCommonPrefix(nestedNodes)), DiffFileTreeImpl.getCommonPrefix(nestedNodes), nestedNodes), true), Lookups.fixed((Object[])new Object[]{repository}));
            this.repo = repository;
        }

        public String getName() {
            return this.repo.getName();
        }

        public Image getIcon(int type) {
            return DiffFileTreeImpl.getFolderIcon();
        }
    }

    private class RootNode
    extends AbstractNode {
        public RootNode(Map<File, Collection<DiffNode>> nodes) {
            super((Children)new RootNodeChildren(nodes));
        }
    }

    private class RootNodeChildren
    extends DiffTreeViewChildren {
        private final Map<File, Collection<DiffNode>> nestedNodes;

        public RootNodeChildren(Map<File, Collection<DiffNode>> setups) {
            this.nestedNodes = setups;
        }

        @Override
        void buildSubNodes() {
            this.add(this.createNodes());
        }

        private Node[] createNodes() {
            ArrayList<RepositoryRootNode> nodes = new ArrayList<RepositoryRootNode>(this.nestedNodes.size());
            for (Map.Entry<File, Collection<DiffNode>> e : this.nestedNodes.entrySet()) {
                RepositoryRootNode root = new RepositoryRootNode(e.getKey(), new ArrayList<DiffNode>(e.getValue()));
                ((DiffTreeViewChildren)root.getChildren()).buildSubNodes();
                nodes.add(root);
            }
            return nodes.toArray(new Node[nodes.size()]);
        }
    }
}

