/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class IncludeInCommitAction
extends MultipleRepositoryAction {
    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        return this.include(repository, roots);
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = super.enable(activatedNodes);
        if (enabled) {
            enabled = false;
            GitModuleConfig config = GitModuleConfig.getDefault();
            for (File root : this.getCurrentContext(activatedNodes).getRootFiles()) {
                enabled = true;
                if (config.isExcludedFromCommit(root.getAbsolutePath())) continue;
                enabled = false;
                break;
            }
        }
        return enabled;
    }

    public RequestProcessor.Task include(File repository, File[] roots) {
        List<String> toInclude = IncludeInCommitAction.filterRoots(roots);
        GitModuleConfig config = GitModuleConfig.getDefault();
        config.removeExclusionPaths(toInclude);
        ((IncludeInCommitAction)SystemAction.get(IncludeInCommitAction.class)).setEnabled(false);
        ((ExcludeFromCommitAction)SystemAction.get(ExcludeFromCommitAction.class)).setEnabled(false);
        return null;
    }

    private static List<String> filterRoots(File[] roots) {
        LinkedList<String> toInclude = new LinkedList<String>();
        GitModuleConfig config = GitModuleConfig.getDefault();
        for (File root : roots) {
            String path = root.getAbsolutePath();
            if (!config.isExcludedFromCommit(path)) continue;
            toInclude.add(path);
        }
        return toInclude;
    }
}

