/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.io.File;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.branch.Bundle;
import org.netbeans.modules.git.ui.branch.SelectTrackedBranch;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;

public class SetTrackingAction
extends SingleRepositoryAction {
    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        GitBranch activeBranch = info.getActiveBranch();
        if (activeBranch.getName() != "(no branch)") {
            this.setupTrackedBranch(repository, activeBranch.getName(), activeBranch.getTrackedBranch() == null ? null : activeBranch.getTrackedBranch().getName());
        }
    }

    public void setupTrackedBranch(File repository, final String branchName, String currentTrackedBranch) {
        final SelectTrackedBranch selectBranch = new SelectTrackedBranch(repository, branchName, currentTrackedBranch);
        if (selectBranch.open()) {
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        GitClient client = this.getClient();
                        String targetBranch = selectBranch.getSelectedBranch();
                        client.updateTracking(branchName, targetBranch, this.getProgressMonitor());
                        this.log(branchName, targetBranch);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }

                private void log(String branchName2, String targetBranchName) {
                    OutputLogger logger = this.getLogger();
                    logger.outputLine(Bundle.MSG_SetTrackingAction_result(branchName2, targetBranchName));
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_SetTrackingAction_progressName());
        }
    }
}

