/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.git.ui.branch.Bundle;
import org.netbeans.modules.git.ui.branch.SelectTrackedBranchPanel;
import org.netbeans.modules.git.ui.repository.RevisionDialogController;
import org.netbeans.modules.git.ui.repository.SelectBranchPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;

public final class SelectTrackedBranch {
    private final SelectTrackedBranchPanel panel;
    private final String branchName;
    protected final SelectBranchPanel selectBranchPanel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;

    public SelectTrackedBranch(File repository, String branchName, String preselectedBranch) {
        this.revisionPicker = new RevisionDialogController(repository, new File[0], Collections.emptyMap(), preselectedBranch);
        this.branchName = branchName;
        this.selectBranchPanel = new SelectBranchPanel(this.revisionPicker.getPanel());
        this.panel = new SelectTrackedBranchPanel(this.selectBranchPanel);
        this.panel.errorLabel.setText(Bundle.SelectTrackedBranchPanel_error_noselection(branchName));
    }

    public String getSelectedBranch() {
        return this.revisionPicker.getRevision().getRevision();
    }

    public boolean open() {
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)Bundle.BranchSelector_okButton_text());
        this.dd = new DialogDescriptor((Object)this.panel, Bundle.BranchSelector_title(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    boolean valid = Boolean.TRUE.equals(evt.getNewValue());
                    if (!valid) {
                        ((SelectTrackedBranch)SelectTrackedBranch.this).panel.errorLabel.setText(Bundle.SelectTrackedBranchPanel_error_noselection(SelectTrackedBranch.this.branchName));
                    } else if (SelectTrackedBranch.this.branchName.equals(SelectTrackedBranch.this.revisionPicker.getRevision().getRevision())) {
                        valid = false;
                        ((SelectTrackedBranch)SelectTrackedBranch.this).panel.errorLabel.setText(Bundle.SelectTrackedBranchPanel_error_samerevision(SelectTrackedBranch.this.branchName));
                    }
                    if (valid) {
                        ((SelectTrackedBranch)SelectTrackedBranch.this).panel.errorLabel.setText(Bundle.SelectTrackedBranchPanel_info(SelectTrackedBranch.this.branchName, SelectTrackedBranch.this.revisionPicker.getRevision().getRevision()));
                    }
                    SelectTrackedBranch.this.setRevisionValid(valid);
                }
            }
        });
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        this.okButton.setEnabled(false);
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    private void setRevisionValid(boolean flag) {
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }
}

