/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.io.File;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.modules.git.Bundle;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.options.AnnotationColorProvider;
import org.netbeans.modules.versioning.util.OptionsPanelColorProvider;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSFileInformation;
import org.netbeans.modules.versioning.util.common.VCSFileNode;

public abstract class GitFileNode<T extends FileNodeInformation>
extends VCSFileNode {
    protected GitFileNode(File root, File file) {
        super(root, file);
    }

    public abstract FileNodeInformation getInformation();

    public static abstract class FileNodeInformation
    extends VCSFileInformation {
        public abstract boolean isCopied();

        public abstract boolean isRenamed();

        public abstract File getOldFile();
    }

    public static class GitHistoryFileNode
    extends GitFileNode<HistoryFileInformation> {
        private final HistoryFileInformation fi;

        public GitHistoryFileNode(File root, File file, HistoryFileInformation info) {
            super(root, file);
            this.fi = info;
        }

        @Override
        public HistoryFileInformation getInformation() {
            return this.fi;
        }

        public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
            return VCSCommitOptions.EXCLUDE;
        }
    }

    public static class GitLocalFileNode
    extends GitFileNode<FileInformation> {
        public GitLocalFileNode(File root, File file) {
            super(root, file);
        }

        @Override
        public FileInformation getInformation() {
            return Git.getInstance().getFileStatusCache().getStatus(this.getFile());
        }

        public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
            if (withExclusions && GitModuleConfig.getDefault().isExcludedFromCommit(this.getFile().getAbsolutePath())) {
                return VCSCommitOptions.EXCLUDE;
            }
            if (this.getInformation().containsStatus(FileInformation.STATUS_REMOVED)) {
                return VCSCommitOptions.COMMIT_REMOVE;
            }
            if (this.getInformation().containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
                return GitModuleConfig.getDefault().getExludeNewFiles() ? VCSCommitOptions.EXCLUDE : VCSCommitOptions.COMMIT;
            }
            return VCSCommitOptions.COMMIT;
        }
    }

    public static class HistoryFileInformation
    extends FileNodeInformation {
        private final GitRevisionInfo.GitFileInfo info;

        public HistoryFileInformation(GitRevisionInfo.GitFileInfo info) {
            this.info = info;
        }

        @Override
        public boolean isCopied() {
            return this.info.getStatus() == GitRevisionInfo.GitFileInfo.Status.COPIED;
        }

        @Override
        public boolean isRenamed() {
            return this.info.getStatus() == GitRevisionInfo.GitFileInfo.Status.RENAMED;
        }

        @Override
        public File getOldFile() {
            return this.info.getOriginalFile();
        }

        public String getOldPath() {
            return this.info.getOriginalPath();
        }

        public String getStatusText() {
            switch (this.info.getStatus()) {
                case ADDED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Added();
                }
                case COPIED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Copied();
                }
                case MODIFIED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Modified();
                }
                case REMOVED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Removed();
                }
                case RENAMED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Renamed();
                }
            }
            return Bundle.CTL_HistoryFileInfo_Status_Unknown();
        }

        public int getComparableStatus() {
            return GitRevisionInfo.GitFileInfo.Status.values().length - this.info.getStatus().ordinal();
        }

        public String annotateNameHtml(String name) {
            OptionsPanelColorProvider.AnnotationFormat format;
            switch (this.info.getStatus()) {
                case ADDED: {
                    format = AnnotationColorProvider.getInstance().ADDED_FILE;
                    break;
                }
                case COPIED: {
                    format = AnnotationColorProvider.getInstance().ADDED_FILE;
                    break;
                }
                case MODIFIED: {
                    format = AnnotationColorProvider.getInstance().MODIFIED_FILE;
                    break;
                }
                case REMOVED: {
                    format = AnnotationColorProvider.getInstance().REMOVED_FILE;
                    break;
                }
                case RENAMED: {
                    format = AnnotationColorProvider.getInstance().ADDED_FILE;
                    break;
                }
                default: {
                    format = AnnotationColorProvider.getInstance().EXCLUDED_FILE;
                }
            }
            return format.getFormat().format(new Object[]{name, ""});
        }
    }
}

