/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitRepositories;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.SearchHistorySupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class FilesystemInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private final Set<File> filesToRefresh = new HashSet<File>();
    private final Map<File, Set<File>> lockedRepositories = new HashMap<File, Set<File>>(5);
    private final RequestProcessor.Task refreshTask;
    private final RequestProcessor.Task lockedRepositoryRefreshTask;
    private final RequestProcessor.Task refreshOwnersTask;
    private static final RequestProcessor rp = new RequestProcessor("GitRefresh", 1, true);
    private final GitFolderEventsHandler gitFolderEventsHandler;
    private final CommandUsageLogger commandLogger;
    private static boolean AUTOMATIC_REFRESH_ENABLED = !"true".equals(System.getProperty("versioning.git.autoRefreshDisabled", "false"));
    private static final String INDEX_FILE_NAME = "index";
    private static final String HEAD_FILE_NAME = "HEAD";
    private static final String REFS_FILE_NAME = "refs";
    private static final Logger LOG = Logger.getLogger(FilesystemInterceptor.class.getName());
    private final Map<File, Long> createdFolders = new LinkedHashMap<File, Long>(){

        @Override
        public Long put(File key, Long value) {
            long t = System.currentTimeMillis();
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if ((Long)e.getValue() >= t - 600000L) continue;
                it.remove();
            }
            return super.put(key, value);
        }
    };
    final ProgressMonitor.DefaultProgressMonitor shutdownMonitor = new ProgressMonitor.DefaultProgressMonitor();

    public FilesystemInterceptor() {
        this.cache = Git.getInstance().getFileStatusCache();
        this.refreshTask = rp.create((Runnable)new RefreshTask(), true);
        this.lockedRepositoryRefreshTask = rp.create((Runnable)new LockedRepositoryRefreshTask());
        this.gitFolderEventsHandler = new GitFolderEventsHandler();
        this.commandLogger = new CommandUsageLogger();
        this.refreshOwnersTask = rp.create(new Runnable(){

            @Override
            public void run() {
                Git git = Git.getInstance();
                git.clearAncestorCaches();
                git.versionedFilesChanged();
                VersioningSupport.versionedRootsChanged();
            }
        });
    }

    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        File metadataFolder;
        long retval = -1L;
        if (".git".equals(dir.getName()) || this.gitFolderEventsHandler.isMetadataFolder(dir)) {
            Git.STATUS_LOG.log(Level.FINER, "Interceptor.refreshRecursively: {0}", dir.getAbsolutePath());
            children.clear();
            retval = this.gitFolderEventsHandler.refreshAdminFolder(dir);
            File[] ch = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return FilesystemInterceptor.REFS_FILE_NAME.equals(name);
                }
            });
            if (ch != null) {
                children.addAll(Arrays.asList(ch));
            }
        } else if (GitUtils.isPartOfGitMetadata(dir) && (metadataFolder = this.gitFolderEventsHandler.getMetadataForReferences(dir)) != null) {
            this.gitFolderEventsHandler.refreshReferences(metadataFolder, dir);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeCreate(File file, boolean isDirectory) {
        LOG.log(Level.FINE, "beforeCreate {0} - {1}", new Object[]{file, isDirectory});
        if (GitUtils.isPartOfGitMetadata(file)) {
            return false;
        }
        if (!isDirectory && !file.exists()) {
            Git git = Git.getInstance();
            File root = git.getRepositoryRoot(file);
            if (root == null) {
                return false;
            }
            GitClient client = null;
            try {
                client = git.getClient(root);
                client.reset(new File[]{file}, HEAD_FILE_NAME, true, GitUtils.NULL_PROGRESS_MONITOR);
            }
            catch (GitException.MissingObjectException ex) {
                if (!HEAD_FILE_NAME.equals(ex.getObjectName())) {
                    LOG.log(Level.INFO, "beforeCreate(): File: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
                }
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, "beforeCreate(): File: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
            LOG.log(Level.FINER, "beforeCreate(): finished: {0}", file);
        }
        return false;
    }

    public void afterCreate(File file) {
        LOG.log(Level.FINE, "afterCreate {0}", file);
        if (GitUtils.isPartOfGitMetadata(file) && "index.lock".equals(file.getName())) {
            this.commandLogger.locked(file);
        }
        if (GitUtils.isAdministrative(file)) {
            this.refreshOwnersTask.schedule(0);
        }
        this.addToCreated(file);
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file), true);
        }
    }

    public boolean beforeDelete(File file) {
        LOG.log(Level.FINE, "beforeDelete {0}", file);
        if (file == null) {
            return false;
        }
        if (GitUtils.isPartOfGitMetadata(file)) {
            return false;
        }
        return !this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED);
    }

    public void doDelete(File file) throws IOException {
        LOG.log(Level.FINE, "doDelete {0}", file);
        if (file == null) {
            return;
        }
        Git git = Git.getInstance();
        File root = git.getRepositoryRoot(file);
        GitClient client = null;
        try {
            if (GitUtils.getGitFolderForRoot(root).exists()) {
                client = git.getClient(root);
                client.remove(new File[]{file}, false, GitUtils.NULL_PROGRESS_MONITOR);
            } else if (file.exists()) {
                Utils.deleteRecursively((File)file);
                if (file.exists()) {
                    IOException ex = new IOException();
                    Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file, ""}));
                    throw ex;
                }
            }
            if (file.equals(root)) {
                this.gitFolderEventsHandler.refreshIndexFileTimestamp(root);
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public void afterDelete(File file) {
        LOG.log(Level.FINE, "afterDelete {0}", file);
        if (file == null) {
            return;
        }
        if (GitUtils.isPartOfGitMetadata(file) && "index.lock".equals(file.getName())) {
            this.commandLogger.unlocked(file);
        }
        if (".git".equals(file.getName())) {
            this.refreshOwnersTask.schedule(3000);
        }
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file), true);
        }
    }

    public boolean beforeMove(File from, File to) {
        LOG.log(Level.FINE, "beforeMove {0} -> {1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return true;
        }
        Git hg = Git.getInstance();
        return hg.isManaged(from) && hg.isManaged(to);
    }

    public void doMove(File from, File to) throws IOException {
        LOG.log(Level.FINE, "doMove {0} -> {1}", new Object[]{from, to});
        if (from == null || to == null || to.exists() && !this.equalPathsIgnoreCase(from, to)) {
            return;
        }
        Git git = Git.getInstance();
        File root = git.getRepositoryRoot(from);
        File dstRoot = git.getRepositoryRoot(to);
        GitClient client = null;
        try {
            if (root != null && root.equals(dstRoot) && !this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
                client = git.getClient(root);
                if (this.equalPathsIgnoreCase(from, to)) {
                    if (!from.renameTo(to)) {
                        throw new IOException(NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, ""}));
                    }
                    client.rename(from, to, true, GitUtils.NULL_PROGRESS_MONITOR);
                } else {
                    client.rename(from, to, false, GitUtils.NULL_PROGRESS_MONITOR);
                }
            } else {
                boolean result = from.renameTo(to);
                if (!result) {
                    throw new IOException(NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, ""}));
                }
                if (root != null) {
                    client = git.getClient(root);
                    client.remove(new File[]{from}, true, GitUtils.NULL_PROGRESS_MONITOR);
                }
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private boolean equalPathsIgnoreCase(File from, File to) {
        return Utilities.isWindows() && from.equals(to) || Utilities.isMac() && from.getPath().equalsIgnoreCase(to.getPath());
    }

    public void afterMove(File from, File to) {
        LOG.log(Level.FINE, "afterMove {0} -> {1}", new Object[]{from, to});
        if (from == null || to == null || !to.exists()) {
            return;
        }
        if (from.equals(Git.getInstance().getRepositoryRoot(from)) || to.equals(Git.getInstance().getRepositoryRoot(to))) {
            this.refreshOwnersTask.schedule(0);
        }
        if (!this.cache.getStatus(from).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(from), true);
        }
        this.addToCreated(to);
        if (!this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(to), true);
        }
    }

    public boolean beforeCopy(File from, File to) {
        LOG.log(Level.FINE, "beforeCopy {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return true;
        }
        Git git = Git.getInstance();
        return git.isManaged(from) && git.isManaged(to);
    }

    public void doCopy(File from, File to) throws IOException {
        LOG.log(Level.FINE, "doCopy {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return;
        }
        Git git = Git.getInstance();
        File root = git.getRepositoryRoot(from);
        File dstRoot = git.getRepositoryRoot(to);
        if (from.isDirectory()) {
            FileUtils.copyDirFiles((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        if (root == null || this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            return;
        }
        GitClient client = null;
        try {
            if (root.equals(dstRoot)) {
                client = git.getClient(root);
                client.copyAfter(from, to, GitUtils.NULL_PROGRESS_MONITOR);
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_CopyFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public void afterCopy(File from, File to) {
        LOG.log(Level.FINE, "afterCopy {0}->{1}", new Object[]{from, to});
        if (to == null) {
            return;
        }
        this.addToCreated(to);
        if (!this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(to), true);
        }
    }

    public void afterChange(File file) {
        if (file.isDirectory()) {
            return;
        }
        LOG.log(Level.FINE, "afterChange {0}", new Object[]{file});
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file), true);
        }
    }

    public boolean isMutable(File file) {
        return GitUtils.isPartOfGitMetadata(file) || super.isMutable(file);
    }

    public Object getAttribute(File file, String attrName) {
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new GitSearchHistorySupport(file);
        }
        if ("ProvidedExtensions.RemoteLocation".equals(attrName)) {
            File repoRoot = Git.getInstance().getRepositoryRoot(file);
            RepositoryInfo info = RepositoryInfo.getInstance(repoRoot);
            Map<String, GitRemoteConfig> remotes = info.getRemotes();
            StringBuilder sb = new StringBuilder();
            for (GitRemoteConfig rc : remotes.values()) {
                List uris = rc.getUris();
                for (int i = 0; i < uris.size(); ++i) {
                    sb.append((String)uris.get(i)).append(';');
                }
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        return super.getAttribute(file, attrName);
    }

    void pingRepositoryRootFor(File file) {
        if (!AUTOMATIC_REFRESH_ENABLED) {
            return;
        }
        this.gitFolderEventsHandler.initializeFor(file);
    }

    Set<File> getSeenRoots(File repositoryRoot) {
        return this.gitFolderEventsHandler.getSeenRoots(repositoryRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runWithoutExternalEvents(File repository, String commandName, Callable<T> callable) throws Exception {
        T t;
        block9: {
            assert (repository != null);
            try {
                if (repository != null) {
                    this.gitFolderEventsHandler.enableEvents(repository, false);
                    this.commandLogger.lockedInternally(repository, commandName);
                }
                t = callable.call();
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                if (repository != null) {
                    LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{commandName, repository.getAbsolutePath()});
                    if (EventQueue.isDispatchThread()) {
                        Git.getInstance().getRequestProcessor().post(new Runnable(repository){
                            final /* synthetic */ File val$repository;
                            {
                                this.val$repository = file;
                            }

                            @Override
                            public void run() {
                                FilesystemInterceptor.this.gitFolderEventsHandler.refreshIndexFileTimestamp(this.val$repository);
                            }
                        });
                    } else {
                        this.gitFolderEventsHandler.refreshIndexFileTimestamp(repository);
                    }
                    this.commandLogger.unlockedInternally(repository);
                    this.gitFolderEventsHandler.enableEvents(repository, true);
                }
                throw throwable;
            }
            LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{commandName, repository.getAbsolutePath()});
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(new /* invalid duplicate definition of identical inner class */);
            } else {
                this.gitFolderEventsHandler.refreshIndexFileTimestamp(repository);
            }
            this.commandLogger.unlockedInternally(repository);
            this.gitFolderEventsHandler.enableEvents(repository, true);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCreated(File createdFile) {
        if (!GitModuleConfig.getDefault().getAutoIgnoreFiles() || !createdFile.isDirectory()) {
            return;
        }
        Map<File, Long> map = this.createdFolders;
        synchronized (map) {
            for (File f : this.createdFolders.keySet()) {
                if (!Utils.isAncestorOrEqual((File)f, (File)createdFile)) continue;
                return;
            }
            this.createdFolders.put(createdFile, createdFile.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<File> getCreatedFolders() {
        Map<File, Long> map = this.createdFolders;
        synchronized (map) {
            return new HashSet<File>(this.createdFolders.keySet());
        }
    }

    private Collection<File> checkLockedRepositories(Collection<File> additionalFilesToRefresh, boolean keepCached) {
        LinkedList<File> retval = new LinkedList<File>();
        Map<File, Set<File>> sortedFiles = GitUtils.sortByRepository(additionalFilesToRefresh);
        for (Map.Entry<File, Set<File>> e : sortedFiles.entrySet()) {
            Set<File> alreadyPlanned = this.lockedRepositories.get(e.getKey());
            if (alreadyPlanned == null) {
                alreadyPlanned = new HashSet<File>();
                this.lockedRepositories.put(e.getKey(), alreadyPlanned);
            }
            alreadyPlanned.addAll((Collection<File>)e.getValue());
        }
        Iterator<Map.Entry<File, Set<File>>> it = this.lockedRepositories.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<File, Set<File>> entry = it.next();
            File repository = entry.getKey();
            if (!repository.exists()) {
                it.remove();
                continue;
            }
            if (GitUtils.isRepositoryLocked(repository)) {
                Git.STATUS_LOG.log(Level.FINE, "checkLockedRepositories(): Repository {0} locked, status refresh delayed", repository);
                continue;
            }
            retval.addAll((Collection<File>)entry.getValue());
            if (keepCached) continue;
            it.remove();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reScheduleRefresh(int delayMillis, Set<File> filesToRefresh, boolean log) {
        boolean changed;
        HashSet<File> filteredFiles = new HashSet<File>(filesToRefresh);
        Iterator it = filteredFiles.iterator();
        while (it.hasNext()) {
            if (!GitUtils.isPartOfGitMetadata((File)it.next())) continue;
            it.remove();
        }
        Set<File> set = this.filesToRefresh;
        synchronized (set) {
            changed = this.filesToRefresh.addAll(filteredFiles);
        }
        if (changed) {
            Git.STATUS_LOG.log(Level.FINE, "reScheduleRefresh: adding {0}", filteredFiles);
            if (log) {
                for (File file : filteredFiles) {
                    this.commandLogger.logModification(file);
                }
            }
            this.refreshTask.schedule(delayMillis);
        }
    }

    private class CommandUsageLogger {
        private final Map<File, Events> events = new HashMap<File, Events>();

        private CommandUsageLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void locked(File file) {
            File gitFolder = this.getGitFolderFor(file);
            if (gitFolder != null && file.exists()) {
                long time = System.currentTimeMillis();
                Map<File, Events> map = this.events;
                synchronized (map) {
                    Events ev = this.events.get(gitFolder);
                    if (ev == null || ev.isExternal() || ev.timeFinished > 0L && ev.timeFinished < time - 10000L) {
                        ev = new Events();
                        ev.timeStarted = time;
                        this.events.put(gitFolder, ev);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lockedInternally(File repository, String commandName) {
            File gitFolder = GitUtils.getGitFolderForRoot(repository);
            Events ev = new Events();
            ev.timeStarted = System.currentTimeMillis();
            ev.commandName = commandName;
            Map<File, Events> map = this.events;
            synchronized (map) {
                this.events.put(gitFolder, ev);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlocked(File file) {
            File gitFolder = this.getGitFolderFor(file);
            if (gitFolder != null) {
                Events ev;
                Map<File, Events> map = this.events;
                synchronized (map) {
                    ev = this.events.remove(gitFolder);
                    if (ev != null && !ev.isExternal()) {
                        this.events.put(gitFolder, ev);
                        return;
                    }
                }
                if (ev != null) {
                    long time = System.currentTimeMillis() - ev.timeStarted;
                    Utils.logVCSCommandUsageEvent((String)"GIT", (long)time, (long)ev.modifications, (String)ev.commandName, (boolean)ev.isExternal());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlockedInternally(File repository) {
            Events ev;
            File gitFolder = GitUtils.getGitFolderForRoot(repository);
            Map<File, Events> map = this.events;
            synchronized (map) {
                ev = this.events.get(gitFolder);
                if (ev == null) {
                    return;
                }
                if (ev.isExternal()) {
                    this.events.remove(gitFolder);
                }
            }
            ev.timeFinished = System.currentTimeMillis();
            long time = ev.timeFinished - ev.timeStarted;
            Utils.logVCSCommandUsageEvent((String)"GIT", (long)time, (long)ev.modifications, (String)ev.commandName, (boolean)ev.isExternal());
        }

        private File getGitFolderFor(File wlockFile) {
            File repository = Git.getInstance().getRepositoryRoot(wlockFile);
            File gitFolder = GitUtils.getGitFolderForRoot(repository);
            return gitFolder.equals(wlockFile.getParentFile()) ? gitFolder : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logModification(File file) {
            if (GitUtils.isPartOfGitMetadata(file)) {
                return;
            }
            File repository = Git.getInstance().getRepositoryRoot(file);
            File gitFolder = GitUtils.getGitFolderForRoot(repository);
            if (gitFolder != null) {
                Map<File, Events> map = this.events;
                synchronized (map) {
                    Events ev = this.events.get(gitFolder);
                    if (ev != null) {
                        ++ev.modifications;
                    }
                }
            }
        }
    }

    private static class Events {
        long timeStarted;
        long timeFinished;
        long modifications;
        String commandName;

        private Events() {
        }

        private boolean isExternal() {
            return this.commandName == null;
        }
    }

    private class GitFolderEventsHandler {
        private final HashMap<File, Set<File>> seenRoots = new HashMap();
        private final HashMap<File, GitFolderTimestamps> timestamps = new HashMap(5);
        private final HashMap<File, MetadataMapping> gitToMetadataFolder = new HashMap(5);
        private final HashMap<File, File> metadataToGitFolder = new HashMap(5);
        private final HashMap<File, FileChangeListener> gitFolderRLs = new HashMap(5);
        private final HashSet<File> disabledEvents = new HashSet(5);
        private final HashSet<File> filesToInitialize = new HashSet();
        private final RequestProcessor.Task initializingTask = FilesystemInterceptor.access$2600().create(new Runnable(){

            @Override
            public void run() {
                GitFolderEventsHandler.this.initializeFiles();
            }
        });
        private final HashSet<File> refreshedRepositories = new HashSet(5);
        private final RequestProcessor.Task refreshOpenFilesTask = FilesystemInterceptor.access$2600().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet repositories;
                HashSet hashSet = GitFolderEventsHandler.this.refreshedRepositories;
                synchronized (hashSet) {
                    repositories = new HashSet(GitFolderEventsHandler.this.refreshedRepositories);
                    GitFolderEventsHandler.this.refreshedRepositories.clear();
                }
                GitUtils.headChanged(repositories.toArray(new File[repositories.size()]));
            }
        });
        private final GitRepositories gitRepositories = GitRepositories.getInstance();

        private GitFolderEventsHandler() {
        }

        public void initializeFor(File file) {
            if (this.addFileToInitialize(file)) {
                this.initializingTask.schedule(500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<File> getSeenRoots(File repositoryRoot) {
            Set<File> seenRootsForRepository;
            HashSet<File> retval = new HashSet<File>();
            Set<File> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                retval.addAll(seenRootsForRepository);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addSeenRoot(File repositoryRoot, File rootToAdd) {
            Set<File> seenRootsForRepository;
            boolean added = false;
            Set<File> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                if (!seenRootsForRepository.contains(repositoryRoot)) {
                    added = !GitUtils.prepareRootFiles(repositoryRoot, seenRootsForRepository, rootToAdd = FileUtil.normalizeFile((File)rootToAdd));
                }
            }
            return added;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<File> getSeenRootsForRepository(File repositoryRoot) {
            HashMap<File, Set<File>> hashMap = this.seenRoots;
            synchronized (hashMap) {
                Set<File> seenRootsForRepository = this.seenRoots.get(repositoryRoot);
                if (seenRootsForRepository == null) {
                    seenRootsForRepository = new HashSet<File>();
                    this.seenRoots.put(repositoryRoot, seenRootsForRepository);
                }
                return seenRootsForRepository;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addFileToInitialize(File file) {
            HashSet<File> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                return this.filesToInitialize.add(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File getFileToInitialize() {
            File nextFile = null;
            HashSet<File> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                Iterator<File> iterator = this.filesToInitialize.iterator();
                if (iterator.hasNext()) {
                    nextFile = iterator.next();
                    iterator.remove();
                }
            }
            return nextFile;
        }

        private GitFolderTimestamps scanGitFolderTimestamps(File gitFolder) {
            File metadataFolder = this.translateToMetadataFolder(gitFolder);
            File indexFile = new File(metadataFolder, FilesystemInterceptor.INDEX_FILE_NAME);
            File headFile = new File(metadataFolder, FilesystemInterceptor.HEAD_FILE_NAME);
            GitBranch activeBranch = null;
            RepositoryInfo info = RepositoryInfo.getInstance(gitFolder.getParentFile());
            if (info != null) {
                info.refresh();
                activeBranch = info.getActiveBranch();
            }
            File refFile = headFile;
            if (activeBranch != null && !"(no branch)".equals(activeBranch.getName())) {
                refFile = new File(metadataFolder, ("refs/heads/" + activeBranch.getName()).replace("/", File.separator));
            }
            return new GitFolderTimestamps(indexFile, headFile, refFile, gitFolder, metadataFolder);
        }

        public void refreshIndexFileTimestamp(File repository) {
            this.refreshIndexFileTimestamp(this.scanGitFolderTimestamps(GitUtils.getGitFolderForRoot(repository)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshIndexFileTimestamp(GitFolderTimestamps newTimestamps) {
            if (Utils.isAncestorOrEqual((File)new File(System.getProperty("java.io.tmpdir")), (File)newTimestamps.getIndexFile())) {
                return;
            }
            File gitFolder = newTimestamps.getGitFolder();
            final File metadataFolder = newTimestamps.getMetadataFolder();
            boolean exists = newTimestamps.repositoryExists();
            HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                if (exists && !newTimestamps.isNewer(this.timestamps.get(gitFolder))) {
                    return;
                }
            }
            boolean add = false;
            boolean remove = false;
            HashMap<File, GitFolderTimestamps> hashMap2 = this.timestamps;
            synchronized (hashMap2) {
                FileChangeListener fList;
                this.timestamps.remove(gitFolder);
                FileChangeListener list = this.gitFolderRLs.remove(gitFolder);
                if (exists) {
                    this.timestamps.put(gitFolder, newTimestamps);
                    if (list == null) {
                        fList = list = new FileChangeAdapter();
                        rp.post(new Runnable(){

                            @Override
                            public void run() {
                                FileUtil.addRecursiveListener((FileChangeListener)fList, (File)metadataFolder);
                            }
                        });
                    }
                    this.gitFolderRLs.put(gitFolder, list);
                    add = true;
                } else {
                    if (list != null) {
                        fList = list;
                        rp.post(new Runnable(){

                            @Override
                            public void run() {
                                FileUtil.removeRecursiveListener((FileChangeListener)fList, (File)metadataFolder);
                                Git.getInstance().versionedFilesChanged();
                            }
                        });
                    }
                    Git.STATUS_LOG.log(Level.FINE, "refreshAdminFolderTimestamp: {0} no longer exists", gitFolder.getAbsolutePath());
                    remove = true;
                }
                if (remove) {
                    this.gitRepositories.remove(gitFolder.getParentFile());
                    this.gitToMetadataFolder.remove(gitFolder);
                    this.metadataToGitFolder.remove(metadataFolder);
                } else if (add) {
                    File repository = gitFolder.getParentFile();
                    if (!repository.equals(Git.getInstance().getRepositoryRoot(repository))) {
                        Git.getInstance().versionedFilesChanged();
                    }
                    this.gitRepositories.add(repository);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeFiles() {
            File file;
            while ((file = this.getFileToInitialize()) != null) {
                Git.STATUS_LOG.log(Level.FINEST, "GitFolderEventsHandler.initializeFiles: {0}", file.getAbsolutePath());
                File repositoryRoot = Git.getInstance().getRepositoryRoot(file);
                if (repositoryRoot == null || !this.addSeenRoot(repositoryRoot, file)) continue;
                Git.STATUS_LOG.log(Level.FINE, "initializeFiles: planning a scan for {0} - {1}", new Object[]{repositoryRoot.getAbsolutePath(), file.getAbsolutePath()});
                FilesystemInterceptor.this.reScheduleRefresh(4000, Collections.singleton(file), false);
                File gitFolder = GitUtils.getGitFolderForRoot(repositoryRoot);
                boolean refreshNeeded = false;
                HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
                synchronized (hashMap) {
                    File metadataFolder;
                    if (!this.timestamps.containsKey(gitFolder) && new File(metadataFolder = this.translateToMetadataFolder(gitFolder), FilesystemInterceptor.INDEX_FILE_NAME).canRead()) {
                        this.timestamps.put(gitFolder, null);
                        refreshNeeded = true;
                    }
                }
                if (!refreshNeeded) continue;
                this.refreshIndexFileTimestamp(this.scanGitFolderTimestamps(gitFolder));
            }
            Git.STATUS_LOG.log(Level.FINEST, "GitFolderEventsHandler.initializeFiles: finished");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long refreshAdminFolder(File metadataFolder) {
            long lastModified = 0L;
            if (AUTOMATIC_REFRESH_ENABLED && !"false".equals(System.getProperty("versioning.git.handleExternalEvents", "true"))) {
                metadataFolder = FileUtil.normalizeFile((File)metadataFolder);
                Git.STATUS_LOG.log(Level.FINER, "refreshAdminFolder: special FS event handling for {0}", metadataFolder.getAbsolutePath());
                boolean refreshNeeded = false;
                File gitFolder = this.translateToGitFolder(metadataFolder);
                if (this.isEnabled(gitFolder)) {
                    GitFolderTimestamps cached;
                    HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
                    synchronized (hashMap) {
                        cached = this.timestamps.get(gitFolder);
                    }
                    if (cached == null || !cached.repositoryExists() || cached.isOutdated()) {
                        this.refreshIndexFileTimestamp(this.scanGitFolderTimestamps(gitFolder));
                        refreshNeeded = true;
                    }
                    if (refreshNeeded) {
                        File repository = gitFolder.getParentFile();
                        RepositoryInfo.refreshAsync(repository);
                        Git.STATUS_LOG.log(Level.FINE, "refreshAdminFolder: planning repository scan for {0}", repository.getAbsolutePath());
                        FilesystemInterceptor.this.reScheduleRefresh(3000, this.getSeenRoots(repository), false);
                        this.refreshOpenFiles(repository);
                    }
                }
            }
            return lastModified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshReferences(File metadataFolder, File triggerFolder) {
            if (AUTOMATIC_REFRESH_ENABLED && !"false".equals(System.getProperty("versioning.git.handleExternalEvents", "true"))) {
                metadataFolder = FileUtil.normalizeFile((File)metadataFolder);
                Git.STATUS_LOG.log(Level.FINER, "refreshReferences: special FS event handling for {0}", triggerFolder.getAbsolutePath());
                boolean refreshNeeded = false;
                File gitFolder = this.translateToGitFolder(metadataFolder);
                if (this.isEnabled(gitFolder)) {
                    GitFolderTimestamps cached;
                    HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
                    synchronized (hashMap) {
                        cached = this.timestamps.get(gitFolder);
                    }
                    if (cached != null && cached.updateReferences(triggerFolder)) {
                        refreshNeeded = true;
                    }
                    if (refreshNeeded) {
                        File repository = gitFolder.getParentFile();
                        RepositoryInfo.refreshAsync(repository);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshOpenFiles(File repository) {
            boolean refreshPlanned;
            HashSet<File> hashSet = this.refreshedRepositories;
            synchronized (hashSet) {
                refreshPlanned = !this.refreshedRepositories.add(repository);
            }
            if (!refreshPlanned) {
                this.refreshOpenFilesTask.schedule(3000);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enableEvents(File repository, boolean enabled) {
            File gitFolder = FileUtil.normalizeFile((File)GitUtils.getGitFolderForRoot(repository));
            HashSet<File> hashSet = this.disabledEvents;
            synchronized (hashSet) {
                if (enabled) {
                    this.disabledEvents.remove(gitFolder);
                } else {
                    this.disabledEvents.add(gitFolder);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isEnabled(File gitFolder) {
            HashSet<File> hashSet = this.disabledEvents;
            synchronized (hashSet) {
                return !this.disabledEvents.contains(gitFolder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File translateToMetadataFolder(File gitFolder) {
            long ts;
            File metadataFolder;
            MetadataMapping mapping;
            HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                mapping = this.gitToMetadataFolder.get(gitFolder);
            }
            if (mapping == null) {
                metadataFolder = gitFolder;
                ts = System.currentTimeMillis();
            } else {
                metadataFolder = mapping.metadataFolder;
                ts = mapping.ts;
            }
            if (gitFolder.isFile()) {
                ts = gitFolder.lastModified();
                if (mapping == null || mapping.ts < ts) {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new FileReader(gitFolder));
                        String line = br.readLine();
                        while (line != null) {
                            if ((line = line.trim()).startsWith("gitdir:")) {
                                File tmp = new File(line = line.substring(7).trim());
                                if (!tmp.isAbsolute()) {
                                    tmp = new File(gitFolder, line).getCanonicalFile();
                                }
                                metadataFolder = tmp;
                                break;
                            }
                            line = br.readLine();
                        }
                    }
                    catch (IOException ex) {
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }
            HashMap<File, GitFolderTimestamps> hashMap2 = this.timestamps;
            synchronized (hashMap2) {
                this.gitToMetadataFolder.put(gitFolder, new MetadataMapping(metadataFolder, ts));
                this.metadataToGitFolder.put(metadataFolder, gitFolder);
            }
            return metadataFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File translateToGitFolder(File metadataFolder) {
            File gitFolder;
            HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                gitFolder = this.metadataToGitFolder.get(metadataFolder);
            }
            if (gitFolder == null) {
                gitFolder = metadataFolder;
            }
            return gitFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isMetadataFolder(File dir) {
            HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                return this.metadataToGitFolder.containsKey(dir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File getMetadataForReferences(File file) {
            ArrayList<File> metadataFolders;
            HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                metadataFolders = new ArrayList<File>(this.metadataToGitFolder.keySet());
            }
            File candidate = null;
            for (File metadataFolder : metadataFolders) {
                String refsPath = new File(metadataFolder.getAbsolutePath(), FilesystemInterceptor.REFS_FILE_NAME).getAbsolutePath();
                if (!file.getAbsolutePath().startsWith(refsPath) || candidate != null && candidate.getAbsolutePath().length() >= metadataFolder.getAbsolutePath().length()) continue;
                candidate = metadataFolder;
            }
            return candidate;
        }
    }

    private static class GitFolderTimestamps {
        private final File indexFile;
        private final long indexFileTS;
        private final File headFile;
        private final long headFileTS;
        private final File refFile;
        private final long refFileTS;
        private final File gitFolder;
        private final File metadataFolder;
        private long referencesFolderTS;

        public GitFolderTimestamps(File indexFile, File headFile, File refFile, File gitFolder, File metadataFolder) {
            this.indexFile = indexFile;
            this.indexFileTS = indexFile.lastModified();
            this.headFile = headFile;
            this.headFileTS = headFile.lastModified();
            this.refFile = refFile;
            this.refFileTS = refFile.lastModified();
            this.gitFolder = gitFolder;
            this.metadataFolder = metadataFolder;
            this.referencesFolderTS = System.currentTimeMillis();
        }

        private File getIndexFile() {
            return this.indexFile;
        }

        private boolean isNewer(GitFolderTimestamps other) {
            boolean newer = true;
            if (other != null) {
                newer = this.indexFileTS > other.indexFileTS || this.headFileTS > other.headFileTS || this.refFileTS > other.refFileTS;
            }
            return newer;
        }

        private File getGitFolder() {
            return this.gitFolder;
        }

        private File getMetadataFolder() {
            return this.metadataFolder;
        }

        private boolean repositoryExists() {
            return this.indexFileTS > 0L || this.gitFolder.exists();
        }

        private boolean isOutdated() {
            boolean upToDate;
            boolean bl = upToDate = this.indexFileTS >= this.indexFile.lastModified();
            if (upToDate) {
                boolean bl2 = upToDate = this.headFileTS >= this.headFile.lastModified();
            }
            if (upToDate) {
                upToDate = this.refFileTS >= this.refFile.lastModified();
            }
            return !upToDate;
        }

        private boolean updateReferences(File triggerFolder) {
            boolean updated = false;
            long ts = triggerFolder.lastModified();
            if (ts > this.referencesFolderTS) {
                updated = true;
                this.referencesFolderTS = System.currentTimeMillis();
            }
            return updated;
        }
    }

    public class GitSearchHistorySupport
    extends SearchHistorySupport {
        public GitSearchHistorySupport(File file) {
            super(file);
        }

        protected boolean searchHistoryImpl(int line) throws IOException {
            File file = this.getFile();
            SearchHistoryAction.openSearch(Git.getInstance().getRepositoryRoot(file), file, file.getName(), line);
            return true;
        }
    }

    private class LockedRepositoryRefreshTask
    implements Runnable {
        private LockedRepositoryRefreshTask() {
        }

        @Override
        public void run() {
            if (!FilesystemInterceptor.this.checkLockedRepositories(Collections.emptySet(), true).isEmpty()) {
                FilesystemInterceptor.this.refreshTask.schedule(0);
            } else if (!FilesystemInterceptor.this.lockedRepositories.isEmpty()) {
                FilesystemInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }

    private static class MetadataMapping {
        private final File metadataFolder;
        private final long ts;

        public MetadataMapping(File metadataFolder, long ts) {
            this.metadataFolder = metadataFolder;
            this.ts = ts;
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<File> files;
            Thread.interrupted();
            if (DelayScanRegistry.getInstance().isDelayed(FilesystemInterceptor.this.refreshTask, Git.STATUS_LOG, "GitInterceptor.refreshTask")) {
                return;
            }
            Set set = FilesystemInterceptor.this.filesToRefresh;
            synchronized (set) {
                files = new HashSet(FilesystemInterceptor.this.filesToRefresh);
                FilesystemInterceptor.this.filesToRefresh.clear();
            }
            if (FilesystemInterceptor.this.shutdownMonitor.isCanceled()) {
                return;
            }
            if (!"false".equals(System.getProperty("versioning.git.delayStatusForLockedRepositories"))) {
                files = FilesystemInterceptor.this.checkLockedRepositories(files, false);
            }
            if (!files.isEmpty()) {
                FilesystemInterceptor.this.cache.refreshAllRoots(files, (ProgressMonitor)FilesystemInterceptor.this.shutdownMonitor);
            }
            if (!FilesystemInterceptor.this.lockedRepositories.isEmpty()) {
                FilesystemInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }

    public static class ShutdownCallable
    implements Callable<Boolean> {
        @Override
        public Boolean call() throws Exception {
            LOG.log(Level.FINE, "Canceling the auto refresh progress monitor");
            Git.getInstance().getVCSInterceptor().shutdownMonitor.cancel();
            try {
                Git.getInstance().getVCSInterceptor().refreshTask.waitFinished(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
    }
}

