/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.support.ui.CertPassphraseDlg;
import org.netbeans.modules.nativeexecution.support.ui.PasswordDlg;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class RemoteUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private static final Object lock = RemoteUserInfo.class.getName() + "Lock";
    private static final PasswordManager pm = PasswordManager.getInstance();
    private final Component parent;
    private final ExecutionEnvironment env;
    private volatile Component parentWindow = null;
    private final boolean allowInterraction;
    private char[] secret = null;

    public RemoteUserInfo(ExecutionEnvironment env, boolean allowToAskForPassword) {
        this.env = env;
        this.allowInterraction = allowToAskForPassword;
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RemoteUserInfo.this.parentWindow = WindowManager.getDefault().getMainWindow();
            }
        });
        this.parent = this.parentWindow;
    }

    public String getPassphrase() {
        return this.getSecret();
    }

    public String getPassword() {
        return this.getSecret();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSecret() {
        String result = null;
        Object object = lock;
        synchronized (object) {
            char[] saved = pm.getPassword(this.env);
            if (saved != null) {
                result = new String(saved);
            } else if (this.secret != null) {
                result = new String(this.secret);
                Arrays.fill(this.secret, 'x');
                this.secret = null;
            }
        }
        return result;
    }

    public boolean promptPassword(String message) {
        return this.promptSecret(SecretType.PASSWORD, message);
    }

    public boolean promptPassphrase(String message) {
        return this.promptSecret(SecretType.PASSPHRASE, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean promptSecret(SecretType secretType, String message) {
        Object object = lock;
        synchronized (object) {
            JPanel dlg;
            if (pm.getPassword(this.env) != null) {
                return true;
            }
            if (!this.allowInterraction) {
                return false;
            }
            switch (secretType) {
                case PASSWORD: {
                    dlg = new PasswordDlg();
                    break;
                }
                case PASSPHRASE: {
                    dlg = new CertPassphraseDlg();
                    break;
                }
                default: {
                    throw new InternalError("Wrong secret type");
                }
            }
            if (!dlg.askPassword(this.env, message)) {
                throw new CancellationException(RemoteUserInfo.loc("USER_AUTH_CANCELED", new String[0]));
            }
            this.secret = dlg.getPassword();
            pm.storePassword(this.env, this.secret, dlg.isRememberPassword());
            dlg.clearPassword();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean promptYesNo(String str) {
        int foo;
        Object[] options = new Object[]{"yes", "no"};
        Object object = lock;
        synchronized (object) {
            if (RemoteUserInfo.isUnitTestMode() || RemoteUserInfo.isStandalone()) {
                System.err.println(str + " yes");
                foo = 0;
            } else {
                foo = JOptionPane.showOptionDialog(this.parent, str, RemoteUserInfo.loc("TITLE_YN_Warning", new String[0]), -1, 2, null, options, options[0]);
            }
        }
        return foo == 0;
    }

    private static boolean isStandalone() {
        if ("true".equals(System.getProperty("cnd.command.line.utility"))) {
            return true;
        }
        return !RemoteUserInfo.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    private static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMessage(String message) {
        Object object = lock;
        synchronized (object) {
            JOptionPane.showMessageDialog(this.parent, message);
        }
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (prompt.length == 1 && !echo[0]) {
            if (!this.promptPassword(RemoteUserInfo.loc("MSG_PasswordInteractive", destination, prompt[0]))) {
                return null;
            }
            return new String[]{this.getPassword()};
        }
        return null;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(RemoteUserInfo.class, (String)key, (Object[])params);
    }

    private static enum SecretType {
        PASSWORD,
        PASSPHRASE;

    }
}

