/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.pty;

import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.JschSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.PtyOpenUtility;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class PtyAllocator {
    private static final PtyAllocator instance = new PtyAllocator();

    private PtyAllocator() {
    }

    public static PtyAllocator getInstance() {
        return instance;
    }

    public Pty allocate(ExecutionEnvironment env) throws IOException {
        PtyImplementation result = null;
        String ptyOpenUtilityPath = PtyOpenUtility.getInstance().getPath(env);
        if (ptyOpenUtilityPath == null) {
            throw new IOException("pty_open cannot be located");
        }
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo(env);
        }
        catch (ConnectionManager.CancellationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (hostInfo == null) {
            throw new IOException("no hostinfo available for " + env.getDisplayName());
        }
        JschSupport.ChannelStreams streams = null;
        try {
            if (env.isLocal()) {
                ProcessBuilder pb = new ProcessBuilder(hostInfo.getShell(), "-s");
                if (Utilities.isWindows()) {
                    if (hostInfo.getShell() == null || WindowsSupport.getInstance().getActiveShell().type != Shell.ShellType.CYGWIN) {
                        throw new IOException("terminal support requires Cygwin to be installed");
                    }
                    ptyOpenUtilityPath = WindowsSupport.getInstance().convertToCygwinPath(ptyOpenUtilityPath);
                    String path = MacroMap.forExecEnv(env).get("PATH");
                    pb.environment().put("Path", path);
                }
                Process pty = pb.start();
                streams = new JschSupport.ChannelStreams(null, pty.getInputStream(), pty.getErrorStream(), pty.getOutputStream());
            } else {
                streams = JschSupport.startCommand(env, "/bin/sh -s", null);
            }
            streams.in.write(("exec \"" + ptyOpenUtilityPath + "\"\n").getBytes());
            streams.in.flush();
            PtyOpenUtility.PtyInfo ptyInfo = PtyOpenUtility.getInstance().readSatelliteOutput(streams.out);
            if (ptyInfo == null) {
                String errorLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(streams.err));
                StringBuilder err_msg = new StringBuilder();
                while ((errorLine = br.readLine()) != null) {
                    err_msg.append(errorLine).append('\n');
                }
                throw new IOException(err_msg.toString());
            }
            result = new PtyImplementation(env, ptyInfo.tty, ptyInfo.pid, streams);
        }
        catch (Exception ex) {
            throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
        }
        finally {
            if (result == null && streams != null) {
                if (streams.in != null) {
                    streams.in.close();
                }
                if (streams.out != null) {
                    streams.out.close();
                }
                if (streams.err != null) {
                    streams.err.close();
                }
                if (streams.channel != null) {
                    try {
                        ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(env, streams.channel);
                    }
                    catch (JSchException ex) {}
                }
            }
        }
        return result;
    }

    private static final class PtyImplementation
    implements Pty {
        private final String tty;
        private final int pid;
        private final ExecutionEnvironment env;
        private final ByteArrayInputStream bis = new ByteArrayInputStream(new byte[0]);
        private final JschSupport.ChannelStreams streams;

        public PtyImplementation(ExecutionEnvironment env, String tty, int pid, JschSupport.ChannelStreams streams) throws IOException {
            this.tty = tty;
            this.pid = pid;
            this.streams = streams;
            this.env = env;
        }

        @Override
        public ExecutionEnvironment getEnv() {
            return this.env;
        }

        @Override
        public final void close() throws IOException {
            this.streams.in.close();
            this.streams.out.close();
            if (this.streams.channel != null) {
                try {
                    ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(this.env, this.streams.channel);
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
        }

        @Override
        public String toString() {
            return this.tty + " (" + this.pid + ")";
        }

        @Override
        public InputStream getInputStream() {
            return this.streams.out;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.streams.in;
        }

        @Override
        public InputStream getErrorStream() {
            return this.bis;
        }

        @Override
        public String getSlaveName() {
            return this.tty;
        }
    }
}

