/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.pty;

import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HelperUtility;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.openide.modules.InstalledFileLocator;

public class NbStartUtility
extends HelperUtility {
    private static final boolean ENABLED = Boolean.parseBoolean(System.getProperty("enable.nbstart", "true"));
    private static final NbStartUtility instance = new NbStartUtility();

    public NbStartUtility() {
        super("bin/nativeexecution/${osname}-${platform}${_isa}/pty");
    }

    public static NbStartUtility getInstance() {
        return instance;
    }

    @Override
    protected File getLocalFile(HostInfo hostInfo) throws MissingResourceException {
        String osname = hostInfo.getOS().getFamily().cname();
        String platform = hostInfo.getCpuFamily().name().toLowerCase();
        String bitness = hostInfo.getOS().getBitness() == HostInfo.Bitness._64 ? "_64" : "";
        InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
        StringBuilder path = new StringBuilder("bin/nativeexecution/");
        path.append(osname).append('-').append(platform).append(bitness).append("/pty");
        File file = fl.locate(path.toString(), this.codeNameBase, false);
        if (file == null || !file.exists()) {
            throw new MissingResourceException(path.toString(), null, null);
        }
        return file;
    }

    public boolean isSupported(ExecutionEnvironment executionEnvironment) {
        try {
            return this.isSupported(HostInfoUtils.getHostInfo(executionEnvironment));
        }
        catch (IOException ex) {
            return false;
        }
        catch (ConnectionManager.CancellationException ex) {
            return false;
        }
    }

    public boolean isSupported(HostInfo hostInfo) {
        if (!ENABLED) {
            return false;
        }
        try {
            switch (hostInfo.getOS().getFamily()) {
                case MACOSX: 
                case SUNOS: 
                case LINUX: {
                    try {
                        return this.getLocalFile(hostInfo) != null;
                    }
                    catch (MissingResourceException ex) {
                        return false;
                    }
                }
                case WINDOWS: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

