/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public final class WindowsRegistryIterator
implements Iterator<String[]> {
    private final RootKey[] rootKeys;
    private final String subKey;
    private final String valueName;
    private final boolean recursively;
    private int idx;

    private WindowsRegistryIterator(String subKey, RootKey[] rootKeys, String valueName, boolean recursively) {
        if (subKey.toLowerCase().startsWith("hklm\\") || subKey.toLowerCase().startsWith("hkcu\\")) {
            subKey = subKey.substring(5);
        }
        this.subKey = subKey;
        this.rootKeys = rootKeys;
        this.valueName = valueName;
        this.recursively = recursively;
        this.idx = 0;
    }

    public static WindowsRegistryIterator get(String subKey, String valueName) {
        return WindowsRegistryIterator.get(subKey, new RootKey[]{RootKey.HKLM, RootKey.HKCU, RootKey.NHKLM, RootKey.NHKCU}, valueName, false);
    }

    public static WindowsRegistryIterator get(String subKey, String valueName, boolean recursively) {
        return WindowsRegistryIterator.get(subKey, new RootKey[]{RootKey.HKLM, RootKey.HKCU, RootKey.NHKLM, RootKey.NHKCU}, valueName, recursively);
    }

    public static WindowsRegistryIterator get(String subKey, RootKey[] rootKeys, String valueName, boolean recursively) {
        return new WindowsRegistryIterator(subKey, rootKeys, valueName, recursively);
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.rootKeys.length;
    }

    @Override
    public String[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        while (this.idx < this.rootKeys.length) {
            ProcessBuilder pb;
            ProcessUtils.ExitStatus result;
            String reg_exe;
            String fullKey;
            RootKey key = this.rootKeys[this.idx++];
            switch (key) {
                case HKLM: {
                    fullKey = "HKLM\\" + this.subKey;
                    reg_exe = "%SystemRoot%\\system32\\reg.exe";
                    break;
                }
                case NHKLM: {
                    fullKey = "HKLM\\" + this.subKey;
                    reg_exe = "%SystemRoot%\\sysnative\\reg.exe";
                    break;
                }
                case HKCU: {
                    fullKey = "HKCU\\" + this.subKey;
                    reg_exe = "%SystemRoot%\\system32\\reg.exe";
                    break;
                }
                case NHKCU: {
                    fullKey = "HKCU\\" + this.subKey;
                    reg_exe = "%SystemRoot%\\sysnative\\reg.exe";
                    break;
                }
                default: {
                    throw new InternalError("Unhandled/Unknown/Unimplemented RootKey");
                }
            }
            StringBuilder suffix = new StringBuilder();
            if (this.recursively) {
                suffix.append(" /s ");
            }
            if (this.valueName != null) {
                suffix.append(" /v ").append(this.valueName);
            }
            if (!(result = ProcessUtils.execute(pb = new ProcessBuilder("cmd", "/C", reg_exe + " query " + fullKey + suffix.toString()))).isOK()) continue;
            return result.output.split("\n");
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove operation is not supported by this iterator");
    }

    public static enum RootKey {
        HKLM,
        NHKLM,
        HKCU,
        NHKCU;

    }
}

