/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.HelperUtility;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.ShellSession;
import org.openide.util.Exceptions;

public final class Stat {
    private static final java.util.logging.Logger LOG = Logger.getInstance();
    private final long inode;
    private final long ctime;
    private static final HelperUtility statHelperUtility = new HelperUtility("bin/nativeexecution/$osname-${platform}$_isa/stat");

    public static Stat get(String filename, ExecutionEnvironment exEnv) {
        try {
            String[] data;
            StringBuilder sb = new StringBuilder();
            sb.append('\"').append(statHelperUtility.getPath(exEnv)).append('\"');
            sb.append(' ').append('\"').append(filename).append('\"');
            ProcessUtils.ExitStatus res = ShellSession.execute(exEnv, sb.toString());
            if (res.isOK() && (data = res.output.split("\n")).length > 1) {
                return new Stat(Long.valueOf(data[0].split(": ")[1].trim()), Long.valueOf(data[1].split(": ")[1].trim()));
            }
            LOG.log(Level.WARNING, "stat result for file {0} is incorrect: {1}", new Object[]{filename, res.toString()});
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private Stat(long inode, long ctime) {
        this.inode = inode;
        this.ctime = ctime;
    }

    public long getCtime() {
        return this.ctime;
    }

    public long getInode() {
        return this.inode;
    }

    public String toString() {
        return "inode=" + this.inode + ", " + "ctime=" + this.ctime;
    }
}

