/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.RequestProcessor;

public final class ShellScriptRunner {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private Charset scriptCS;
    private Charset outputCS;
    private final ExecutionEnvironment env;
    private final String script;
    private final URI scriptURI;
    private LineProcessor outputProcessor;
    private LineProcessor errorProcessor;
    private CountDownLatch countdown;
    private NativeProcess shellProcess;
    private final List<String> args = new ArrayList<String>();

    public ShellScriptRunner(ExecutionEnvironment env, String script, LineProcessor outputProcessor) {
        this.env = env;
        this.script = script;
        this.scriptURI = null;
        this.outputProcessor = outputProcessor;
    }

    public ShellScriptRunner(ExecutionEnvironment env, URI scriptURI, LineProcessor outputProcessor) {
        this.env = env;
        this.script = null;
        this.scriptURI = scriptURI;
        this.outputProcessor = outputProcessor;
    }

    public void setScriptCharset(Charset scriptCS) {
        this.scriptCS = scriptCS;
    }

    public void setOutputCharset(Charset outputCS) {
        this.outputCS = outputCS;
    }

    public void setErrorProcessor(LineProcessor errorProcessor) {
        this.errorProcessor = errorProcessor;
    }

    public synchronized int execute() throws IOException, ConnectionManager.CancellationException {
        if (this.scriptURI == null && this.script == null) {
            return 0;
        }
        HostInfo info = HostInfoUtils.getHostInfo(this.env);
        if (info == null || info.getShell() == null) {
            throw new IOException("Unable to get shell for " + this.env.getDisplayName());
        }
        if (this.scriptCS == null) {
            this.scriptCS = this.env.isLocal() ? (info.getOSFamily() == HostInfo.OSFamily.WINDOWS ? WindowsSupport.getInstance().getShellCharset() : Charset.defaultCharset()) : Charset.forName(ProcessUtils.getRemoteCharSet());
        }
        if (this.outputCS == null) {
            this.outputCS = this.scriptCS;
        }
        NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder(this.env);
        ArrayList<String> finalArgs = new ArrayList<String>();
        finalArgs.add("-s");
        if (!this.args.isEmpty()) {
            finalArgs.add("--");
            finalArgs.addAll(this.args);
        }
        pb.setExecutable(info.getShell()).setArguments(finalArgs.toArray(new String[finalArgs.size()]));
        this.shellProcess = pb.call();
        if (this.shellProcess.getState() == NativeProcess.State.ERROR) {
            throw new IOException("Cannot start " + info.getShell() + " -s");
        }
        RequestProcessor rp = new RequestProcessor("Shell runner", 3);
        this.countdown = new CountDownLatch(3);
        Callable<Integer> scriptWriter = new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                BufferedWriter scriptWriter = null;
                try {
                    scriptWriter = new BufferedWriter(new OutputStreamWriter(ShellScriptRunner.this.shellProcess.getOutputStream(), ShellScriptRunner.this.scriptCS));
                    if (ShellScriptRunner.this.script != null) {
                        scriptWriter.write(ShellScriptRunner.this.script);
                        scriptWriter.write(10);
                    } else {
                        BufferedReader scriptReader = null;
                        try {
                            String scriptLine;
                            scriptReader = new BufferedReader(new InputStreamReader(ShellScriptRunner.this.scriptURI.toURL().openStream(), ShellScriptRunner.this.scriptCS));
                            while ((scriptLine = scriptReader.readLine()) != null) {
                                scriptWriter.write(scriptLine);
                                scriptWriter.write(10);
                            }
                        }
                        finally {
                            if (scriptReader != null) {
                                scriptReader.close();
                            }
                        }
                    }
                    scriptWriter.flush();
                }
                finally {
                    if (scriptWriter != null) {
                        scriptWriter.close();
                    }
                    ShellScriptRunner.this.countdown.countDown();
                }
                return 0;
            }
        };
        ProcessOutputReader outReader = new ProcessOutputReader(this.shellProcess.getInputStream(), this.outputProcessor);
        ProcessOutputReader errReader = new ProcessOutputReader(this.shellProcess.getErrorStream(), this.errorProcessor);
        Future writerTask = rp.submit((Callable)scriptWriter);
        Future outReaderTask = rp.submit((Callable)outReader);
        Future errReaderTask = rp.submit((Callable)errReader);
        boolean interrupted = false;
        try {
            this.countdown.await();
        }
        catch (InterruptedException ex) {
            interrupted = true;
        }
        IOException exception = null;
        try {
            writerTask.get();
        }
        catch (InterruptedException ex) {
            interrupted = true;
        }
        catch (ExecutionException ex) {
            exception = new IOException(ex.getCause());
        }
        try {
            outReaderTask.get();
        }
        catch (InterruptedException ex) {
            interrupted = true;
        }
        catch (ExecutionException ex) {
            exception = new IOException(ex.getCause());
        }
        try {
            errReaderTask.get();
        }
        catch (InterruptedException ex) {
            interrupted = true;
        }
        catch (ExecutionException ex) {
            exception = new IOException(ex.getCause());
        }
        rp.shutdown();
        if (exception != null) {
            throw exception;
        }
        if (interrupted) {
            log.info("shell running thread interrupted");
        }
        int result = 1;
        try {
            result = this.shellProcess.waitFor();
        }
        catch (InterruptedException ex) {
            log.info("shell running thread interrupted");
        }
        return result;
    }

    public void setArguments(String ... args) {
        this.args.clear();
        this.args.addAll(Arrays.asList(args));
    }

    public static final class BufferedLineProcessor
    implements LineProcessor {
        private final List<String> buffer = new ArrayList<String>();

        public void processLine(String line) {
            this.buffer.add(line);
        }

        public void reset() {
        }

        public void close() {
        }

        public List<String> getBuffer() {
            return Collections.unmodifiableList(this.buffer);
        }

        public String getAsString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.buffer.size(); ++i) {
                builder.append(this.buffer.get(i));
                if (i >= this.buffer.size() - 1) continue;
                builder.append('\n');
            }
            return builder.toString();
        }
    }

    public static final class LoggerLineProcessor
    implements LineProcessor {
        private final String prefix;

        public LoggerLineProcessor(String prefix) {
            this.prefix = prefix;
        }

        public void processLine(String line) {
            log.log(Level.FINE, "{0}: {1}", new Object[]{this.prefix, line});
        }

        public void reset() {
        }

        public void close() {
        }
    }

    private class ProcessOutputReader
    implements Callable<Integer> {
        private final LineProcessor lineProcessor;
        private final InputStream in;

        ProcessOutputReader(InputStream in, LineProcessor lineProcessor) {
            this.in = in;
            this.lineProcessor = lineProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws Exception {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(this.in));
                while ((line = reader.readLine()) != null) {
                    if (this.lineProcessor == null) continue;
                    this.lineProcessor.processLine(line);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (this.lineProcessor != null) {
                    this.lineProcessor.close();
                }
                ShellScriptRunner.this.countdown.countDown();
            }
            return 0;
        }
    }
}

