/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Md5checker;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.MiscUtils;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

class SftpSupport {
    private static final boolean isUnitTest = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final java.util.logging.Logger LOG = Logger.getInstance();
    private static final Object instancesLock = new Object();
    private static Map<ExecutionEnvironment, SftpSupport> instances = new HashMap<ExecutionEnvironment, SftpSupport>();
    private static AtomicInteger uploadCount = new AtomicInteger(0);
    private static final int PUT_RETRY_COUNT = Integer.getInteger("sftp.put.retries", 1);
    private static final int LS_RETRY_COUNT = Integer.getInteger("sftp.ls.retries", 2);
    private static int CONCURRENCY_LEVEL = Integer.getInteger("remote.sftp.threads", Runtime.getRuntime().availableProcessors() + 2);
    private static final String PREFIX = "SFTP: ";
    private final RequestProcessor requestProcessor = new RequestProcessor("SFTP: ", CONCURRENCY_LEVEL);
    private final ExecutionEnvironment execEnv;
    private final LinkedList<ChannelSftp> spareChannels = new LinkedList();
    private int currBusyChannels = 0;
    private int maxBusyChannels = 0;
    private final Object channelLock = new Object();

    static int getUploadCount() {
        return uploadCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SftpSupport getInstance(ExecutionEnvironment execEnv) {
        SftpSupport instance;
        Object object = instancesLock;
        synchronized (object) {
            instance = instances.get(execEnv);
            if (instance == null) {
                instance = new SftpSupport(execEnv);
                instances.put(execEnv, instance);
            }
        }
        return instance;
    }

    private SftpSupport(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "SftpSupport for {0} started with maximum thread count: {1}", new Object[]{execEnv, CONCURRENCY_LEVEL});
        }
    }

    private RequestProcessor getReadRequestProcessor() {
        return this.requestProcessor;
    }

    public RequestProcessor getWriteRuestProcessor() {
        return this.requestProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementStatistics() {
        Object object = this.channelLock;
        synchronized (object) {
            ++this.currBusyChannels;
            if (this.currBusyChannels > this.maxBusyChannels) {
                this.maxBusyChannels = this.currBusyChannels;
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "SFTP max. busy channels reached: {0}", this.maxBusyChannels);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementStatistics() {
        Object object = this.channelLock;
        synchronized (object) {
            --this.currBusyChannels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseChannel(ChannelSftp channel) {
        Object object = this.channelLock;
        synchronized (object) {
            if (channel.isConnected()) {
                this.spareChannels.push(channel);
            }
            this.decrementStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelSftp getChannel() throws IOException, ConnectionManager.CancellationException, JSchException, ExecutionException, InterruptedException {
        ConnectionManagerAccessor cmAccess;
        ChannelSftp channel;
        Object object = this.channelLock;
        synchronized (object) {
            while (!this.spareChannels.isEmpty()) {
                channel = this.spareChannels.pop();
                if (!channel.isConnected()) continue;
                this.incrementStatistics();
                return channel;
            }
        }
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            ConnectionManager.getInstance().connectTo(this.execEnv);
        }
        if ((cmAccess = ConnectionManagerAccessor.getDefault()) == null) {
            throw new ExecutionException("Error getting ConnectionManagerAccessor", new NullPointerException());
        }
        channel = (ChannelSftp)cmAccess.openAndAcquireChannel(this.execEnv, "sftp", true);
        if (channel == null) {
            throw new ExecutionException("ConnectionManagerAccessor returned null channel while waitIfNoAvailable was set to true", new NullPointerException());
        }
        channel.connect();
        this.incrementStatistics();
        return channel;
    }

    private static FileInfoProvider.SftpIOException decorateSftpException(SftpException e, String path) {
        return new FileInfoProvider.SftpIOException(e.id, e.getMessage(), path, e);
    }

    Future<CommonTasksSupport.UploadStatus> uploadFile(CommonTasksSupport.UploadParameters parameters) {
        Logger.assertTrue(parameters.dstExecEnv.equals(this.execEnv));
        Uploader uploader = new Uploader(parameters);
        final FutureTask<CommonTasksSupport.UploadStatus> ftask = new FutureTask<CommonTasksSupport.UploadStatus>(uploader);
        RequestProcessor.Task requestProcessorTask = this.getWriteRuestProcessor().create(ftask);
        if (parameters.callback != null) {
            final ChangeListener callback = parameters.callback;
            requestProcessorTask.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    callback.stateChanged(new ChangeEvent(ftask));
                }
            });
        }
        requestProcessorTask.schedule(0);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} schedulled", uploader.getTraceName());
        }
        return ftask;
    }

    Future<Integer> downloadFile(String srcFileName, String dstFileName, Writer error) {
        Downloader downloader = new Downloader(srcFileName, dstFileName, error);
        FutureTask<Integer> ftask = new FutureTask<Integer>(downloader);
        this.getReadRequestProcessor().post(ftask);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} schedulled", downloader.getTraceName());
        }
        return ftask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfoProvider.StatInfo createStatInfo(String dirName, String baseName, SftpATTRS attrs, ChannelSftp cftp) throws SftpException {
        String linkTarget = null;
        if (attrs.isLink()) {
            String path = dirName + '/' + baseName;
            RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity("readlink", path);
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "performing readlink {0}", path);
                }
                linkTarget = cftp.readlink(path);
            }
            finally {
                RemoteStatistics.stopChannelActivity(activityID);
            }
        }
        Date lastModified = new Date((long)attrs.getMTime() * 1000L);
        FileInfoProvider.StatInfo result = new FileInfoProvider.StatInfo(baseName, attrs.getUId(), attrs.getGId(), attrs.getSize(), attrs.isDir(), attrs.isLink(), linkTarget, attrs.getPermissions(), lastModified);
        return result;
    }

    Future<FileInfoProvider.StatInfo> lstat(String absPath, Writer error) {
        StatLoader loader = new StatLoader(absPath, true);
        FutureTask<FileInfoProvider.StatInfo> ftask = new FutureTask<FileInfoProvider.StatInfo>(loader);
        this.getReadRequestProcessor().post(ftask);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} schedulled", loader.getTraceName());
        }
        return ftask;
    }

    Future<FileInfoProvider.StatInfo> stat(String absPath, Writer error) {
        StatLoader loader = new StatLoader(absPath, false);
        FutureTask<FileInfoProvider.StatInfo> ftask = new FutureTask<FileInfoProvider.StatInfo>(loader);
        this.getReadRequestProcessor().post(ftask);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} schedulled", loader.getTraceName());
        }
        return ftask;
    }

    Future<FileInfoProvider.StatInfo[]> ls(String absPath, Writer error) {
        LsLoader loader = new LsLoader(absPath);
        FutureTask<FileInfoProvider.StatInfo[]> ftask = new FutureTask<FileInfoProvider.StatInfo[]>(loader);
        this.getReadRequestProcessor().post(ftask);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} schedulled", loader.getTraceName());
        }
        return ftask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testSetConcurrencyLevel(int level) {
        boolean hadInstances;
        Object object = instancesLock;
        synchronized (object) {
            hadInstances = !instances.isEmpty();
            instances.clear();
        }
        CONCURRENCY_LEVEL = level;
        if (hadInstances) {
            System.err.printf("Warning: SFTP concurrency level was set while there were some %s instances\n", SftpSupport.class.getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxBusyChannels() {
        Object object = this.channelLock;
        synchronized (object) {
            return this.maxBusyChannels;
        }
    }

    private static void softAssertAbsolutePath(String path) {
        if (!path.startsWith("/") && LOG.isLoggable(Level.FINE)) {
            String emsg = "path should be absolute: " + path;
            LOG.log(Level.FINE, emsg, new IllegalArgumentException(emsg));
        }
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result;

        static {
            $SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result = new int[Md5checker.Result.values().length];
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.UPTODATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.DIFFERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.INEXISTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private abstract class BaseWorker {
        private BaseWorker() {
        }

        protected abstract String getTraceName();

        protected void logException(Exception ex, Writer error) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Error " + this.getTraceName(), ex);
            }
            if (error != null) {
                try {
                    error.append(ex.getLocalizedMessage());
                }
                catch (IOException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
    }

    private class Downloader
    extends BaseWorker
    implements Callable<Integer> {
        protected final String srcFileName;
        protected final String dstFileName;
        protected final Writer error;

        public Downloader(String srcFileName, String dstFileName, Writer error) {
            this.error = error;
            this.srcFileName = srcFileName;
            this.dstFileName = dstFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws InterruptedException {
            long time = System.currentTimeMillis();
            int rc = -1;
            try {
                Thread.currentThread().setName("SFTP: : " + this.getTraceName());
                this.work();
                rc = 0;
            }
            catch (JSchException ex) {
                if (MiscUtils.isJSCHTooLongException((Exception)((Object)ex))) {
                    if (isUnitTest) {
                        this.logException((Exception)((Object)ex), this.error);
                    } else {
                        MiscUtils.showJSCHTooLongNotification();
                    }
                    rc = 7;
                } else {
                    this.logException((Exception)((Object)ex), this.error);
                    rc = 1;
                }
            }
            catch (SftpException ex) {
                this.logException((Exception)((Object)ex), this.error);
                rc = 2;
            }
            catch (ConnectException ex) {
                this.logException(ex, this.error);
                rc = 3;
            }
            catch (InterruptedIOException ex) {
                rc = 4;
                throw new InterruptedException(ex.getMessage());
            }
            catch (IOException ex) {
                this.logException(ex, this.error);
                rc = 5;
            }
            catch (ConnectionManager.CancellationException ex) {
                rc = 6;
            }
            catch (ExecutionException ex) {
                this.logException(ex, this.error);
                rc = 7;
            }
            finally {
                time = System.currentTimeMillis() - time;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0}{1} ({2} ms)", new Object[]{this.getTraceName(), rc == 0 ? " OK" : " FAILED", time});
            }
            return rc;
        }

        protected void work() throws IOException, ConnectionManager.CancellationException, JSchException, SftpException, ExecutionException, InterruptedException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} started", this.getTraceName());
            }
            ChannelSftp cftp = SftpSupport.this.getChannel();
            RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity("download", this.srcFileName);
            try {
                cftp.get(this.srcFileName, this.dstFileName);
            }
            catch (SftpException e) {
                if (MiscUtils.mightBrokeSftpChannel(e)) {
                    cftp.quit();
                }
                throw SftpSupport.decorateSftpException(e, this.srcFileName);
            }
            finally {
                SftpSupport.this.releaseChannel(cftp);
                RemoteStatistics.stopChannelActivity(activityID, new File(this.dstFileName).length());
            }
        }

        @Override
        protected String getTraceName() {
            return "Downloading " + SftpSupport.this.execEnv + ":" + this.srcFileName + " to " + this.dstFileName;
        }
    }

    private class LsLoader
    extends BaseWorker
    implements Callable<FileInfoProvider.StatInfo[]> {
        private final String path;

        public LsLoader(String path) {
            SftpSupport.softAssertAbsolutePath(path);
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoProvider.StatInfo[] call() throws IOException, ConnectionManager.CancellationException, JSchException, ExecutionException, InterruptedException, SftpException {
            int attempt;
            if (!this.path.startsWith("/")) {
                throw new FileNotFoundException("Path is not absolute: " + this.path);
            }
            ArrayList<FileInfoProvider.StatInfo> result = null;
            SftpException exception = null;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} started", this.getTraceName());
            }
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("SFTP: : " + this.getTraceName());
            try {
                for (attempt = 1; attempt <= LS_RETRY_COUNT; ++attempt) {
                    ChannelSftp cftp = SftpSupport.this.getChannel();
                    RemoteStatistics.ActivityID lsLoadID = RemoteStatistics.startChannelActivity("lsload", this.path);
                    try {
                        Vector entries = cftp.ls(this.path);
                        result = new ArrayList<FileInfoProvider.StatInfo>(Math.max(1, entries.size() - 2));
                        for (ChannelSftp.LsEntry entry : entries) {
                            String name = entry.getFilename();
                            if (".".equals(name) || "..".equals(name)) continue;
                            SftpATTRS attrs = entry.getAttrs();
                            result.add(SftpSupport.this.createStatInfo(this.path, name, attrs, cftp));
                        }
                        exception = null;
                        break;
                    }
                    catch (SftpException e) {
                        exception = e;
                        if (e.id == 4) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "{0} - exception while attempt {1}", new Object[]{this.getTraceName(), attempt});
                            }
                            if (!MiscUtils.mightBrokeSftpChannel(e)) continue;
                            cftp.quit();
                            continue;
                        }
                        break;
                    }
                    finally {
                        RemoteStatistics.stopChannelActivity(lsLoadID);
                        SftpSupport.this.releaseChannel(cftp);
                    }
                }
            }
            finally {
                Thread.currentThread().setName(threadName);
            }
            if (exception != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "{0} failed", this.getTraceName());
                }
                throw SftpSupport.decorateSftpException(exception, this.path);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} finished in {1} attempt(s)", new Object[]{this.getTraceName(), attempt});
            }
            return result == null ? new FileInfoProvider.StatInfo[]{} : result.toArray(new FileInfoProvider.StatInfo[result.size()]);
        }

        @Override
        public String getTraceName() {
            return "listing directory " + this.path;
        }
    }

    private class StatLoader
    extends BaseWorker
    implements Callable<FileInfoProvider.StatInfo> {
        private final String path;
        private final boolean lstat;

        public StatLoader(String path, boolean lstat) {
            if (path.isEmpty()) {
                path = "/";
            }
            SftpSupport.softAssertAbsolutePath(path);
            this.path = path;
            this.lstat = lstat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoProvider.StatInfo call() throws IOException, ConnectionManager.CancellationException, JSchException, ExecutionException, InterruptedException, SftpException {
            int attempt;
            if (!this.path.startsWith("/")) {
                throw new FileNotFoundException("Path is not absolute: " + this.path);
            }
            FileInfoProvider.StatInfo result = null;
            SftpException exception = null;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} started", this.getTraceName());
            }
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("SFTP: : " + this.getTraceName());
            try {
                for (attempt = 1; attempt <= LS_RETRY_COUNT; ++attempt) {
                    ChannelSftp cftp = SftpSupport.this.getChannel();
                    RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity("statload", this.path);
                    try {
                        String baseName;
                        String dirName;
                        SftpATTRS attrs = this.lstat ? cftp.lstat(this.path) : cftp.stat(this.path);
                        int slashPos = this.path.lastIndexOf(47);
                        if (slashPos == 0) {
                            dirName = "";
                            baseName = this.path.substring(1);
                        } else {
                            dirName = this.path.substring(0, slashPos);
                            baseName = this.path.substring(slashPos + 1);
                        }
                        result = SftpSupport.this.createStatInfo(dirName, baseName, attrs, cftp);
                        exception = null;
                        break;
                    }
                    catch (SftpException e) {
                        exception = e;
                        if (e.id == 4) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "{0} - exception while attempt {1}", new Object[]{this.getTraceName(), attempt});
                            }
                            if (!MiscUtils.mightBrokeSftpChannel(e)) continue;
                            cftp.quit();
                            continue;
                        }
                        break;
                    }
                    finally {
                        RemoteStatistics.stopChannelActivity(activityID);
                        SftpSupport.this.releaseChannel(cftp);
                    }
                }
            }
            finally {
                Thread.currentThread().setName(threadName);
            }
            if (exception != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "{0} failed", this.getTraceName());
                }
                throw SftpSupport.decorateSftpException(exception, this.path);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} finished in {1} attempt(s)", new Object[]{this.getTraceName(), attempt});
            }
            return result;
        }

        @Override
        public String getTraceName() {
            return "Getting stat for " + this.path;
        }
    }

    private class Uploader
    extends BaseWorker
    implements Callable<CommonTasksSupport.UploadStatus> {
        private final CommonTasksSupport.UploadParameters parameters;
        protected FileInfoProvider.StatInfo statInfo;

        public Uploader(CommonTasksSupport.UploadParameters parameters) {
            this.parameters = parameters;
        }

        @Override
        public CommonTasksSupport.UploadStatus call() throws InterruptedException {
            int rc2;
            StringBuilder err = new StringBuilder();
            try {
                Thread.currentThread().setName("SFTP: : " + this.getTraceName());
                this.work(err);
                rc2 = 0;
            }
            catch (JSchException ex) {
                if (MiscUtils.isJSCHTooLongException((Exception)((Object)ex))) {
                    if (isUnitTest) {
                        this.logException((Exception)((Object)ex), null);
                    } else {
                        MiscUtils.showJSCHTooLongNotification();
                    }
                    rc2 = 7;
                } else {
                    this.logException((Exception)((Object)ex), null);
                    rc2 = 1;
                }
                err.append(ex.getMessage());
            }
            catch (SftpException ex) {
                err.append(ex.getMessage());
                this.logException((Exception)((Object)ex), null);
                rc2 = 2;
            }
            catch (ConnectException ex) {
                err.append(ex.getMessage());
                this.logException(ex, null);
                rc2 = 3;
            }
            catch (InterruptedIOException ex) {
                err.append(ex.getMessage());
                int rc2 = 4;
                throw new InterruptedException(ex.getMessage());
            }
            catch (IOException ex) {
                err.append(ex.getMessage());
                this.logException(ex, null);
                rc2 = 5;
            }
            catch (ConnectionManager.CancellationException ex) {
                err.append(ex.getMessage());
                rc2 = 6;
            }
            catch (ExecutionException ex) {
                err.append(ex.getMessage());
                this.logException(ex, null);
                rc2 = 7;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0}{1}", new Object[]{this.getTraceName(), rc2 == 0 ? " OK" : " FAILED"});
            }
            return new CommonTasksSupport.UploadStatus(rc2, err.toString(), this.statInfo);
        }

        private void work(StringBuilder err) throws IOException, ConnectionManager.CancellationException, JSchException, SftpException, InterruptedException, ExecutionException {
            boolean checkDir = false;
            if (this.parameters.checkMd5) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Md5 check for {0}:{1} started", new Object[]{SftpSupport.this.execEnv, this.parameters.dstFileName});
                }
                Enum res = null;
                try {
                    res = new Md5checker(SftpSupport.this.execEnv).check(this.parameters.srcFile, this.parameters.dstFileName);
                }
                catch (NoSuchAlgorithmException ex) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Can not perform md5 check for {0}: {1}", new Object[]{SftpSupport.this.execEnv.getDisplayName(), ex.getMessage()});
                    }
                    res = HostInfoUtils.fileExists(SftpSupport.this.execEnv, this.parameters.dstFileName) ? Md5checker.Result.UPTODATE : Md5checker.Result.INEXISTENT;
                }
                catch (Md5checker.CheckSumException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "SftpSupport interrupted", ex);
                    }
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                switch (2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[res.ordinal()]) {
                    case 1: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "{0}:{1} up to date - skipped", new Object[]{SftpSupport.this.execEnv, this.parameters.dstFileName});
                        }
                        return;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        checkDir = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected MD5 check result: " + res);
                    }
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} started", this.getTraceName());
            }
            long time = System.currentTimeMillis();
            ChannelSftp cftp = SftpSupport.this.getChannel();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Getting channel for {0} took {1}", new Object[]{this.parameters.dstFileName, System.currentTimeMillis() - time});
            }
            String dstFileName = this.parameters.dstFileName;
            RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity("upload", this.parameters.dstFileName);
            try {
                String baseName;
                String dirName;
                int slashPos;
                int slashPos2;
                if (checkDir && (slashPos2 = this.parameters.dstFileName.lastIndexOf(47)) >= 0) {
                    String remoteDir = this.parameters.dstFileName.substring(0, slashPos2);
                    StringWriter swr = new StringWriter();
                    time = System.currentTimeMillis();
                    CommonTasksSupport.mkDir(SftpSupport.this.execEnv, remoteDir, swr).get();
                    err.append(swr.getBuffer()).append(' ');
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "Creating directory {0} took {1}", new Object[]{remoteDir, System.currentTimeMillis() - time});
                    }
                }
                time = System.currentTimeMillis();
                this.put(cftp);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "Uploading {0} took {1}", new Object[]{dstFileName, System.currentTimeMillis() - time});
                }
                if (this.parameters.dstFileToRename != null) {
                    time = System.currentTimeMillis();
                    ProcessUtils.ExitStatus rc = ProcessUtils.execute(SftpSupport.this.execEnv, "/bin/sh", "-c", "cp \"" + this.parameters.dstFileName + "\" \"" + this.parameters.dstFileToRename + "\" && rm \"" + this.parameters.dstFileName + '\"');
                    if (!rc.isOK()) {
                        throw new ExecutionException(rc.error, null);
                    }
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "cp&&rm {0} to {1} took {2}", new Object[]{this.parameters.dstFileName, this.parameters.dstFileToRename, System.currentTimeMillis() - time});
                    }
                    dstFileName = this.parameters.dstFileToRename;
                }
                if (this.parameters.mask >= 0) {
                    time = System.currentTimeMillis();
                    cftp.chmod(this.parameters.mask, dstFileName);
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "Chmod {0} took {1}", new Object[]{dstFileName, System.currentTimeMillis() - time});
                    }
                }
                time = System.currentTimeMillis();
                SftpATTRS attrs = cftp.lstat(dstFileName);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "Getting stat for {0} took {1}", new Object[]{dstFileName, System.currentTimeMillis() - time});
                }
                if ((slashPos = dstFileName.lastIndexOf(47)) < 0) {
                    dirName = dstFileName;
                    baseName = "";
                } else {
                    dirName = dstFileName.substring(0, slashPos);
                    baseName = dstFileName.substring(slashPos + 1);
                }
                this.statInfo = SftpSupport.this.createStatInfo(dirName, baseName, attrs, cftp);
            }
            catch (SftpException e) {
                if (MiscUtils.mightBrokeSftpChannel(e)) {
                    cftp.quit();
                }
                throw SftpSupport.decorateSftpException(e, dstFileName);
            }
            finally {
                SftpSupport.this.releaseChannel(cftp);
                RemoteStatistics.stopChannelActivity(activityID, this.parameters.srcFile.length());
            }
            uploadCount.incrementAndGet();
        }

        private void put(ChannelSftp cftp) throws FileInfoProvider.SftpIOException {
            int attempt = 0;
            while (true) {
                ++attempt;
                try {
                    cftp.put(this.parameters.srcFile.getAbsolutePath(), this.parameters.dstFileName);
                    if (attempt > 1 && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Success on attempt {0} to copy {1} to {2}:{3} :\n", new Object[]{attempt, this.parameters.srcFile.getAbsolutePath(), SftpSupport.this.execEnv, this.parameters.dstFileName});
                    }
                    return;
                }
                catch (SftpException e) {
                    if (attempt > PUT_RETRY_COUNT) {
                        throw SftpSupport.decorateSftpException(e, this.parameters.dstFileName);
                    }
                    if (LOG.isLoggable(Level.FINE) || attempt == 2) {
                        String message = String.format("Error on attempt %d to copy %s to %s:%s :\n", attempt, this.parameters.srcFile.getAbsolutePath(), SftpSupport.this.execEnv, this.parameters.dstFileName);
                        LOG.log(Level.FINE, message, e);
                        if (attempt == 2) {
                            Logger.fullThreadDump(message);
                        }
                    }
                    e.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }

        @Override
        protected String getTraceName() {
            return "Uploading " + this.parameters.srcFile.getAbsolutePath() + " to " + SftpSupport.this.execEnv + ":" + this.parameters.dstFileName;
        }
    }
}

