/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.NbRemoteNativeProcess;
import org.netbeans.modules.nativeexecution.RemoteNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class ProcessUtils {
    private static final RequestProcessor RP = new RequestProcessor("ProcessUtils", 1);
    private static final String remoteCharSet = System.getProperty("cnd.remote.charset", "UTF-8");

    private ProcessUtils() {
    }

    public static String getRemoteCharSet() {
        return remoteCharSet;
    }

    public static boolean isAlive(Process p) {
        if (p instanceof RemoteNativeProcess) {
            RemoteNativeProcess rnp = (RemoteNativeProcess)p;
            return rnp.isAlive();
        }
        if (p instanceof NbRemoteNativeProcess) {
            NbRemoteNativeProcess rnp = (NbRemoteNativeProcess)p;
            return rnp.isAlive();
        }
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException x) {
            return true;
        }
    }

    public static BufferedReader getReader(InputStream is, boolean remote) {
        if (remote) {
            try {
                return new BufferedReader(new InputStreamReader(is, ProcessUtils.getRemoteCharSet()));
            }
            catch (UnsupportedEncodingException ex) {
                String msg = ProcessUtils.getRemoteCharSet() + " encoding is not supported, try to override it with cnd.remote.charset";
                Exceptions.printStackTrace((Throwable)new IllegalStateException(msg, ex));
            }
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    public static PrintWriter getWriter(OutputStream os, boolean remote) {
        if (remote) {
            try {
                return new PrintWriter(new OutputStreamWriter(os, ProcessUtils.getRemoteCharSet()));
            }
            catch (UnsupportedEncodingException ex) {
                String msg = ProcessUtils.getRemoteCharSet() + " encoding is not supported, try to override it with cnd.remote.charset";
                Exceptions.printStackTrace((Throwable)new IllegalStateException(msg, ex));
            }
        }
        return new PrintWriter(os);
    }

    public static List<String> readProcessError(Process p) throws IOException {
        if (p == null) {
            return Collections.emptyList();
        }
        return ProcessUtils.readProcessStream(p.getErrorStream(), ProcessUtils.isRemote(p));
    }

    public static String readProcessErrorLine(Process p) throws IOException {
        if (p == null) {
            return "";
        }
        return ProcessUtils.readProcessStreamLine(p.getErrorStream(), ProcessUtils.isRemote(p));
    }

    public static List<String> readProcessOutput(Process p) throws IOException {
        if (p == null) {
            return Collections.emptyList();
        }
        return ProcessUtils.readProcessStream(p.getInputStream(), ProcessUtils.isRemote(p));
    }

    public static String readProcessOutputLine(Process p) throws IOException {
        if (p == null) {
            return "";
        }
        return ProcessUtils.readProcessStreamLine(p.getInputStream(), ProcessUtils.isRemote(p));
    }

    private static boolean isRemote(Process process) {
        if (process instanceof NativeProcess) {
            return ((NativeProcess)process).getExecutionEnvironment().isRemote();
        }
        return false;
    }

    public static void logError(Level logLevel, java.util.logging.Logger log, Process p) throws IOException {
        if (log == null || !log.isLoggable(logLevel)) {
            return;
        }
        List<String> err = ProcessUtils.readProcessError(p);
        for (String line : err) {
            log.log(logLevel, "ERROR: {0}", line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readProcessStream(InputStream stream, boolean remoteStream) throws IOException {
        if (stream == null) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        BufferedReader br = ProcessUtils.getReader(stream, remoteStream);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readProcessStreamLine(InputStream stream, boolean remoteStream) throws IOException {
        if (stream == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        BufferedReader br = ProcessUtils.getReader(stream, remoteStream);
        try {
            String line;
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (!first) {
                    result.append('\n');
                }
                result.append(line);
                first = false;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result.toString();
    }

    public static void writeError(Writer error, Process p) throws IOException {
        List<String> err = ProcessUtils.readProcessError(p);
        for (String line : err) {
            error.write(line);
        }
    }

    public static void destroy(Process process) {
        process.destroy();
        try {
            process.exitValue();
            return;
        }
        catch (IllegalThreadStateException ex) {
            ExecutionEnvironment execEnv = process instanceof NativeProcess ? ((NativeProcess)process).getExecutionEnvironment() : ExecutionEnvironmentFactory.getLocal();
            int pid = ProcessUtils.getPID(process);
            if (pid > 0) {
                try {
                    CommonTasksSupport.sendSignal(execEnv, pid, Signal.SIGKILL, null).get();
                }
                catch (InterruptedException ex2) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private static int getPID(Process process) {
        int pid = -1;
        try {
            if (process instanceof NativeProcess) {
                pid = ((NativeProcess)process).getPID();
            } else {
                String className = process.getClass().getName();
                if ("java.lang.UNIXProcess".equals(className)) {
                    Field f = process.getClass().getDeclaredField("pid");
                    f.setAccessible(true);
                    pid = f.getInt(process);
                }
            }
        }
        catch (Throwable e) {
            Logger.getInstance().log(Level.FINE, e.getMessage(), e);
        }
        return pid;
    }

    public static Future<ExitStatus> execute(final ExecutionEnvironment execEnv, RequestProcessor rp, final PostExecutor postExecutor, final String executable, final String ... args) {
        RequestProcessor processor = rp == null ? RP : rp;
        return processor.submit((Callable)new Callable<ExitStatus>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ExitStatus call() throws Exception {
                ExitStatus status = null;
                String error = null;
                try {
                    status = ProcessUtils.execute(execEnv, executable, args);
                    if (postExecutor != null) {
                        postExecutor.processFinished(error == null ? status : new ExitStatus(1, "", error));
                    }
                }
                catch (Throwable t) {
                    try {
                        error = t.getMessage();
                        if (postExecutor != null) {
                            postExecutor.processFinished(error == null ? status : new ExitStatus(1, "", error));
                        }
                    }
                    catch (Throwable throwable) {
                        if (postExecutor != null) {
                            postExecutor.processFinished(error == null ? status : new ExitStatus(1, "", error));
                        }
                        throw throwable;
                    }
                }
                return status;
            }
        });
    }

    public static ExitStatus execute(ExecutionEnvironment execEnv, String executable, String ... args) {
        return ProcessUtils.execute(NativeProcessBuilder.newProcessBuilder(execEnv).setExecutable(executable).setArguments(args));
    }

    public static ExitStatus executeInDir(String workingDir, ExecutionEnvironment execEnv, String executable, String ... args) {
        return ProcessUtils.execute(NativeProcessBuilder.newProcessBuilder(execEnv).setExecutable(executable).setArguments(args).setWorkingDirectory(workingDir));
    }

    public static ExitStatus executeWithoutMacroExpansion(String workingDir, ExecutionEnvironment execEnv, String executable, String ... args) {
        if (workingDir != null) {
            return ProcessUtils.execute(NativeProcessBuilder.newProcessBuilder(execEnv).setExecutable(executable).setArguments(args).setMacroExpansion(false));
        }
        return ProcessUtils.execute(NativeProcessBuilder.newProcessBuilder(execEnv).setExecutable(executable).setArguments(args).setWorkingDirectory(workingDir).setMacroExpansion(false));
    }

    public static ExitStatus execute(NativeProcessBuilder processBuilder) {
        ExitStatus result;
        if (processBuilder == null) {
            throw new NullPointerException("NULL process builder!");
        }
        processBuilder.setX11Forwarding(false);
        processBuilder.setInitialSuspend(false);
        processBuilder.unbufferOutput(false);
        processBuilder.useExternalTerminal(null);
        try {
            final NativeProcess process = processBuilder.call();
            Future<String> error = NativeTaskExecutorService.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ProcessUtils.readProcessErrorLine(process);
                }
            }, "e");
            Future<String> output = NativeTaskExecutorService.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ProcessUtils.readProcessOutputLine(process);
                }
            }, "o");
            result = new ExitStatus(process.waitFor(), output.get(), error.get());
        }
        catch (InterruptedException ex) {
            result = new ExitStatus(-100, "", ex.getMessage());
        }
        catch (Throwable th) {
            Logger.getInstance().log(Level.INFO, th.getMessage(), th);
            result = new ExitStatus(-200, "", th.getMessage());
        }
        return result;
    }

    public static ExitStatus execute(ProcessBuilder processBuilder) {
        ExitStatus result;
        if (processBuilder == null) {
            throw new NullPointerException("NULL process builder!");
        }
        try {
            final Process process = processBuilder.start();
            Future<String> error = NativeTaskExecutorService.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ProcessUtils.readProcessErrorLine(process);
                }
            }, "e");
            Future<String> output = NativeTaskExecutorService.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ProcessUtils.readProcessOutputLine(process);
                }
            }, "o");
            result = new ExitStatus(process.waitFor(), output.get(), error.get());
        }
        catch (InterruptedException ex) {
            result = new ExitStatus(-100, "", ex.getMessage());
        }
        catch (Throwable th) {
            Logger.getInstance().log(Level.INFO, th.getMessage(), th);
            result = new ExitStatus(-200, "", th.getMessage());
        }
        return result;
    }

    public static final class ExitStatus {
        public final int exitCode;
        public final String error;
        public final String output;

        public ExitStatus(int exitCode, String output, String error) {
            this.exitCode = exitCode;
            this.error = error;
            this.output = output;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }

        public String toString() {
            return "ExitStatus exitCode=" + this.exitCode + "\nerror=" + this.error + "\noutput=" + this.output;
        }
    }

    public static interface PostExecutor {
        public void processFinished(ExitStatus var1);
    }
}

