/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public final class MacroExpanderFactory {
    private static final HashMap<String, MacroExpander> expanderCache = new HashMap();

    private MacroExpanderFactory() {
    }

    public static MacroExpander getExpander(ExecutionEnvironment execEnv) {
        return MacroExpanderFactory.getExpander(execEnv, ExpanderStyle.DEFAULT_STYLE, true);
    }

    public static MacroExpander getExpander(ExecutionEnvironment execEnv, boolean connectIfNeed) {
        return MacroExpanderFactory.getExpander(execEnv, ExpanderStyle.DEFAULT_STYLE, connectIfNeed);
    }

    public static synchronized MacroExpander getExpander(ExecutionEnvironment execEnv, ExpanderStyle style) {
        return MacroExpanderFactory.getExpander(execEnv, style, true);
    }

    public static synchronized MacroExpander getExpander(ExecutionEnvironment execEnv, ExpanderStyle style, boolean connectIfNeed) {
        if (connectIfNeed && !HostInfoUtils.isHostInfoAvailable(execEnv) && SwingUtilities.isEventDispatchThread()) {
            throw new IllegalThreadStateException("Should never be called from AWT thread");
        }
        String key = ExecutionEnvironmentFactory.toUniqueID(execEnv) + '_' + (Object)((Object)style);
        MacroExpander result = expanderCache.get(key);
        if (result != null) {
            return result;
        }
        HostInfo hostInfo = null;
        try {
            if (connectIfNeed || HostInfoUtils.isHostInfoAvailable(execEnv)) {
                hostInfo = HostInfoUtils.getHostInfo(execEnv);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ConnectionManager.CancellationException ex) {
            // empty catch block
        }
        result = new MacroExpanderImpl(hostInfo, style);
        if (hostInfo != null) {
            expanderCache.put(key, result);
        }
        return result;
    }

    public static enum ExpanderStyle {
        SUNSTUDIO_STYLE,
        DEFAULT_STYLE;

    }

    public static interface MacroExpander {
        public String expandPredefinedMacros(String var1) throws ParseException;

        public String expandMacros(String var1, Map<String, String> var2) throws ParseException;
    }

    private static class MacroExpanderImpl
    implements MacroExpander {
        private static final int[][] ttable = new int[][]{{0, 0, 0, 1, 0, 0}, {2, 3, 3, 10, 4, 3}, {2, 2, 5, 6, 5, 5}, {7, 7, 8, 8, 8, 9}, {7, 3, 3, 3, 8, 8}};
        protected final Map<String, String> predefinedMacros = Collections.synchronizedMap(new HashMap());
        protected final HostInfo hostInfo;

        public MacroExpanderImpl(HostInfo hostInfo, ExpanderStyle style) {
            this.hostInfo = hostInfo;
            this.setupPredefined(style);
        }

        private int getCharClass(char c) {
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                return 0;
            }
            if (c >= '0' && c <= '9') {
                return 1;
            }
            if (c == '$') {
                return 3;
            }
            if (c == '{') {
                return 4;
            }
            if (c == '}') {
                return 5;
            }
            return 2;
        }

        private String valueOf(String macro, Map<String, String> map) {
            String result = map.get(macro);
            return result == null ? "${" + macro + "}" : result;
        }

        @Override
        public final String expandPredefinedMacros(String string) throws ParseException {
            return this.expandMacros(string, this.predefinedMacros);
        }

        @Override
        public final String expandMacros(String string, Map<String, String> map) throws ParseException {
            if (string == null || string.length() == 0) {
                return string;
            }
            StringBuilder res = new StringBuilder();
            StringBuilder buf = new StringBuilder();
            int state = 0;
            int mpos = -1;
            char[] chars = (string + '\u0000').toCharArray();
            block13: for (int pos = 0; pos < chars.length; ++pos) {
                char c = chars[pos];
                switch (ttable[state][this.getCharClass(c)]) {
                    case 0: {
                        if (c == '\u0000') continue block13;
                        res.append(c);
                        continue block13;
                    }
                    case 1: {
                        mpos = pos;
                        buf.setLength(0);
                        state = 1;
                        continue block13;
                    }
                    case 2: {
                        buf.append(c);
                        state = 2;
                        continue block13;
                    }
                    case 3: {
                        res.append(string.substring(mpos, pos + (c == '\u0000' ? 0 : 1)));
                        buf.setLength(0);
                        state = 0;
                        continue block13;
                    }
                    case 4: {
                        state = 4;
                        continue block13;
                    }
                    case 5: {
                        res.append(this.valueOf(buf.toString().trim(), map));
                        --pos;
                        buf.setLength(0);
                        state = 0;
                        continue block13;
                    }
                    case 6: {
                        res.append(this.valueOf(buf.toString().trim(), map));
                        mpos = pos;
                        buf.setLength(0);
                        state = 1;
                        continue block13;
                    }
                    case 7: {
                        buf.append(c);
                        state = 3;
                        continue block13;
                    }
                    case 8: {
                        throw new ParseException("Bad substitution", pos);
                    }
                    case 9: {
                        res.append(this.valueOf(buf.toString().trim(), map));
                        buf.setLength(0);
                        state = 0;
                        continue block13;
                    }
                    case 10: {
                        res.append(string.substring(mpos, pos));
                        --pos;
                        buf.setLength(0);
                        state = 0;
                    }
                }
            }
            return res.toString();
        }

        protected final void setupPredefined(ExpanderStyle style) {
            String osname;
            String soext;
            if (this.hostInfo == null) {
                return;
            }
            switch (this.hostInfo.getOSFamily()) {
                case WINDOWS: {
                    soext = "dll";
                    osname = "Windows";
                    break;
                }
                case MACOSX: {
                    soext = "dylib";
                    osname = "MacOSX";
                    break;
                }
                case SUNOS: {
                    soext = "so";
                    osname = "SunOS";
                    break;
                }
                case LINUX: {
                    soext = "so";
                    osname = "Linux";
                    break;
                }
                default: {
                    osname = this.hostInfo.getOSFamily().name();
                    soext = "so";
                }
            }
            HostInfo.OS os = this.hostInfo.getOS();
            this.predefinedMacros.put("hostname", this.hostInfo.getHostname().toLowerCase());
            this.predefinedMacros.put("soext", soext);
            this.predefinedMacros.put("osname", osname);
            this.predefinedMacros.put("isa", os.getBitness().toString());
            this.predefinedMacros.put("_isa", os.getBitness() == HostInfo.Bitness._64 ? "_64" : "");
            String platform = this.hostInfo.getCpuFamily().name().toLowerCase();
            if (style == ExpanderStyle.SUNSTUDIO_STYLE) {
                if ("x86".equals(platform)) {
                    platform = "intel";
                }
                platform = this.hostInfo.getOSFamily() == HostInfo.OSFamily.SUNOS ? platform + "-S2" : platform + "-" + osname;
            }
            this.predefinedMacros.put("platform", platform);
        }
    }
}

