/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.LocalNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.RemoteNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.PtyUtility;

public final class PtyNativeProcess
extends AbstractNativeProcess {
    private AbstractNativeProcess delegate = null;

    public PtyNativeProcess(NativeProcessInfo info) {
        super(new NativeProcessInfo(info, true));
    }

    @Override
    protected void create() throws Throwable {
        String line;
        ExecutionEnvironment env = this.info.getExecutionEnvironment();
        Pty pty = this.info.getPty();
        ArrayList<String> newArgs = new ArrayList<String>();
        if (pty != null) {
            newArgs.add("-p");
            newArgs.add(pty.getSlaveName());
        }
        if (FIX_ERASE_KEY_IN_TERMINAL.booleanValue()) {
            newArgs.add("--set-erase-key");
        }
        MacroMap envMap = this.info.getEnvironment();
        HashMap<String, String> removedEntries = new HashMap<String, String>();
        removedEntries.put("LD_PRELOAD", envMap.remove("LD_PRELOAD"));
        removedEntries.put("LD_PRELOAD_32", envMap.remove("LD_PRELOAD_32"));
        removedEntries.put("LD_PRELOAD_64", envMap.remove("LD_PRELOAD_64"));
        removedEntries.put("DYLD_INSERT_LIBRARIES", envMap.remove("DYLD_INSERT_LIBRARIES"));
        Iterator it = removedEntries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() == null) {
                it.remove();
                continue;
            }
            if (((String)entry.getValue()).isEmpty()) continue;
            newArgs.add("--env");
            newArgs.add(((String)entry.getKey()).trim() + "=" + ((String)entry.getValue()).trim());
        }
        String origCommand = this.info.getCommandLineForShell();
        if (origCommand != null) {
            newArgs.add(this.hostInfo.getShell());
            newArgs.add("-c");
            if (this.info.isRedirectError()) {
                newArgs.add("exec 2>&1; exec " + origCommand);
            } else {
                newArgs.add("exec " + origCommand);
            }
        } else {
            String processExecutable = this.info.getExecutable();
            if (this.hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                processExecutable = WindowsSupport.getInstance().convertToShellPath(processExecutable);
            }
            newArgs.add(processExecutable);
            newArgs.addAll(this.info.getArguments());
        }
        this.info.setCommandLine(null);
        this.info.setExecutable(PtyUtility.getInstance().getPath(env));
        this.info.setArguments(newArgs.toArray(new String[newArgs.size()]));
        this.info.setUnbuffer(false);
        NativeProcessInfo delegateInfo = new NativeProcessInfo(this.info, false);
        this.delegate = env.isLocal() ? new LocalNativeProcess(delegateInfo) : new RemoteNativeProcess(delegateInfo);
        this.delegate.createAndStart();
        InputStream inputStream = this.delegate.getInputStream();
        if (pty != null) {
            this.setInputStream(pty.getInputStream());
            this.setOutputStream(pty.getOutputStream());
        } else {
            this.setInputStream(inputStream);
            this.setOutputStream(this.delegate.getOutputStream());
        }
        this.setErrorStream(this.delegate.getErrorStream());
        String pidLine = null;
        String ttyLine = null;
        while ((line = this.readLine(inputStream)) != null && !(line = line.trim()).isEmpty()) {
            if (line.startsWith("PID=")) {
                pidLine = line.substring(4);
                continue;
            }
            if (!line.startsWith("TTY=")) continue;
            this.addProcessInfo(line);
            ttyLine = line;
        }
        if (pidLine == null || ttyLine == null) {
            String error = ProcessUtils.readProcessErrorLine(this);
            throw new IOException("Unable to start pty process: " + error);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(pidLine.getBytes());
        this.readPID(bis);
    }

    @Override
    protected int waitResult() throws InterruptedException {
        if (this.delegate == null) {
            return 1;
        }
        int result = this.delegate.waitResult();
        this.finishing();
        return result;
    }

    private String readLine(InputStream is) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder(20);
        while (!this.isInterrupted() && (c = is.read()) >= 0 && c != 10) {
            sb.append((char)c);
        }
        return sb.toString().trim();
    }
}

