/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.File;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Utilities;

public final class NativeProcessInfo {
    public final MacroExpanderFactory.MacroExpander macroExpander;
    private final ExecutionEnvironment execEnv;
    private final boolean isWindows;
    private final MacroMap environment;
    private final List<String> arguments = new ArrayList<String>();
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private String executable;
    private String commandLine;
    private String workingDirectory;
    private boolean unbuffer;
    private boolean redirectError;
    private boolean x11forwarding;
    private boolean suspend;
    private Pty pty = null;
    private boolean runInPty;
    private boolean expandMacros = true;
    private Charset charset;
    private boolean statusEx;

    public NativeProcessInfo(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
        this.executable = null;
        this.unbuffer = false;
        this.workingDirectory = null;
        this.macroExpander = MacroExpanderFactory.getExpander(execEnv);
        this.environment = MacroMap.forExecEnv(execEnv);
        this.isWindows = execEnv.isLocal() && Utilities.isWindows();
        this.redirectError = false;
    }

    NativeProcessInfo(NativeProcessInfo info, boolean copyListeners) {
        this.macroExpander = info.macroExpander;
        this.execEnv = info.execEnv;
        this.isWindows = info.isWindows;
        this.environment = info.environment.clone();
        this.arguments.addAll(info.arguments);
        this.executable = info.executable;
        this.commandLine = info.commandLine;
        this.workingDirectory = info.workingDirectory;
        this.unbuffer = info.unbuffer;
        this.redirectError = info.redirectError;
        this.x11forwarding = info.x11forwarding;
        this.suspend = info.suspend;
        if (copyListeners) {
            this.listeners.addAll(info.getListenersSnapshot());
        }
        this.pty = info.pty;
        this.runInPty = info.runInPty;
        this.expandMacros = info.expandMacros;
        this.charset = info.charset;
        this.statusEx = info.statusEx;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void redirectError(boolean redirectError) {
        this.redirectError = redirectError;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    @Deprecated
    public void setCommandLine(String commandLine) {
        if (this.isWindows && commandLine != null) {
            String[] cmdAndArgs = Utilities.parseParameters((String)commandLine);
            if (cmdAndArgs.length == 0) {
                return;
            }
            String execFile = cmdAndArgs[0];
            this.setExecutable(execFile);
            if (cmdAndArgs.length == 1) {
                return;
            }
            ArrayList<String> args = new ArrayList<String>(cmdAndArgs.length - 1);
            for (int i = 1; i < cmdAndArgs.length; ++i) {
                args.add(cmdAndArgs[i]);
            }
            this.setArguments(args.toArray(new String[0]));
        } else {
            this.commandLine = commandLine;
        }
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setUnbuffer(boolean unbuffer) {
        this.unbuffer = unbuffer;
    }

    public boolean isUnbuffer() {
        return this.unbuffer;
    }

    public void setX11Forwarding(boolean x11forwarding) {
        this.x11forwarding = x11forwarding;
    }

    public boolean getX11Forwarding() {
        return this.x11forwarding;
    }

    public void setInitialSuspend(boolean suspend) {
        this.suspend = suspend;
    }

    public boolean getInitialSuspend() {
        return this.suspend;
    }

    public void setArguments(String ... arguments) {
        if (this.commandLine != null) {
            throw new IllegalStateException("commandLine is already defined. No additional parameters can be set");
        }
        this.arguments.clear();
        if (arguments != null) {
            for (String arg : arguments) {
                this.arguments.add(arg.trim());
            }
        }
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getCommand() {
        if (this.executable == null && this.commandLine == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.commandLine != null) {
            String cmd;
            try {
                cmd = this.isExpandMacros() ? this.macroExpander.expandPredefinedMacros(this.commandLine) : this.executable;
            }
            catch (Exception ex) {
                cmd = this.executable;
            }
            result.add(cmd);
        } else {
            String cmd;
            try {
                cmd = this.isExpandMacros() ? this.macroExpander.expandPredefinedMacros(this.executable) : this.executable;
            }
            catch (Exception ex) {
                cmd = this.executable;
            }
            if (this.execEnv.isLocal()) {
                cmd = this.findFullPathToExceutable(cmd);
            }
            result.add(cmd);
            for (String arg : this.arguments) {
                if (this.isExpandMacros()) {
                    if ((arg = Utilities.escapeParameters((String[])new String[]{arg})).startsWith("'") && arg.endsWith("'") || arg.startsWith("\"") && arg.endsWith("\"")) {
                        arg = arg.substring(1, arg.length() - 1);
                    }
                    result.add('\"' + arg + '\"');
                    continue;
                }
                result.add(arg);
            }
        }
        return result;
    }

    private String quoteSpecialChars(String orig) {
        StringBuilder sb = new StringBuilder();
        String escapeChars = this.isWindows ? " &\"'()" : " &\"'()!";
        for (char c : orig.toCharArray()) {
            if (escapeChars.indexOf(c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void setStatusEx(boolean getStatus) {
        this.statusEx = getStatus;
    }

    public String getCommandLineForShell() {
        if (this.commandLine == null && this.executable == null) {
            return null;
        }
        if (this.commandLine != null) {
            return this.commandLine;
        }
        StringBuilder sb = new StringBuilder();
        List<String> cmd = this.getCommand();
        String exec = cmd.get(0);
        if (this.isWindows && (exec = WindowsSupport.getInstance().convertToShellPath(exec)) == null) {
            return null;
        }
        sb.append(this.quoteSpecialChars(exec)).append(' ');
        String[] sarg = new String[1];
        for (String arg : this.arguments) {
            boolean escape = false;
            sarg[0] = arg;
            arg = Utilities.escapeParameters((String[])sarg);
            sb.append('\"');
            if (arg.startsWith("'") && arg.endsWith("'") || arg.startsWith("\"") && arg.endsWith("\"")) {
                arg = arg.substring(1, arg.length() - 1);
                escape = true;
            }
            if (this.isWindows || escape) {
                int pc = 120;
                for (int n : arg.toCharArray()) {
                    if (n == 36 && pc != 92) {
                        sb.append('\\');
                    }
                    sb.append((char)n);
                    pc = n;
                }
            } else {
                sb.append(arg);
            }
            sb.append("\" ");
        }
        return sb.toString().trim();
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    Collection<ChangeListener> getListenersSnapshot() {
        return new LinkedList<ChangeListener>(this.listeners);
    }

    public String getWorkingDirectory(boolean expandMacros) {
        String result = this.workingDirectory;
        if (expandMacros && this.macroExpander != null) {
            try {
                result = this.macroExpander.expandPredefinedMacros(this.workingDirectory);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public MacroMap getEnvironment() {
        return this.environment;
    }

    public void setPty(Pty pty) {
        this.pty = pty;
        this.runInPty = pty != null;
    }

    public Pty getPty() {
        return this.pty;
    }

    public void setPtyMode(boolean ptyMode) {
        this.runInPty = ptyMode;
        if (!ptyMode) {
            this.pty = null;
        }
    }

    public boolean isPtyMode() {
        return this.runInPty || this.getPty() != null;
    }

    public boolean isExpandMacros() {
        return this.expandMacros;
    }

    public void setExpandMacros(boolean expandMacros) {
        this.expandMacros = expandMacros;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private String findFullPathToExceutable(String cmd) {
        File f;
        if (this.execEnv.isRemote()) {
            return cmd;
        }
        if (!this.isWindows && cmd.startsWith("/") && (f = new File(cmd)).exists()) {
            return f.getAbsolutePath();
        }
        if (this.isWindows && cmd.length() > 2 && cmd.charAt(1) == ':') {
            f = new File(cmd);
            if (f.exists()) {
                return f.getAbsolutePath();
            }
            f = new File(cmd + ".exe");
            if (f.exists()) {
                return f.getAbsolutePath();
            }
        }
        if ((f = new File(this.workingDirectory, cmd)).exists()) {
            return f.getAbsolutePath();
        }
        if (this.isWindows && (f = new File(this.workingDirectory, cmd + ".exe")).exists()) {
            return f.getAbsolutePath();
        }
        return cmd;
    }

    boolean isStatusEx() {
        return this.statusEx;
    }

    boolean isCommandLineDefined() {
        return this.commandLine != null;
    }

    boolean isRedirectError() {
        return this.redirectError;
    }

    public static String getCharset(NativeProcess process) {
        if (process instanceof AbstractNativeProcess) {
            return ((AbstractNativeProcess)process).getCharset();
        }
        return null;
    }
}

